/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.framework.oss.util;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tcbj.yxy.framework.oss.config.OssConfig;
import com.tcbj.yxy.framework.oss.util.DateUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssUtil {
    private static final Logger logger = LoggerFactory.getLogger(OssUtil.class);
    @Autowired
    OssConfig ossConfig;

    public static OSS getClient() {
        return new OSSClientBuilder().build("oss-cn-shenzhen.aliyuncs.com", "LTAI4G8KY6egN7iYF16L8fye", "ZWumvY4ZXP8zXcPTJNEMpVpwMZoL2W");
    }

    public static String uploadFile(String oriFileName, String path, InputStream fileStream) {
        String url = "";
        String fileType = "";
        if (oriFileName.lastIndexOf(".") > 0) {
            fileType = oriFileName.substring(oriFileName.lastIndexOf("."));
        }
        String webName = UUID.randomUUID().toString().replaceAll("-", "") + DateUtils.dateToStr(new Date(), "yyyyMMddHHmmss");
        try {
            OSS ossClient = OssUtil.getClient();
            String fileName = webName + fileType;
            fileName = "new_yxy/" + path + "/" + fileName;
            ossClient.putObject("ssc-message", fileName, fileStream);
            ossClient.shutdown();
            url = "http://ssc-message.oss-cn-shenzhen.aliyuncs.com/" + fileName;
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getFileInputStream(String path) {
        OSS client = OssUtil.getClient();
        OSSObject ossObject = client.getObject(new OssConfig().getBucketname(), path);
        InputStream objectContent = ossObject.getObjectContent();
        return objectContent;
    }

    public static ByteArrayOutputStream inputStreamParseOutputStream(InputStream in) throws Exception {
        int ch;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            swapStream.write(ch);
        }
        return swapStream;
    }

    public static InputStream getFileInputStreamAll(String path) {
        logger.info("\u5f00\u59cb\u83b7\u53d6" + path + "\u6587\u4ef6\u7684\u8f93\u5165\u6d41InputStream");
        OSS client = OssUtil.getClient();
        path = path.substring(path.lastIndexOf("com/") + 4);
        OSSObject ossObject = client.getObject(new OssConfig().getBucketname(), path);
        InputStream objectContent = ossObject.getObjectContent();
        return objectContent;
    }

    public static String writeExcelToOss(ByteArrayOutputStream ba, String path) {
        logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230Oss\u7684" + path + "\u6587\u4ef6\u5939\u4e0b");
        ByteArrayInputStream bio = new ByteArrayInputStream(ba.toByteArray());
        OSS client = OssUtil.getClient();
        String webName = UUID.randomUUID().toString().replaceAll("-", "") + DateUtils.dateToStr(new Date(), "yyyyMMddHHmmss");
        String fileName = webName + ".xlsx";
        fileName = new OssConfig().getFirstPath() + "/" + path + "/" + fileName;
        PutObjectResult putObjectResult = client.putObject(new PutObjectRequest(new OssConfig().getBucketname(), fileName, (InputStream)bio));
        client.shutdown();
        String url = new OssConfig().getIndexUrl() + "/" + fileName;
        logger.info("\u5df2\u7ecf\u4e0a\u4f20\u6587\u4ef6\u5230Oss");
        return url;
    }

    public static String writeExcelToOssGetPath(ByteArrayOutputStream ba, String path) {
        logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230Oss\u7684" + path + "\u6587\u4ef6\u5939\u4e0b");
        ByteArrayInputStream bio = new ByteArrayInputStream(ba.toByteArray());
        OSS client = OssUtil.getClient();
        String webName = UUID.randomUUID().toString().replaceAll("-", "") + DateUtils.dateToStr(new Date(), "yyyyMMddHHmmss");
        String fileName = webName + ".xlsx";
        fileName = new OssConfig().getFirstPath() + "/" + path + "/" + fileName;
        PutObjectResult putObjectResult = client.putObject(new PutObjectRequest(new OssConfig().getBucketname(), fileName, (InputStream)bio));
        client.shutdown();
        String url = fileName;
        logger.info("\u5df2\u7ecf\u4e0a\u4f20\u6587\u4ef6\u5230Oss");
        return url;
    }

    public static String creatZip(List<String> pathList, String path) {
        String url = null;
        try {
            OSS ossClient = OssUtil.getClient();
            String yyyyMMddhhmmss = DateUtils.dateToStr(new Date(), "yyyyMMddhhmmss");
            String fileName = yyyyMMddhhmmss + ".zip";
            File zipFile = null;
            zipFile = File.createTempFile(yyyyMMddhhmmss, ".zip");
            FileOutputStream f = new FileOutputStream(zipFile);
            CheckedOutputStream csum = new CheckedOutputStream(f, new Adler32());
            ZipOutputStream zos = new ZipOutputStream(csum);
            for (String stringPath : pathList) {
                OSSObject ossObject = ossClient.getObject(new OssConfig().getBucketname(), stringPath);
                InputStream inputStream = ossObject.getObjectContent();
                zos.putNextEntry(new ZipEntry(stringPath.split("/")[2]));
                int bytesRead = 0;
                while ((bytesRead = inputStream.read()) != -1) {
                    zos.write(bytesRead);
                }
                inputStream.close();
                zos.closeEntry();
            }
            zos.close();
            FileInputStream fis = new FileInputStream(zipFile);
            BufferedInputStream buff = new BufferedInputStream(fis);
            fileName = new OssConfig().getFirstPath() + "/" + path + "ZIP" + "/" + fileName;
            PutObjectResult putObjectResult = ossClient.putObject(new PutObjectRequest(new OssConfig().getBucketname(), fileName, (InputStream)buff));
            url = new OssConfig().getIndexUrl() + "/" + fileName;
            fis.close();
            buff.close();
            ossClient.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("\u5df2\u7ecf\u4e0a\u4f20\u6587\u4ef6\u5230Oss");
        return url;
    }

    public static boolean deleteFile(String filePath) {
        logger.info("\u5f00\u59cb\u5220\u9664Oss\u7684\u6587\u4ef6\uff1a" + filePath);
        OSS ossClient = OssUtil.getClient();
        boolean exist = ossClient.doesObjectExist(new OssConfig().getBucketname(), filePath);
        if (!exist) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728," + filePath, (Object)filePath);
            return false;
        }
        logger.info("\u5220\u9664\u6587\u4ef6," + filePath, (Object)filePath);
        ossClient.deleteObject(new OssConfig().getBucketname(), filePath);
        ossClient.shutdown();
        logger.info("\u5220\u9664Oss\u7684\u6587\u4ef6\u7ed3\u675f");
        return true;
    }

    public static boolean isExist(String filePath) {
        OSS ossClient = OssUtil.getClient();
        boolean exist = ossClient.doesObjectExist(new OssConfig().getBucketname(), filePath);
        if (!exist) {
            return false;
        }
        ossClient.shutdown();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downFilesFromOss(String key, String localPath) {
        OSS client = OssUtil.getClient();
        try {
            client.getObject(new GetObjectRequest(new OssConfig().getBucketname(), key), new File(localPath + key));
        }
        catch (OSSException oe) {
            boolean bl = false;
            return bl;
        }
        catch (ClientException ce) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            client.shutdown();
        }
        return true;
    }
}

