/*
 * Decompiled with CFR 0.152.
 */
package com.vicutu.center.exchange.api.dto.base;

import com.alibaba.fastjson.JSON;
import com.google.common.base.VerifyException;
import com.vicutu.center.exchange.api.utils.IgnoreDTDEntityResolver;
import com.vicutu.center.exchange.api.utils.SignUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class BaseDto
implements Serializable {
    private String sign;

    public Map<String, String> bean2Map() {
        return (Map)JSON.parseObject((String)this.toString(), TreeMap.class);
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public BaseDto json2Bean(String jsonData) {
        return (BaseDto)JSON.parseObject((String)jsonData, this.getClass());
    }

    public BaseDto map2Bean(Map<String, String> mapData) {
        return (BaseDto)JSON.parseObject((String)JSON.toJSONString(mapData), this.getClass());
    }

    public Map<String, String> xml2Map(String xml) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
        Element rootElement = document.getRootElement();
        TreeMap<String, String> simMap = new TreeMap<String, String>();
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            simMap.put(element.getName(), element.getText());
        }
        return simMap;
    }

    public Map<Object, Object> json2Map(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    public List<Object> json2List(String json) {
        return (List)JSON.parseObject((String)json, List.class);
    }

    public boolean verifySign(String salt) throws VerifyException {
        return this.verifySign(this.bean2Map(), salt);
    }

    public boolean verifySign(Map<String, String> map, String salt) throws VerifyException {
        try {
            String localSign;
            String sig = this.getSign();
            if (map.containsKey("sign")) {
                map.remove("sign");
            }
            if (!(localSign = SignUtil.MD5(map, salt)).equalsIgnoreCase(sig)) {
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VerifyException("INVALID_SIGN:\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public void doEncrypt(String salt) throws Exception {
        this.doEncrypt(this.bean2Map(), salt);
    }

    public void doEncrypt(Map<String, String> map, String salt) throws Exception {
        if (map.containsKey("sign")) {
            map.remove("sign");
        }
        this.setSign(SignUtil.MD5(map, salt));
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}

