/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[2];

    public static int getSubnodeIndex(Interval interval, double centre) {
        int subnodeIndex = -1;
        if (interval.min >= centre) {
            subnodeIndex = 1;
        }
        if (interval.max <= centre) {
            subnodeIndex = 0;
        }
        return subnodeIndex;
    }

    public List getItems() {
        return this.items;
    }

    public void add(Object item) {
        this.items.add(item);
    }

    public List addAllItems(List items) {
        items.addAll(this.items);
        int i = 0;
        while (i < 2) {
            if (this.subnode[i] != null) {
                this.subnode[i].addAllItems(items);
            }
            ++i;
        }
        return items;
    }

    protected abstract boolean isSearchMatch(Interval var1);

    public void addAllItemsFromOverlapping(Interval interval, Collection resultItems) {
        if (interval != null && !this.isSearchMatch(interval)) {
            return;
        }
        resultItems.addAll(this.items);
        if (this.subnode[0] != null) {
            this.subnode[0].addAllItemsFromOverlapping(interval, resultItems);
        }
        if (this.subnode[1] != null) {
            this.subnode[1].addAllItemsFromOverlapping(interval, resultItems);
        }
    }

    public boolean remove(Interval itemInterval, Object item) {
        if (!this.isSearchMatch(itemInterval)) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < 2) {
            if (this.subnode[i] != null && (found = this.subnode[i].remove(itemInterval, item))) {
                if (!this.subnode[i].isPrunable()) break;
                this.subnode[i] = null;
                break;
            }
            ++i;
        }
        if (found) {
            return found;
        }
        found = this.items.remove(item);
        return found;
    }

    public boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public boolean hasChildren() {
        int i = 0;
        while (i < 2) {
            if (this.subnode[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    int depth() {
        int maxSubDepth = 0;
        int i = 0;
        while (i < 2) {
            int sqd;
            if (this.subnode[i] != null && (sqd = this.subnode[i].depth()) > maxSubDepth) {
                maxSubDepth = sqd;
            }
            ++i;
        }
        return maxSubDepth + 1;
    }

    int size() {
        int subSize = 0;
        int i = 0;
        while (i < 2) {
            if (this.subnode[i] != null) {
                subSize += this.subnode[i].size();
            }
            ++i;
        }
        return subSize + this.items.size();
    }

    int nodeSize() {
        int subSize = 0;
        int i = 0;
        while (i < 2) {
            if (this.subnode[i] != null) {
                subSize += this.subnode[i].nodeSize();
            }
            ++i;
        }
        return subSize + 1;
    }
}

