/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts;

import java.util.Objects;

public enum OrderType {
    COMMON("COMMON", 0, "common_order", "\u666e\u901a\u8ba2\u5355"),
    ADVANCE_SALE("ADVANCE_SALE", 1, "pre_sale_order", "\u9884\u552e\u8ba2\u5355"),
    STATE_SUBSIDIES("STATE_SUBSIDIES", 11, "common_order", "\u56fd\u8865\u8ba2\u5355"),
    GROUP_BOOKING("GROUP_BOOKING", 2, "common_order", "\u62fc\u56e2\u8ba2\u5355"),
    VIRTUAL_ORDER("VIRTUAL_ORDER", 3, "virtual_order", "\u865a\u62df\u8ba2\u5355"),
    INFERIOR_QUALITY_ORDER("INFERIOR_QUALITY_ORDER", 4, "inferior_quality_order", "\u6b21\u54c1\u9500\u552e\u8ba2\u5355"),
    EXCHANGE_ORDER("EXCHANGE_ORDER", 5, "exchange_order", "\u6362\u8d27\u8ba2\u5355"),
    RECEIVE_ORDER("RECEIVE_ORDER", 6, "receive_order", "\u9886\u7528\u8ba2\u5355"),
    REPLENISH_ORDER("REPLENISH_ORDER", 7, "replenish_order", "\u8865\u53d1\u8ba2\u5355"),
    CONSIGNMENT_ORDER("CONSIGNMENT_ORDER", 8, "consignment_order", "\u501f\u673a\u5bc4\u552e\u8ba2\u5355"),
    AFTER_SALE_ORDER("AFTER_SALE_ORDER", 9, "after_sale_order", "\u552e\u540e\u8ba2\u5355");

    private final String code;
    private final Integer type;
    private final String tradeCode;
    private final String name;

    public static OrderType getByCode(String code) {
        for (OrderType channel : OrderType.values()) {
            if (!Objects.equals(code, channel.getCode())) continue;
            return channel;
        }
        return null;
    }

    public static OrderType getByType(Integer type) {
        for (OrderType channel : OrderType.values()) {
            if (!Objects.equals(type, channel.getType())) continue;
            return channel;
        }
        return null;
    }

    public static String getNameByCode(String code) {
        OrderType orderType = OrderType.getByCode(code);
        if (Objects.isNull((Object)orderType)) {
            return null;
        }
        return orderType.getName();
    }

    public static String getNameByType(Integer type) {
        OrderType orderType = OrderType.getByType(type);
        if (Objects.isNull((Object)orderType)) {
            return null;
        }
        return orderType.getName();
    }

    public boolean equalsCode(String code) {
        return this.getCode().equals(code);
    }

    public boolean equalsType(Integer type) {
        return this.getType().equals(type);
    }

    public String getCode() {
        return this.code;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "OrderType." + this.name() + "(code=" + this.getCode() + ", type=" + this.getType() + ", tradeCode=" + this.getTradeCode() + ", name=" + this.getName() + ")";
    }

    private OrderType(String code, Integer type, String tradeCode, String name) {
        this.code = code;
        this.type = type;
        this.tradeCode = tradeCode;
        this.name = name;
    }
}

