/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum InventoryTypeEnum {
    qualified("qualified", "ZP"),
    un_qualified("un_qualified", "CC"),
    wait_inspection("wait_inspection", "QC"),
    freeze("freeze", "DJ");

    private String code;
    private String desc;
    public static final Map<String, InventoryTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private InventoryTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static InventoryTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static String getDesc(String index) {
        for (InventoryTypeEnum inventoryTypeEnum : InventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getCode().equals(index)) continue;
            return inventoryTypeEnum.getDesc();
        }
        return null;
    }

    public static String getCode(String index) {
        for (InventoryTypeEnum inventoryTypeEnum : InventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getDesc().equals(index)) continue;
            return inventoryTypeEnum.getCode();
        }
        return null;
    }

    public static InventoryTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.asList(InventoryTypeEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

    static {
        CODE_LOOKUP = Arrays.stream(InventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(InventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

