/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum TransferOrderStatus {
    NORMAL("NORMAL", 0, "\u6b63\u5e38"),
    ABNORMITY("ABNORMITY", 1, "\u5f02\u5e38"),
    CANCELLATION("CANCELLATION", 2, "\u4f5c\u5e9f");

    private final String code;
    private final Integer status;
    private final String name;

    public static TransferOrderStatus getByCode(String code) {
        for (TransferOrderStatus orderStatus : TransferOrderStatus.values()) {
            if (!Objects.equals(code, orderStatus.getCode())) continue;
            return orderStatus;
        }
        return null;
    }

    public static TransferOrderStatus getByStatus(Integer status) {
        for (TransferOrderStatus orderStatus : TransferOrderStatus.values()) {
            if (!Objects.equals(status, orderStatus.getStatus())) continue;
            return orderStatus;
        }
        return null;
    }

    public static String getNameByStatus(Integer status) {
        TransferOrderStatus orderStatus = TransferOrderStatus.getByStatus(status);
        if (Objects.isNull((Object)orderStatus)) {
            return "";
        }
        return orderStatus.getName();
    }

    public static String getNameByCode(String code) {
        TransferOrderStatus orderStatus = TransferOrderStatus.getByCode(code);
        if (Objects.isNull((Object)orderStatus)) {
            return "";
        }
        return orderStatus.getName();
    }

    public static List<Integer> getAvailable() {
        return Arrays.asList(NORMAL.getStatus(), ABNORMITY.getStatus());
    }

    public boolean equalsCode(String code) {
        return this.getCode().equals(code);
    }

    public boolean equalsStatus(Integer status) {
        return this.getStatus().equals(status);
    }

    public String getCode() {
        return this.code;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "TransferOrderStatus." + this.name() + "(code=" + this.getCode() + ", status=" + this.getStatus() + ", name=" + this.getName() + ")";
    }

    private TransferOrderStatus(String code, Integer status, String name) {
        this.code = code;
        this.status = status;
        this.name = name;
    }
}

