/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts;

import java.util.Arrays;
import java.util.Objects;

public enum PlatformOrderStatus {
    UNPAID("UNPAID", "\u5f85\u652f\u4ed8"),
    HAVE_PAID("HAVE_PAID", "\u5f85\u53d1\u8d27"),
    PORTION_DELIVERY("PORTION_DELIVERY", "\u90e8\u5206\u53d1\u8d27"),
    DELIVERED("DELIVERED", "\u5f85\u6536\u8d27"),
    RECEIVED("RECEIVED", "\u5df2\u7b7e\u6536"),
    COMPLETE("COMPLETE", "\u5df2\u5b8c\u6210"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88");

    public final String code;
    public final String desc;

    public static PlatformOrderStatus getByCode(String code) {
        return Arrays.stream(PlatformOrderStatus.values()).filter(val -> val.getCode().equals(code)).findFirst().orElse(null);
    }

    public static PlatformOrderStatus getByStatusToDefault(String code) {
        PlatformOrderStatus platformOrderStatus = PlatformOrderStatus.getByCode(code);
        if (Objects.nonNull((Object)platformOrderStatus)) {
            return platformOrderStatus;
        }
        return UNPAID;
    }

    public static boolean orderStatusCheck(String covertOrderStatus) {
        return DELIVERED.getCode().equals(covertOrderStatus) || RECEIVED.getCode().equals(covertOrderStatus) || COMPLETE.getCode().equals(covertOrderStatus);
    }

    public static boolean orderStatusHave(String covertOrderStatus) {
        return DELIVERED.getCode().equals(covertOrderStatus) || RECEIVED.getCode().equals(covertOrderStatus);
    }

    public static boolean orderStatusUnpaid(String covertOrderStatus) {
        return UNPAID.getCode().equals(covertOrderStatus) || CANCEL.getCode().equals(covertOrderStatus);
    }

    public boolean equalsCode(String code) {
        return this.getCode().equals(code);
    }

    public static String getDescByCode(String code) {
        for (PlatformOrderStatus orderStatus : PlatformOrderStatus.values()) {
            if (!orderStatus.getCode().equals(code)) continue;
            return orderStatus.getDesc();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return "PlatformOrderStatus." + this.name() + "(code=" + this.getCode() + ", desc=" + this.getDesc() + ")";
    }

    private PlatformOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

