/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ItemUnitEnum {
    MM("mm", "\u6beb\u7c73"),
    CM("cm", "\u5398\u7c73"),
    DM("dm", "\u5206\u7c73"),
    M("m", "\u7c73"),
    KM("km", "\u5343\u7c73"),
    M3("m3", "\u7acb\u65b9\u7c73"),
    CM3("cm3", "\u7acb\u65b9\u5398\u7c73"),
    DM3("dm3", "\u7acb\u65b9\u5206\u7c73"),
    MM3("mm3", "\u7acb\u65b9\u6beb\u7c73"),
    g("g", "\u514b"),
    kg("kg", "\u5343\u514b"),
    ton("ton", "\u5428");

    private String code;
    private String name;
    public static final Map<String, ItemUnitEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private ItemUnitEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ItemUnitEnum forCode(String code) {
        if (CODE_LOOKUP.containsKey(code)) {
            return CODE_LOOKUP.get(code);
        }
        return null;
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ItemUnitEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ItemUnitEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.name));
    }
}

