/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory.conversion;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IWarehouseRelationApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.openapi.dto.e3.SkuDto;
import com.yunxi.dg.base.center.openapi.dto.e3.SyncInventoryDto;
import com.yunxi.dg.base.center.openapi.dto.e3.TransferOrderDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.CsInventoryLogDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorOutFlowConversion {
    private static final Logger log = LoggerFactory.getLogger(MonitorOutFlowConversion.class);
    @Resource
    private ITransferOrderApiProxy iTransferOrderApiProxy;
    @Autowired
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Autowired
    private IWarehouseRelationApiProxy iWarehouseRelationApiProxy;

    public SyncInventoryDto toSyncInventoryE3Dto(CsInventoryLogDto csInventoryLogDto, TransferOrderRespDto transferOrder, Map<String, WarehouseRelationDto> warehouseRelationMap) {
        SyncInventoryDto syncInventoryDto = new SyncInventoryDto();
        if (warehouseRelationMap.containsKey(transferOrder.getOutLogicWarehouseCode())) {
            WarehouseRelationDto warehouseRelationDto = warehouseRelationMap.get(transferOrder.getOutLogicWarehouseCode());
            syncInventoryDto.setWarehouseCode(warehouseRelationDto.getErpId());
            syncInventoryDto.setChannelCode(warehouseRelationDto.getE3ChannelCode());
        }
        ArrayList skuDtoList = Lists.newArrayList();
        SkuDto skuDto = new SkuDto();
        skuDto.setSkuCode(csInventoryLogDto.getSkuCode());
        skuDto.setItemCode(csInventoryLogDto.getSkuCode());
        skuDto.setNum(csInventoryLogDto.getBeforeBalance());
        skuDtoList.add(skuDto);
        syncInventoryDto.setSkuList((List)skuDtoList);
        log.info("\u51fa\u5e93\u6d41\u6c34\u4fe1\u606f\u8f6c\u6362:{}", (Object)JSON.toJSONString((Object)syncInventoryDto));
        return syncInventoryDto;
    }

    public TransferOrderDto toSyncTransferOrderE3Dto(CsInventoryLogDto csInventoryLogDto, TransferOrderRespDto transferOrderRespDto, Map<String, WarehouseRelationDto> warehouseRelationMap) {
        WarehouseRelationDto warehouseRelationDto;
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(csInventoryLogDto.getSourceNo());
        List detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.queryList(keyDto));
        AssertUtils.notEmpty((Collection)detailRespDtoList, (String)"\u8c03\u62e8\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        TransferOrderDto dto = new TransferOrderDto();
        dto.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
        dto.setAuditStatus(YesNoHelper.NO);
        dto.setBizDate(transferOrderRespDto.getBizDate());
        dto.setRemark(transferOrderRespDto.getRemark());
        if (warehouseRelationMap.containsKey(transferOrderRespDto.getOutLogicWarehouseCode())) {
            warehouseRelationDto = warehouseRelationMap.get(transferOrderRespDto.getOutLogicWarehouseCode());
            dto.setOutWarehouseCode(warehouseRelationDto.getErpId());
            dto.setOutOrgCode(warehouseRelationDto.getE3ChannelCode());
        }
        if (warehouseRelationMap.containsKey(transferOrderRespDto.getOutLogicWarehouseCode())) {
            warehouseRelationDto = warehouseRelationMap.get(transferOrderRespDto.getInLogicWarehouseCode());
            dto.setInWarehouseCode(warehouseRelationDto.getErpId());
            dto.setInOrgCode(warehouseRelationDto.getE3ChannelCode());
        }
        ArrayList skuDtoList = Lists.newArrayList();
        detailRespDtoList.forEach(detail -> {
            SkuDto skuDto = new SkuDto();
            skuDto.setNum(detail.getQuantity());
            skuDto.setSkuCode(detail.getSkuCode());
            skuDto.setItemCode(detail.getSkuCode());
            skuDtoList.add(skuDto);
        });
        dto.setSkuList((List)skuDtoList);
        return dto;
    }

    public List<TransferOrderDetailRespDto> getTransferOrderDetailRespDtos(CsInventoryLogDto csInventoryLogDto) {
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(csInventoryLogDto.getSourceNo());
        List transferOrderDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.queryList(keyDto));
        AssertUtils.notNull((Object)transferOrderDetailRespDtos, (String)"\u8c03\u62e8\u5355\u53f7\u660e\u7ec6\u4e3a\u7a7a");
        List skuCodeList = transferOrderDetailRespDtos.stream().map(TransferOrderDetailRespDto::getSkuCode).collect(Collectors.toList());
        List skuDgRespDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).orElse(org.assertj.core.util.Lists.newArrayList());
        Map<String, Integer> skuCodeMoreBarMap = skuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getMoreBar, (k1, k2) -> k1));
        log.info("\u67e5\u8be2\u5230\u5546\u54c1\u591a\u6761\u7801:{}", (Object)JSON.toJSONString(skuCodeMoreBarMap));
        transferOrderDetailRespDtos.forEach(transferOrderItemPageDto -> {
            if (skuCodeMoreBarMap.containsKey(transferOrderItemPageDto.getSkuCode())) {
                transferOrderItemPageDto.setMoreBar((Integer)skuCodeMoreBarMap.get(transferOrderItemPageDto.getSkuCode()));
            }
        });
        return transferOrderDetailRespDtos;
    }

    public TransferOrderRespDto getTransferOrder(String sourceNo) {
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(sourceNo);
        TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.detail(keyDto));
        AssertUtils.notNull((Object)transferOrderRespDto, (String)"\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u53f7");
        log.info("\u67e5\u8be2\u5230\u8c03\u62e8\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)transferOrderRespDto));
        return transferOrderRespDto;
    }

    public Map<String, WarehouseRelationDto> getWarehouseRelationMap(String outLogicWarehouseCode, String inLogicWarehouseCode) {
        ArrayList logicWarehouseCodeList = org.assertj.core.util.Lists.newArrayList((Object[])new String[]{outLogicWarehouseCode, inLogicWarehouseCode});
        WarehouseRelationPageReqDto reqDto = new WarehouseRelationPageReqDto();
        reqDto.setLogicWarehouseCodeList((List)logicWarehouseCodeList);
        List warehouseRelationDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iWarehouseRelationApiProxy.queryList(reqDto))).orElse(org.assertj.core.util.Lists.newArrayList());
        log.info("\u6839\u636e\u903b\u8f91\u4ed3\u67e5\u5230E3\u5173\u7cfb\u4ed3:{}", (Object)JSON.toJSONString((Object)warehouseRelationDtoList));
        Map<String, WarehouseRelationDto> warehouseRelationDtoMap = warehouseRelationDtoList.stream().collect(Collectors.toMap(WarehouseRelationDto::getLogicWarehouseCode, Function.identity(), (o1, o2) -> o1));
        return warehouseRelationDtoMap;
    }

    public void updateTransferE3Status(String transferOrderNo, String pushE3Status, String message, String externalOrderNo) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setTransferOrderNo(transferOrderNo);
        transferOrderReqDto.setPushE3Status(pushE3Status);
        transferOrderReqDto.setE3FailReason(message);
        transferOrderReqDto.setExternalOrderNo(externalOrderNo);
        RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.modifyE3Status(transferOrderReqDto));
    }
}

