/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.order;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpSaleOrderLineRequestDto;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpSaleOrderRequestDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="B2B_PUSH_AFTER_SALES_ORDER_TO_ERP_TAG")
public class AfterSaleOrderCreateProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(AfterSaleOrderCreateProcess.class);
    @Resource
    private IExternalInventoryErpApiProxy inventoryErpApiProxy;

    public MessageResponse process(MessageVo message) {
        log.info("\u552e\u540e\u5355\u521b\u5efa\u6210\u529f\u6d88\u606f\uff1a{}", (Object)LogUtils.buildLogContent((Object)message));
        try {
            DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)JSON.parseObject((String)JSON.toJSONString((Object)message.getData()), DgAfterSaleOrderRespDto.class);
            ErpSaleOrderRequestDto requestDto = new ErpSaleOrderRequestDto();
            requestDto.setCompanyCode(afterSaleOrderRespDto.getEnterpriseCode());
            requestDto.setCurrencyCode("CNY");
            requestDto.setCurrentPage("1");
            requestDto.setCustomerLocation(StringUtils.join((Object[])new String[]{afterSaleOrderRespDto.getReturnProvinceName(), afterSaleOrderRespDto.getReturnCityName(), afterSaleOrderRespDto.getReturnCountyName(), afterSaleOrderRespDto.getReturnAddress()}));
            requestDto.setCustomerName(afterSaleOrderRespDto.getCustomerName());
            requestDto.setCustomerNumber(afterSaleOrderRespDto.getCustomerCode());
            requestDto.setOrderCode("RETURN");
            requestDto.setOrderDate(DateUtil.formatDate((Date)afterSaleOrderRespDto.getCreateTime()));
            requestDto.setOrderNumber(StringUtils.join((Object[])new String[]{afterSaleOrderRespDto.getAfterSaleOrderNo(), "SO"}));
            requestDto.setOrderTypeName(AfterSaleOrderTypeEnum.forCode((String)afterSaleOrderRespDto.getAfterSaleOrderType()).getDesc());
            requestDto.setSourceId(String.valueOf(afterSaleOrderRespDto.getId()));
            requestDto.setTotalPage("1");
            ArrayList lines = Lists.newArrayList();
            for (DgAfterSaleOrderItemRespDto row : afterSaleOrderRespDto.getItemRespDtoList()) {
                ErpSaleOrderLineRequestDto lineRequestDto = new ErpSaleOrderLineRequestDto();
                lineRequestDto.setItemCode(row.getSkuCode());
                lineRequestDto.setItemDescription(row.getSkuName());
                lineRequestDto.setOrderQuantity(String.valueOf(row.getReturnNum()));
                lineRequestDto.setSourceLineId(String.valueOf(row.getId()));
                lineRequestDto.setUnitPrice(row.getRefundPrice().toString());
                lineRequestDto.setUom(row.getUnit());
                lines.add(lineRequestDto);
            }
            requestDto.setLine((List)lines);
            this.inventoryErpApiProxy.outStorage(requestDto);
        }
        catch (Exception e) {
            log.error("\u552e\u540e\u5355\u540c\u6b65ERP\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

