/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.IOcsLogisticsService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.ReceiveDeliveryResultOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.context.ReceiveDeliveryResultOrderContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@MQDesc(tag="outBack", msgType="publish")
@Component
public class LogisticsTrackSubOfDeliveryResultProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(LogisticsTrackSubOfDeliveryResultProcess.class);
    @Resource
    private IOcsLogisticsService ocsLogisticsService;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;

    public static void main(String[] args) {
        String code = "JDLD12287475480-5-5,JDLD12287475480-2-5,JDLD12287475480-1-5,JDLD12287475480-4-5,JDLD12287475480-3-5";
        System.out.println(code.split("-")[0]);
    }

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u7269\u6d41\u8f68\u8ff9\u8ba2\u9605process\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        try {
            ReceiveDeliveryResultOrderContext source = (ReceiveDeliveryResultOrderContext)JSONObject.parseObject((String)((String)message.getData()), ReceiveDeliveryResultOrderContext.class);
            ReceiveDeliveryResultOrderDto resultOrderDto = source.getReceiveDeliveryResultOrderEo();
            if (!resultOrderDto.getRelevanceTableName().equals("cs_order_sale") && !resultOrderDto.getRelevanceTableName().equals("cs_order_after_sale")) {
                log.info("\u65e0\u9700\u5904\u7406\u8be5\u5355\u636e");
                return MessageResponse.SUCCESS;
            }
            resultOrderDto.setShippingCode("JDDJ".equals(resultOrderDto.getShippingCompanyCode()) && StringUtils.isNotEmpty((CharSequence)resultOrderDto.getShippingCode()) ? resultOrderDto.getShippingCode().split("-")[0] : resultOrderDto.getShippingCode());
            this.ocsLogisticsService.saveLogisticsByResultOrder(resultOrderDto);
            String phoneNum = "";
            if (StringUtils.isNotBlank((CharSequence)resultOrderDto.getDeliveryPhysicsWarehouseCode())) {
                PhysicsWarehousePageReqDto reqDto = new PhysicsWarehousePageReqDto();
                reqDto.setWarehouseCodeList(Collections.singletonList(resultOrderDto.getDeliveryPhysicsWarehouseCode()));
                List physicsWarehouseDtos = null;
                physicsWarehouseDtos = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryListData(reqDto));
                if (Objects.nonNull(physicsWarehouseDtos) && ((PhysicsWarehouseDto)physicsWarehouseDtos.get(0)).getWarehouseCode().equals(resultOrderDto.getDeliveryPhysicsWarehouseCode())) {
                    log.info("\u53d1\u8d27\u7269\u7406\u4ed3\uff1a{}", (Object)JSONObject.toJSONString(physicsWarehouseDtos.get(0)));
                    phoneNum = ((PhysicsWarehouseDto)physicsWarehouseDtos.get(0)).getPhone();
                }
            }
            this.ocsLogisticsService.subscribe(resultOrderDto.getShippingCode(), resultOrderDto.getShippingCompanyCode(), phoneNum);
        }
        catch (Exception e) {
            log.error("\u7269\u6d41\u8f68\u8ff9\u8ba2\u9605\uff0c\u53d1\u8d27\u7ed3\u679c\u5355\u76d1\u542c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

