/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.account.constants;

import java.util.Arrays;

public enum CurrencyEnum {
    CNY("CNY", "\u4eba\u6c11\u5e01"),
    USD("USD", "\u7f8e\u5143");

    private final String code;
    private final String name;

    private CurrencyEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static CurrencyEnum getByCode(String code) {
        return Arrays.stream(CurrencyEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    public static String codeToName(String code) {
        CurrencyEnum newEnum = CurrencyEnum.getByCode(code);
        return newEnum == null ? null : newEnum.getName();
    }
}

