/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.excel;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BigDataParseExcel
extends DefaultHandler {
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int sheetIndex = -1;
    private int sheetNumber = 0;
    private List<String> rowlist = new ArrayList<String>();
    private int curRow = 0;
    private int curCol = 0;
    private int preCol = 0;
    private int titleRow = 0;
    private int rowsize = 0;

    public abstract void optRows(int var1, int var2, List<String> var3) throws SQLException;

    public void processOneSheet(String filename, int sheetId) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        InputStream sheet2 = r.getSheet("rId" + sheetId);
        ++this.sheetIndex;
        InputSource sheetSource = new InputSource(sheet2);
        parser.parse(sheetSource);
        sheet2.close();
    }

    public void process(String filename) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            if (this.sheetIndex >= this.sheetNumber) {
                return;
            }
            this.curRow = 0;
            ++this.sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public void process(InputStream inputStream) throws Exception {
        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            if (this.sheetIndex >= this.sheetNumber) {
                return;
            }
            this.curRow = 0;
            ++this.sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        this.sst = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("c")) {
            String cellType = attributes.getValue("t");
            String rowStr = attributes.getValue("r");
            this.curCol = this.getRowIndex(rowStr);
            this.nextIsString = cellType != null && cellType.equals("s");
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception idx) {
                // empty catch block
            }
        }
        if (name.equals("v")) {
            String value = this.lastContents.trim();
            value = value.equals("") ? " " : value;
            int cols = this.curCol - this.preCol;
            if (cols > 1) {
                for (int i = 0; i < cols - 1; ++i) {
                    this.rowlist.add(this.preCol, "");
                }
            }
            this.preCol = this.curCol;
            this.rowlist.add(this.curCol - 1, value);
        } else if (name.equals("row")) {
            int tmpCols = this.rowlist.size();
            if (this.curRow > this.titleRow && tmpCols < this.rowsize) {
                for (int i = 0; i < this.rowsize - tmpCols; ++i) {
                    this.rowlist.add(this.rowlist.size(), "");
                }
            }
            try {
                this.optRows(this.sheetIndex, this.curRow, this.rowlist);
            }
            catch (SQLException e) {
                throw new BizException(e.getMessage());
            }
            if (this.curRow == this.titleRow) {
                this.rowsize = this.rowlist.size();
            }
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
            this.preCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    public int getRowIndex(String rowStr) {
        rowStr = rowStr.replaceAll("[^A-Z]", "");
        byte[] rowAbc = rowStr.getBytes();
        int len = rowAbc.length;
        float num = 0.0f;
        for (int i = 0; i < len; ++i) {
            num = (float)((double)num + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        return (int)num;
    }

    public int getTitleRow() {
        return this.titleRow;
    }

    public void setTitleRow(int titleRow) {
        this.titleRow = titleRow;
    }

    public int getSheetNumber() {
        return this.sheetNumber;
    }

    public void setSheetNumber(int sheetNumber) {
        this.sheetNumber = sheetNumber;
    }
}

