/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.util.DateConverter;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.util.ReflectionUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.mgmt.excel.BigDataParseExcel;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcUtil
extends BigDataParseExcel {
    private static final Logger logger = LoggerFactory.getLogger(ExcUtil.class);
    private FileModeTypeEnum fileModeTypeEnum;
    private Map<String, String> fieldNameMap = new HashMap<String, String>();
    private Map<Integer, String> fixedIndexMap = new HashMap<Integer, String>();
    private List<String> headerTitle = new ArrayList<String>();
    private Map<Integer, String> indexHeaderMap = new HashMap<Integer, String>();
    private List list = new ArrayList();
    private List failList = new ArrayList();
    private boolean verfiyFail = false;

    public ExcUtil(FileModeTypeEnum fileModeTypeEnum) {
        this.fileModeTypeEnum = fileModeTypeEnum;
        Class importTemplate = fileModeTypeEnum.getImportTemplate();
        for (Field declaredField : importTemplate.getDeclaredFields()) {
            Excel annotation = declaredField.getAnnotation(Excel.class);
            if (Objects.isNull(annotation)) continue;
            Integer i = annotation.fixedIndex();
            if (i >= 0) {
                this.fixedIndexMap.put(i, annotation.name());
            }
            this.fieldNameMap.put(annotation.name(), declaredField.getName());
            this.headerTitle.add(annotation.name());
        }
    }

    @Override
    public void optRows(int sheetIndex, int curRow, List<String> rowlist) throws SQLException {
        ImportBaseModeDto dto = (ImportBaseModeDto)this.fileModeTypeEnum.getImportTemplate().newInstance();
        if (curRow == 0) {
            this.checkExcelHeader(rowlist, dto);
            return;
        }
        boolean emptyStr = this.isEmptyStr(rowlist);
        if (emptyStr) {
            return;
        }
        boolean flagFail = false;
        Integer i = 0;
        while (i < rowlist.size()) {
            String titleName = this.indexHeaderMap.get((int)i);
            String fieldName = this.fieldNameMap.get(titleName);
            Field accessibleField = ReflectionUtils.getAccessibleField((Object)dto, (String)fieldName);
            boolean result = this.verifyAnnotation(dto, accessibleField, rowlist.get(i));
            if (!result) {
                flagFail = true;
            }
            if (!StrUtil.isBlank((CharSequence)rowlist.get(i))) {
                Object val = rowlist.get(i);
                if (accessibleField.getType().getName().indexOf("Date") >= 0) {
                    val = rowlist.get(i).indexOf(".") >= 0 ? HSSFDateUtil.getJavaDate((double)Double.valueOf(rowlist.get(i))) : new DateConverter().convert(rowlist.get(i));
                }
                if (accessibleField.getType().getName().indexOf("Integer") >= 0 || accessibleField.getType().getName().indexOf("int") >= 0) {
                    val = Integer.valueOf(rowlist.get(i));
                }
                if (accessibleField.getType().getName().indexOf("BigDecimal") >= 0) {
                    val = new BigDecimal(rowlist.get(i));
                }
                ReflectionUtils.setFieldValue((Object)dto, (String)fieldName, (Object)val);
                dto.setRowNum(curRow);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (flagFail) {
            this.failList.add(dto);
            this.verfiyFail = true;
        }
        if (!flagFail) {
            this.list.add(dto);
        }
    }

    public List getList() {
        return this.list;
    }

    public List getFailList() {
        return this.failList;
    }

    public boolean isVerfiyFail() {
        return this.verfiyFail;
    }

    private boolean isEmptyStr(List<String> rowlist) {
        return rowlist.stream().allMatch(e -> StrUtil.isBlank((CharSequence)e));
    }

    private boolean verifyAnnotation(ImportBaseModeDto dto, Field accessibleField, String rowValue) {
        java.util.regex.Pattern p;
        Matcher m;
        if (StrUtil.isNotBlank((CharSequence)dto.getErrorMsg())) {
            return false;
        }
        NotBlank notBlank = accessibleField.getAnnotation(NotBlank.class);
        NotNull notNull = accessibleField.getAnnotation(NotNull.class);
        Pattern pattern = accessibleField.getAnnotation(Pattern.class);
        if (Objects.nonNull(notBlank) || Objects.nonNull(notNull)) {
            boolean flag;
            boolean bl = flag = Objects.isNull(rowValue) || rowValue == null || StrUtil.isBlank((CharSequence)rowValue);
            if (notBlank != null && flag) {
                dto.setErrorMsg(notBlank.message());
                return false;
            }
            if (notNull != null && flag) {
                dto.setErrorMsg(notNull.message());
                return false;
            }
        }
        if (Objects.nonNull(pattern) && Objects.nonNull(rowValue) && StrUtil.isNotBlank((CharSequence)rowValue) && !(m = (p = java.util.regex.Pattern.compile(pattern.regexp())).matcher(rowValue)).matches()) {
            dto.setErrorMsg(pattern.message());
            return false;
        }
        return true;
    }

    private void checkExcelHeader(List<String> rowlist, ImportBaseModeDto dto) {
        logger.info("checkExcelHeader.rowlist==>{}", JSON.toJSON(rowlist));
        logger.info("checkExcelHeader.fixedIndexMap==>{}", JSON.toJSON(this.fixedIndexMap));
        logger.info("checkExcelHeader.headerTitle==>{}", JSON.toJSON(this.headerTitle));
        for (int i = 0; i < rowlist.size(); ++i) {
            this.indexHeaderMap.put(i, rowlist.get(i));
        }
        if (CollectionUtil.isNotEmpty(this.fixedIndexMap)) {
            Integer i = 0;
            while (i < rowlist.size()) {
                AssertUtils.isTrue((boolean)this.fixedIndexMap.get(i + 1).equals(rowlist.get(i)), (String)"\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return;
        }
        String md5FieldNames = MD5Util.getMd5ByString((String)rowlist.toString());
        String md5HeaderNames = MD5Util.getMd5ByString((String)this.headerTitle.toString());
        AssertUtils.isTrue((boolean)md5FieldNames.equals(md5HeaderNames), (String)"\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
    }

    public static void main(String[] args) {
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("^\\d{4}-\\d{1,2}$");
        Matcher m = p.matcher("2011-89");
        System.out.println(m.matches());
    }
}

