/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dto.request.OrderBusinessTypeReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillBusinessTypeRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BusinessTypeRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderBusinessRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBusinessTypeApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IOrderBusinessTypeApiProxy;
import com.yunxi.dg.base.mgmt.service.FinancialManagementBookkeepingManagementBookkeepingOrderTypeManagementService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.BookkeepingOrderTypeBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.GetBookkeepingOrderTypeManagementListPageBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.GetBussinessTypeByOrderTypeBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.BookkeepingOrderTypeDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.BussinessTypeOfBookkeepingDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.OrderTypeOfBookkeepingDto;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinancialManagementBookkeepingManagementBookkeepingOrderTypeManagementServiceServiceImpl
implements FinancialManagementBookkeepingManagementBookkeepingOrderTypeManagementService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementBookkeepingManagementBookkeepingOrderTypeManagementServiceServiceImpl.class);
    @Resource
    private IOrderBusinessTypeApiProxy orderBusinessTypeApiProxy;
    @Resource
    private IBusinessTypeApiProxy businessTypeApiProxy;

    @Override
    public RestResponse<Object> addBookkeepingOrderType(@ApiParam(value="") @Valid @RequestBody(required=false) BookkeepingOrderTypeBody bookkeepingOrderTypeVO) {
        OrderBusinessTypeReqDto reqDto = new OrderBusinessTypeReqDto();
        reqDto.setId(bookkeepingOrderTypeVO.getId());
        reqDto.setOrderType(bookkeepingOrderTypeVO.getOrderTypeCode());
        reqDto.setBusinessType(bookkeepingOrderTypeVO.getBussinessTypeCode());
        reqDto.setOrderName(bookkeepingOrderTypeVO.getOrderTypeName());
        reqDto.setBusinessName(bookkeepingOrderTypeVO.getBussinessTypeName());
        logger.info("\u65b0\u589e\u8bb0\u8d26\u7ba1\u7406reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.orderBusinessTypeApiProxy.addOrderBusinessType(reqDto)));
    }

    @Override
    public RestResponse<Object> deleteBookkeepingOrderType(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ParamConverter.convertToLong((Object)id));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.orderBusinessTypeApiProxy.removeOrderBusinessType(list)));
    }

    @Override
    public RestResponse<PageInfo<BookkeepingOrderTypeDto>> getBookkeepingOrderTypeListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetBookkeepingOrderTypeManagementListPageBody getBookkeepingOrderTypeManagementListPageBody) {
        OrderBusinessTypeReqDto reqDto = new OrderBusinessTypeReqDto();
        reqDto.setOrderType(getBookkeepingOrderTypeManagementListPageBody.getOrderTypeCode());
        logger.info("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u7ba1\u7406\u5217\u8868reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderBusinessTypeApiProxy.queryPage(getBookkeepingOrderTypeManagementListPageBody.getPageNum(), getBookkeepingOrderTypeManagementListPageBody.getPageSize(), reqDto));
        logger.info("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u7ba1\u7406\u5217\u8868respDtoPageInfo:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BookkeepingOrderTypeDto vo = new BookkeepingOrderTypeDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessTypeName(o.getBusinessName());
            vo.setBussinessTypeCode(o.getBusinessType());
            vo.setBussinessTypeId(ParamConverter.convertToString((Object)o.getId()));
            vo.setOrderTypeName(o.getOrderName());
            vo.setOrderTypeCode(o.getOrderType());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<BussinessTypeOfBookkeepingDto>> getBussinessTypeByOrderTypeOfBookkeeping(@ApiParam(value="") @RequestBody(required=false) GetBussinessTypeByOrderTypeBody getBussinessTypeByOrderType) {
        OrderBusinessTypeReqDto reqDto = new OrderBusinessTypeReqDto();
        reqDto.setOrderType(getBussinessTypeByOrderType.getOrderTypeCode());
        List orderBusinessRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.orderBusinessTypeApiProxy.getOrderBusinessRelationList(reqDto));
        logger.info("\u83b7\u53d6\u8ba2\u5355\u7c7b\u578b\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578borderBusinessRespDtos:{}", (Object)JSON.toJSONString((Object)orderBusinessRespDtos));
        ArrayList<BussinessTypeOfBookkeepingDto> bussinessTypeOfBookkeepingVOList = new ArrayList<BussinessTypeOfBookkeepingDto>();
        if (CollectionUtils.isEmpty((Collection)orderBusinessRespDtos)) {
            return new RestResponse();
        }
        List types = ((OrderBusinessRespDto)orderBusinessRespDtos.get(0)).getTypes();
        for (OrderBusinessRespDto.BusinessType type : types) {
            BussinessTypeOfBookkeepingDto vo = new BussinessTypeOfBookkeepingDto();
            vo.setBussinessTypeName(type.getBusinessName());
            vo.setBussinessTypeCode(type.getBusinessType());
            bussinessTypeOfBookkeepingVOList.add(vo);
        }
        logger.info("\u83b7\u53d6\u8ba2\u5355\u7c7b\u578b\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578bbussinessTypeOfBookkeepingVOList:{}", (Object)JSON.toJSONString(bussinessTypeOfBookkeepingVOList));
        return new RestResponse(bussinessTypeOfBookkeepingVOList);
    }

    @Override
    public RestResponse<List<BussinessTypeOfBookkeepingDto>> getBussinessTypeOfBookkeeping() {
        BillBusinessTypeRespDto billBusinessTypeRespDto = (BillBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.businessTypeApiProxy.queryBillBusinessList());
        ArrayList<BussinessTypeOfBookkeepingDto> billBusinessTypelist = new ArrayList<BussinessTypeOfBookkeepingDto>();
        if (CollectionUtils.isNotEmpty((Collection)billBusinessTypeRespDto.getBusinessTypeRespDtos())) {
            List businessTypeRespDtos = billBusinessTypeRespDto.getBusinessTypeRespDtos();
            for (BusinessTypeRespDto business : businessTypeRespDtos) {
                BussinessTypeOfBookkeepingDto bussinessTypeOfBookkeepingVO = new BussinessTypeOfBookkeepingDto();
                bussinessTypeOfBookkeepingVO.setId(business.getId());
                bussinessTypeOfBookkeepingVO.setBussinessTypeName(business.getBusinessName());
                bussinessTypeOfBookkeepingVO.setBussinessTypeCode(business.getBusinessType());
                billBusinessTypelist.add(bussinessTypeOfBookkeepingVO);
            }
        }
        return new RestResponse(billBusinessTypelist);
    }

    @Override
    public RestResponse<List<OrderTypeOfBookkeepingDto>> getOrderTypeOfBookkeeping() {
        ArrayList<OrderTypeOfBookkeepingDto> orderTypeOfBookkeepingVOList = new ArrayList<OrderTypeOfBookkeepingDto>();
        BillBusinessTypeRespDto respDto = (BillBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.businessTypeApiProxy.queryBillBusinessList());
        for (Map map : respDto.getBillTypeLists()) {
            OrderTypeOfBookkeepingDto orderTypeOfBookkeepingVO = new OrderTypeOfBookkeepingDto();
            orderTypeOfBookkeepingVO.setOrderTypeCode(ParamConverter.convertToString(map.get("code")));
            orderTypeOfBookkeepingVO.setOrderTypeName(ParamConverter.convertToString(map.get("name")));
            orderTypeOfBookkeepingVOList.add(orderTypeOfBookkeepingVO);
        }
        return new RestResponse(orderTypeOfBookkeepingVOList);
    }

    @Override
    public RestResponse<Object> updateBookkeepingOrderType(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) BookkeepingOrderTypeBody bookkeepingOrderTypeVO) {
        OrderBusinessTypeReqDto reqDto = new OrderBusinessTypeReqDto();
        reqDto.setId(ParamConverter.convertToLong((Object)id));
        reqDto.setOrderType(bookkeepingOrderTypeVO.getOrderTypeCode());
        reqDto.setBusinessType(bookkeepingOrderTypeVO.getBussinessTypeCode());
        reqDto.setOrderName(bookkeepingOrderTypeVO.getOrderTypeName());
        reqDto.setBusinessName(bookkeepingOrderTypeVO.getBussinessTypeName());
        logger.info("\u65b0\u589e\u8bb0\u8d26\u7ba1\u7406reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.orderBusinessTypeApiProxy.modifyOrderBusinessType(reqDto)));
    }
}

