/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.dto.entity.SkuCostDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuCostPageReqDto;
import com.yunxi.dg.base.center.report.proxy.entity.ISkuCostApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SkuCostImport;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_SKU_COST_MANAGE")
public class SkuCostFileOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private ISkuCostApiProxy iSkuCostApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List<SkuCostImport> skuCostImports = result.getList().stream().map(k -> (SkuCostImport)k).collect(Collectors.toList());
        ArrayList<SkuCostImport> passList = new ArrayList<SkuCostImport>();
        this.verifySkuInfo(respDto, skuCostImports, passList, commonReqDto);
        return passList;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtils.isEmpty((Collection)passList)) {
            return;
        }
        try {
            RestResponseHelper.extractData((RestResponse)this.iSkuCostApiProxy.insertBatch(BeanUtil.copyToList((Collection)passList, SkuCostDto.class)));
        }
        catch (Exception e) {
            passList.stream().forEach(item -> {
                item.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", item.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5bfc\u5165\u5f02\u5e38" + e.getMessage()));
                respDto.getErrorDetails().add(item);
            });
        }
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private void verifySkuInfo(ImportFileOperationCommonRespDto commonRespDto, List<SkuCostImport> skuCostImports, List<SkuCostImport> passList, ImportFileOperationCommonReqDto commonReqDto) {
        Map<String, Long> countMap = skuCostImports.stream().collect(Collectors.groupingBy(SkuCostImport::getSkuCode, Collectors.counting()));
        ArrayList<String> skuCodeList = new ArrayList<String>(countMap.keySet());
        List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList));
        if (CollectionUtils.isEmpty((Collection)itemSkuDgRespDtos)) {
            skuCostImports.forEach(e -> {
                e.setErrorMsg("SKU\u7f16\u7801\u4e0d\u5b58\u5728");
                e.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", e.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), e.getErrorMsg()));
                commonRespDto.getErrorDetails().add(e);
            });
            return;
        }
        Map<String, SkuCostDto> existSkuCostMap = this.getExistSkuCostMap(skuCodeList);
        Map map = itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (v1, v2) -> v1));
        for (SkuCostImport skuCostImport : skuCostImports) {
            ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)map.get(skuCostImport.getSkuCode());
            if (Objects.isNull(itemSkuDgRespDto)) {
                skuCostImport.setErrorMsg("SKU\u7f16\u7801\u4e0d\u5b58\u5728");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                commonRespDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            Long count = countMap.getOrDefault(skuCostImport.getSkuCode(), 0L);
            if (count > 1L) {
                skuCostImport.setErrorMsg("SKU\u7f16\u7801\u91cd\u590d");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                commonRespDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)skuCostImport.getCostPrice())) {
                skuCostImport.setErrorMsg("\u542b\u7a0e\u6210\u672c\u4ef7\u4e3a\u7a7a");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                commonRespDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            if (!skuCostImport.getCostPrice().matches("^[-+]?[0-9]+(\\.[0-9]{0,6})*$")) {
                skuCostImport.setErrorMsg("\u542b\u7a0e\u6210\u672c\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57\u683c\u5f0f");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                commonRespDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            if (!BigDecimalUtils.geZero((BigDecimal)new BigDecimal(skuCostImport.getCostPrice())).booleanValue()) {
                skuCostImport.setErrorMsg("\u542b\u7a0e\u6210\u672c\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                commonRespDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            SkuCostDto skuCostDto = existSkuCostMap.get(skuCostImport.getSkuCode());
            if (Objects.nonNull(skuCostDto)) {
                skuCostImport.setId(skuCostDto.getId());
            }
            passList.add(skuCostImport);
        }
    }

    private Map<String, SkuCostDto> getExistSkuCostMap(List<String> skuCodeList) {
        SkuCostPageReqDto costPageReqDto = new SkuCostPageReqDto();
        costPageReqDto.setSkuCodeList(skuCodeList);
        List skuCostDtos = (List)RestResponseHelper.extractData((RestResponse)this.iSkuCostApiProxy.queryList(costPageReqDto));
        return ((List)Optional.ofNullable(skuCostDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(SkuCostDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
    }

    private List<SkuCostImport> convertToList(List<ImportBaseModeDto> resultList) {
        ArrayList<SkuCostImport> list = new ArrayList<SkuCostImport>();
        CubeBeanUtils.copyCollection(list, resultList, SkuCostImport.class);
        return list;
    }
}

