/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ChannelEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportWphBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ChannelBillDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_wph_bill_import")
public class WphBillCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(WphBillCommonServiceImpl.class);
    @Resource
    protected IChannelBillApiProxy channelBillApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportWphBillDto.class);
        ArrayList<ImportWphBillDto> passList = new ArrayList<ImportWphBillDto>();
        for (ImportWphBillDto dto : list) {
            Boolean billVerify = this.jdBillVerify(dto);
            if (!billVerify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        try {
            ArrayList channelBillDtos = Lists.newArrayList();
            for (ImportWphBillDto importBillDto : passList) {
                if (null != importBillDto.getExcelOrderTime()) {
                    importBillDto.setOrderTime(importBillDto.getExcelOrderTime());
                }
                if (null != importBillDto.getExcelOrderSigningOrRefundTime()) {
                    importBillDto.setOrderSigningOrRefundTime(importBillDto.getExcelOrderSigningOrRefundTime());
                }
                ChannelBillDto dto = new ChannelBillDto();
                dto.setChannelCode(ChannelEnum.WPH.getCode());
                dto.setChannelName(ChannelEnum.WPH.getName());
                dto.setSerialNo(importBillDto.getTradeNo());
                dto.setPlatformSerialNo(importBillDto.getGlobalId());
                dto.setPlatformSerialNo(importBillDto.getTradeNo());
                dto.setUniqueSerialNo(importBillDto.getGlobalId());
                dto.setProduceDate(DateUtil.parseDate((String)importBillDto.getBillingPeriod(), (String)"yyyy-MM"));
                dto.setData(JSON.toJSONString((Object)importBillDto));
                this.setCreatePerson(commonReqDto, dto);
                channelBillDtos.add(dto);
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u552f\u54c1\u4f1a\u539f\u59cb\u8d26\u5355,\u6570\u91cf\u4e3a:{}", (Object)channelBillDtos.size());
            this.channelBillApi.importInsertBatch((List)channelBillDtos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Boolean jdBillVerify(ImportWphBillDto dto) {
        return true;
    }

    protected void setCreatePerson(ImportFileOperationCommonReqDto commonReqDto, ChannelBillDto dto) {
        dto.setCreatePerson(commonReqDto.getCreatePerson());
        dto.setUpdatePerson(commonReqDto.getCreatePerson());
    }
}

