/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgVirtualWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ChannelTransferStrategyImportReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.OutVirtualWarehouseDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_channel_transfer_strategy_import")
public class ChannelTransferStrategyCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ChannelTransferStrategyCommonServiceImpl.class);
    @Resource
    private IDgVirtualWarehouseApiProxy iDgVirtualWarehouseApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5546\u54c1");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List list = BeanUtil.copyToList((Collection)result.getList(), ChannelTransferStrategyImportReqDto.class);
        ArrayList passList = Lists.newArrayList();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (ChannelTransferStrategyImportReqDto importReqDto : list) {
            if (!Objects.nonNull(importReqDto.getSkuCode())) continue;
            skuCodeList.add(importReqDto.getSkuCode());
        }
        List itemSkuDgRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).orElse(new ArrayList());
        Map<String, ItemSkuDgRespDto> itemSkuMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (o1, o2) -> o1));
        List virtualWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgVirtualWarehouseApiProxy.list(new DgVirtualWarehousePageReqDto()))).orElse(new ArrayList());
        Map<String, DgVirtualWarehouseDto> virtualWarehouseDtoMap = virtualWarehouseDtos.stream().collect(Collectors.toMap(DgVirtualWarehouseDto::getWarehouseName, Function.identity(), (o1, o2) -> o1));
        HashSet<String> codeSet = new HashSet<String>();
        for (ChannelTransferStrategyImportReqDto dto : list) {
            boolean isPass = this.paramVerify(dto, itemSkuMap, codeSet, virtualWarehouseDtoMap);
            if (isPass) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private boolean paramVerify(ChannelTransferStrategyImportReqDto dto, Map<String, ItemSkuDgRespDto> itemSkuMap, Set<String> codeSet, Map<String, DgVirtualWarehouseDto> nameDtoMap) {
        if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
            dto.setErrorMsg("sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (codeSet.contains(dto.getSkuCode())) {
            dto.setErrorMsg("sku\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (!itemSkuMap.containsKey(dto.getSkuCode())) {
            dto.setErrorMsg("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
            return false;
        }
        codeSet.add(dto.getSkuCode());
        dto.setSkuName(itemSkuMap.get(dto.getSkuCode()).getName());
        if (StringUtils.isBlank((CharSequence)dto.getOutVirtualWarehouse())) {
            dto.setErrorMsg("\u8c03\u51fa\u4f9b\u8d27\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String regex = ",|\uff0c";
        List<String> outVirtualWarehouseNameList = Arrays.asList(dto.getOutVirtualWarehouse().split(regex));
        ArrayList outVirtualWarehouseDtoList = Lists.newArrayList();
        HashSet<String> outVirtualWarehouseeSet = new HashSet<String>();
        for (String str : outVirtualWarehouseNameList) {
            if (!nameDtoMap.containsKey(str)) {
                dto.setErrorMsg(str + "\u8c03\u51fa\u4f9b\u8d27\u4ed3\u4e0d\u5b58\u5728");
                return false;
            }
            outVirtualWarehouseeSet.add(str);
            OutVirtualWarehouseDto outVirtualWarehouseDto = new OutVirtualWarehouseDto();
            outVirtualWarehouseDto.setOutVirtualWarehouseName(str);
            outVirtualWarehouseDto.setOutVirtualWarehouseCode(nameDtoMap.get(str).getWarehouseCode());
            outVirtualWarehouseDtoList.add(outVirtualWarehouseDto);
        }
        if (outVirtualWarehouseeSet.size() != outVirtualWarehouseNameList.size()) {
            dto.setErrorMsg("\u8c03\u51fa\u4f9b\u8d27\u4ed3\u91cd\u590d\u4e86");
            return false;
        }
        dto.setOutVirtualWarehouseList((List)outVirtualWarehouseDtoList);
        return true;
    }
}

