/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.ImportEnterpriseInventoryOrgRelationDto;
import com.yunxi.dg.base.center.customer.dto.response.DgEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgEnterpriseQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.userbiz.IDgOrganizationApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgEnterpriseInventoryOrgRelationOrgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgEnterpriseInventoryOrgRelationReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.api.IDgInventoryOrgApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgInventoryOrgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrganizationDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_enterprise_inventory_org_relation_import")
public class EnterpriseInventoryOrgRelationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseInventoryOrgRelationCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(EnterpriseInventoryOrgRelationCommonServiceImpl.class);
    @Resource
    private IDgEnterpriseQueryApiProxy iDgEnterpriseQueryApiProxy;
    @Resource
    private IDgOrganizationApi iDgOrganizationApi;
    @Resource
    private IDgInventoryOrgQueryApiProxy iDgInventoryOrgQueryApiProxy;
    @Resource
    private IDgInventoryOrgApiProxy iDgInventoryOrgApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList importList = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(importList, (Collection)result.getList(), ImportEnterpriseInventoryOrgRelationDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)importList.size());
        ArrayList passList = new ArrayList();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List orgList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApi.queryOrgListByCode(importList.stream().map(ImportEnterpriseInventoryOrgRelationDto::getOrgCode).collect(Collectors.toList())))).orElse(new ArrayList());
        Map orgMap = orgList.stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (a, b) -> a));
        List enterpriseQueryCodeList = importList.stream().map(ImportEnterpriseInventoryOrgRelationDto::getEnterpriseCode).collect(Collectors.toList());
        DgEnterpriseQueryReqDto enterpriseQueryReqDto = new DgEnterpriseQueryReqDto();
        enterpriseQueryReqDto.setCodeList(enterpriseQueryCodeList);
        List existEnterpriseList = (List)RestResponseHelper.extractData((RestResponse)this.iDgEnterpriseQueryApiProxy.queryList(enterpriseQueryReqDto));
        Map enterpriseMap = existEnterpriseList.stream().collect(Collectors.toMap(DgEnterpriseRespDto::getCode, Function.identity(), (a, b) -> a));
        List enterprisesWithRelations = (List)RestResponseHelper.extractData((RestResponse)this.iDgInventoryOrgQueryApiProxy.queryEnterpriseWithInventoryOrgRelationsByEnterpriseCodes(enterpriseQueryCodeList));
        Set enterpriseWithRelationsMap = enterprisesWithRelations.stream().map(DgEnterpriseRespDto::getCode).collect(Collectors.toSet());
        Map<String, List<ImportEnterpriseInventoryOrgRelationDto>> relationMap = importList.stream().collect(Collectors.groupingBy(dto -> dto.getEnterpriseCode() == null ? "" : dto.getEnterpriseCode()));
        relationMap.values().forEach(list -> {
            for (ImportEnterpriseInventoryOrgRelationDto importDto : list) {
                HashSet<String> seenRelationSet;
                Boolean verify = this.relationVerifyInSameEnterprise(importDto, orgMap, enterpriseMap, enterpriseWithRelationsMap, seenRelationSet = new HashSet<String>());
                if (!verify.booleanValue()) {
                    importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                    respDto.getErrorDetails().add(importDto);
                    continue;
                }
                passList.add(importDto);
            }
        });
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("orgMap", orgMap);
        dataMap.put("enterpriseMap", enterpriseMap);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map orgMap = (Map)dataMap.get("orgMap");
        Map enterpriseMap = (Map)dataMap.get("enterpriseMap");
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtoList = new ArrayList();
        Map<String, List<ImportEnterpriseInventoryOrgRelationDto>> relationMap = passList.stream().collect(Collectors.groupingBy(ImportEnterpriseInventoryOrgRelationDto::getEnterpriseCode));
        try {
            relationMap.forEach((enterpriseCode, relations) -> {
                DgEnterpriseInventoryOrgRelationReqDto relationReqDto = new DgEnterpriseInventoryOrgRelationReqDto();
                reqDtoList.add(relationReqDto);
                relationReqDto.setEnterpriseId(((DgEnterpriseRespDto)enterpriseMap.get(enterpriseCode)).getId());
                relationReqDto.setStatus(Integer.valueOf(1));
                ArrayList orgList = new ArrayList();
                relationReqDto.setOrgList(orgList);
                relations.forEach(dto -> {
                    DgEnterpriseInventoryOrgRelationOrgReqDto orgReqDto = new DgEnterpriseInventoryOrgRelationOrgReqDto();
                    orgReqDto.setOrgId(((OrganizationDto)orgMap.get(dto.getOrgCode())).getId());
                    if (relations.size() == 1) {
                        orgReqDto.setIsDefault(Integer.valueOf(1));
                    } else {
                        orgReqDto.setIsDefault(Integer.valueOf(Objects.equals("\u662f", dto.getIsDefault()) ? 1 : 0));
                    }
                    orgList.add(orgReqDto);
                });
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u9500\u552e\u516c\u53f8\u8d27\u6743\u7ec4\u7ec7\u5173\u7cfb,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
        RestResponseHelper.checkOrThrow((RestResponse)this.iDgInventoryOrgApiProxy.addBatchEnterpriseInventoryOrgRelation(reqDtoList));
    }

    private Boolean relationVerifyInSameEnterprise(ImportEnterpriseInventoryOrgRelationDto dto, Map<String, OrganizationDto> orgMap, Map<String, DgEnterpriseRespDto> enterpriseMap, Set<String> enterpriseWithRelationsMap, Set<String> seenRelationSet) {
        if (StringUtils.isBlank((CharSequence)dto.getOrgCode())) {
            dto.setErrorMsg("\u8d27\u6743\u7ec4\u7ec7\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getEnterpriseCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!orgMap.containsKey(dto.getOrgCode())) {
            dto.setErrorMsg("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1a" + dto.getOrgCode());
            return false;
        }
        if (!enterpriseMap.containsKey(dto.getEnterpriseCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u4e0d\u5b58\u5728\uff1a" + dto.getEnterpriseCode());
            return false;
        }
        if (enterpriseWithRelationsMap.contains(dto.getEnterpriseCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u5df2\u5b58\u5728\u8d27\u6743\u5173\u7cfb\u8bb0\u5f55\uff1a" + dto.getEnterpriseCode());
            return false;
        }
        String seenKey = dto.getOrgCode();
        if (seenRelationSet.contains(seenKey)) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8(" + dto.getEnterpriseCode() + ")\u4e0e\u7ec4\u7ec7(" + dto.getOrgCode() + ")\u7684\u5173\u7cfb\u5df2\u5728\u6b64\u6587\u4ef6\u4e2d\u5b58\u5728\uff0c\u5c06\u4e0d\u5bfc\u5165\u6b64\u884c");
            return false;
        }
        seenRelationSet.add(seenKey);
        return true;
    }
}

