/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dto.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.request.BundleItemDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IItemCenterSkuDgQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemBundleDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemChangeApplyDgDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgCenterApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ItemCombineImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_item_combine_import")
public class ItemCombineServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ItemCombineServiceImpl.class);
    private static final String PASS = "pass";
    private static final String FAIL = "fail";
    private static final String BYCODE = "byCode";
    private static final String BYNAME = "byName";
    private static final String ERROR_FILE_NAME = "\u7ec4\u5408\u5546\u54c1\u5bfc\u5165\u5931\u8d25\u6570\u636e";
    @Resource
    private IItemCenterSkuDgQueryApi itemCenterSkuDgQueryApi;
    @Resource
    private IItemSkuDgCenterApiProxy itemSkuDgCenterApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u7ec4\u5408\u5546\u54c1\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ItemCombineImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        for (ItemCombineImportDto itemCombineImportDto : resultList) {
            boolean isPass = this.checkAndInitParam(itemCombineImportDto);
            if (!isPass) {
                itemCombineImportDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", itemCombineImportDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), itemCombineImportDto.getErrorMsg()));
                respDto.getErrorDetails().add(itemCombineImportDto);
                failList.add(itemCombineImportDto);
                continue;
            }
            passList.add(itemCombineImportDto);
        }
        respDto.setDetails((List)passList);
        respDto.setErrorDetails((List)failList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        List passList = (List)object;
        log.info("passList:{}", (Object)JSONObject.toJSONString((Object)passList));
        List failList = respDto.getErrorDetails();
        log.info("failList:{}", (Object)JSONObject.toJSONString((Object)failList));
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        Map<String, Map<String, List<ItemCombineImportDto>>> itemCombineMap = this.getItemCombineGroupByCodeOrName(passList);
        Map<String, List<ItemCombineImportDto>> byCodeMap = itemCombineMap.get(BYCODE);
        log.info("byCode\u5206\u7ec4:{}", (Object)JSONObject.toJSONString(byCodeMap));
        Map<String, List<ItemCombineImportDto>> byNameMap = itemCombineMap.get(BYNAME);
        log.info("byNameMap\u5206\u7ec4:{}", (Object)JSONObject.toJSONString(byNameMap));
        byNameMap.forEach((key, itemCombineImportDtoList) -> {
            ArrayList<ItemChangeApplyDgDto> changeApplyDgDtoList = new ArrayList<ItemChangeApplyDgDto>();
            ItemChangeApplyDgDto changeApplyDgDto = this.buildImportData((String)key, (List<ItemCombineImportDto>)itemCombineImportDtoList);
            changeApplyDgDtoList.add(changeApplyDgDto);
            this.saveData(changeApplyDgDtoList, failList, respDto);
        });
        byCodeMap.forEach((key, itemCombineImportDtoList) -> {
            ArrayList<ItemChangeApplyDgDto> changeApplyDgDtoList = new ArrayList<ItemChangeApplyDgDto>();
            log.info("\u7ec4\u5408\u5546\u54c1itemCode:{}", key);
            ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
            itemQueryDgReqDto.setItemCode(key);
            itemQueryDgReqDto.setQueryType("3");
            List dgItemSkuPageRespDtoList = ((PageInfo)this.itemCenterSkuDgQueryApi.queryItemListByPage(itemQueryDgReqDto).getData()).getList();
            if (CollectionUtil.isEmpty((Collection)dgItemSkuPageRespDtoList)) {
                ItemChangeApplyDgDto changeApplyDgDto = this.buildImportData((String)key, (List<ItemCombineImportDto>)itemCombineImportDtoList);
                changeApplyDgDtoList.add(changeApplyDgDto);
                this.saveData(changeApplyDgDtoList, failList, respDto);
            } else {
                List itemCodeList = dgItemSkuPageRespDtoList.stream().map(DgItemSkuRespDto::getItemCode).collect(Collectors.toList());
                if (itemCodeList.contains(key)) {
                    itemCombineImportDtoList.forEach(itemCombineImportDto -> itemCombineImportDto.setErrorMsg("\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728"));
                    failList.addAll(itemCombineImportDtoList);
                } else {
                    this.saveData(changeApplyDgDtoList, failList, respDto);
                }
            }
        });
    }

    private void saveData(List<ItemChangeApplyDgDto> changeApplyDgDtoList, List<ItemCombineImportDto> failList, ImportFileOperationCommonRespDto respDto) {
        log.info("\u6279\u91cf\u5bfc\u5165\u7ec4\u5408\u5546\u54c1\u5165\u53c2:{}", (Object)JSONObject.toJSONString(changeApplyDgDtoList));
        try {
            this.itemSkuDgCenterApiProxy.importItemInfo(changeApplyDgDtoList);
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u7ec4\u5408\u5546\u54c1\u51fa\u9519:{}", (Object)e.getMessage());
            List importDtoList = changeApplyDgDtoList.stream().map(data -> {
                ItemCombineImportDto importDto = new ItemCombineImportDto();
                importDto.setCode(data.getItemCode());
                importDto.setName(data.getItemName());
                importDto.setErrorMsg(e.getMessage());
                return importDto;
            }).collect(Collectors.toList());
            failList.addAll(importDtoList);
        }
        if (CollectionUtil.isNotEmpty(changeApplyDgDtoList) && CollectionUtil.isNotEmpty(failList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        this.uploadImportErrorFile(failList, ERROR_FILE_NAME);
    }

    public boolean checkAndInitParam(ItemCombineImportDto itemCombineImportDto) {
        Optional.ofNullable(itemCombineImportDto.getSkuCode()).ifPresent(s -> itemCombineImportDto.setSkuCode(s.replaceAll("\\s", "")));
        Optional.ofNullable(itemCombineImportDto.getSkuName()).ifPresent(s -> itemCombineImportDto.setSkuName(s.replaceAll("\\s", "")));
        Optional.ofNullable(itemCombineImportDto.getCode()).ifPresent(s -> itemCombineImportDto.setCode(s.replaceAll("\\s", "")));
        Optional.ofNullable(itemCombineImportDto.getName()).ifPresent(s -> itemCombineImportDto.setName(s.replaceAll("\\s", "")));
        List dgItemSkuPageRespDtoList = null;
        if (StringUtils.isBlank((CharSequence)itemCombineImportDto.getName())) {
            itemCombineImportDto.setErrorMsg("\u7ec4\u5408\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (Objects.isNull(itemCombineImportDto.getDistributionType())) {
            itemCombineImportDto.setErrorMsg("\u91d1\u989d\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (Objects.isNull(itemCombineImportDto.getItemNum())) {
            itemCombineImportDto.setErrorMsg("\u7ec4\u5408\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!Objects.isNull(itemCombineImportDto.getDistributionType()) && itemCombineImportDto.getDistributionType() == 1 && Objects.isNull(itemCombineImportDto.getPriceAllocationRatio())) {
            itemCombineImportDto.setErrorMsg("\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        try {
            ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
            itemQueryDgReqDto.setItemAttributeList(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
            itemQueryDgReqDto.setQueryType("1");
            itemQueryDgReqDto.setSubStatus(Integer.valueOf(1));
            itemQueryDgReqDto.setSkuCode(itemCombineImportDto.getSkuCode());
            log.info("\u6839\u636eskuCode\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)itemQueryDgReqDto));
            dgItemSkuPageRespDtoList = ((PageInfo)this.itemCenterSkuDgQueryApi.queryItemListByPage(itemQueryDgReqDto).getData()).getList();
            if (CollectionUtil.isEmpty((Collection)dgItemSkuPageRespDtoList)) {
                itemCombineImportDto.setErrorMsg("\u6839\u636esku\u7f16\u7801\u6ca1\u6709\u67e5\u5230\u6709\u6548\u4fe1\u606f");
                return false;
            }
        }
        catch (Exception e) {
            log.info("\u8fdc\u7a0b\u67e5\u8be2\u5546\u54c1\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            itemCombineImportDto.setErrorMsg("\u8fdc\u7a0b\u67e5\u8be2\u5546\u54c1\u51fa\u9519");
            return false;
        }
        return true;
    }

    private Map<String, Map<String, List<ItemCombineImportDto>>> getItemCombineGroupByCodeOrName(List<ItemCombineImportDto> resultList) {
        HashMap<String, Map<String, List<ItemCombineImportDto>>> map = new HashMap<String, Map<String, List<ItemCombineImportDto>>>();
        Map<String, List<ItemCombineImportDto>> byCodeMap = resultList.stream().filter(itemCombineImportDto -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemCombineImportDto.getCode()})).collect(Collectors.groupingBy(ItemCombineImportDto::getCode));
        log.info("\u6839\u636e\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u5206\u7ec4\u540e\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString(byCodeMap));
        Map<String, List<ItemCombineImportDto>> byNameMap = resultList.stream().filter(itemCombineImportDto -> StringUtils.isBlank((CharSequence)itemCombineImportDto.getCode()) && StringUtils.isNotBlank((CharSequence)itemCombineImportDto.getName())).collect(Collectors.groupingBy(ItemCombineImportDto::getCode));
        log.info("\u6839\u636e\u7ec4\u5408\u5546\u54c1\u540d\u79f0\u5206\u7ec4\u540e\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString(byCodeMap));
        map.put(BYCODE, byCodeMap);
        map.put(BYNAME, byNameMap);
        return map;
    }

    private ItemChangeApplyDgDto buildImportData(String key, List<ItemCombineImportDto> itemCombineImportDtoList) {
        if (CollectionUtil.isEmpty(itemCombineImportDtoList)) {
            log.error("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7ec4\u5408\u5546\u54c1\u6570\u636e");
            return null;
        }
        log.info("\u5f85\u8f6c\u6362\u7684\u539f\u59cb\u6570\u636e, key: {}, value:{}", (Object)key, (Object)JSONObject.toJSONString(itemCombineImportDtoList));
        ItemChangeApplyDgDto itemChangeApplyDgDto = new ItemChangeApplyDgDto();
        List skuCodeList = itemCombineImportDtoList.stream().map(ItemCombineImportDto::getSkuCode).distinct().collect(Collectors.toList());
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuCodes(skuCodeList);
        itemQueryDgReqDto.setSubStatus(Integer.valueOf(1));
        itemQueryDgReqDto.setQueryType("1");
        List dgItemSkuPageRespDtoList = ((PageInfo)this.itemCenterSkuDgQueryApi.queryItemListByPage(itemQueryDgReqDto).getData()).getList();
        log.info("\u6839\u636eskuCodeList\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)dgItemSkuPageRespDtoList));
        itemChangeApplyDgDto.setItemName(key);
        for (ItemCombineImportDto importDto : itemCombineImportDtoList) {
            if (!Objects.nonNull(importDto.getCode())) continue;
            itemChangeApplyDgDto.setItemCode(importDto.getCode());
            break;
        }
        itemChangeApplyDgDto.setExtension("{\"distributionType\":" + itemCombineImportDtoList.get(0).getDistributionType() + "}");
        itemChangeApplyDgDto.setType(Integer.valueOf(3));
        ArrayList<ItemBundleDgReqDto> skus = new ArrayList<ItemBundleDgReqDto>();
        ItemBundleDgReqDto itemBundleDgReqDto = new ItemBundleDgReqDto();
        itemBundleDgReqDto.setStatus(Integer.valueOf(1));
        List list = itemCombineImportDtoList.stream().filter(x -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x.getRemark()})).map(ItemCombineImportDto::getRemark).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            itemBundleDgReqDto.setRemark((String)list.get(0));
        }
        ArrayList<BundleItemDgReqDto> bundleItemDtos = new ArrayList<BundleItemDgReqDto>();
        if (CollectionUtil.isNotEmpty((Collection)dgItemSkuPageRespDtoList)) {
            for (DgItemSkuPageRespDto dgItemSkuPageRespDto : dgItemSkuPageRespDtoList) {
                for (ItemCombineImportDto itemCombineImportDto : itemCombineImportDtoList) {
                    if (!dgItemSkuPageRespDto.getSkuCode().equals(itemCombineImportDto.getSkuCode())) continue;
                    BundleItemDgReqDto bundleItemDgReqDto = new BundleItemDgReqDto();
                    bundleItemDgReqDto.setId(dgItemSkuPageRespDto.getId());
                    bundleItemDgReqDto.setItemId(dgItemSkuPageRespDto.getItemId());
                    bundleItemDgReqDto.setSubItemId(dgItemSkuPageRespDto.getItemId());
                    bundleItemDgReqDto.setSubItemCode(dgItemSkuPageRespDto.getItemCode());
                    bundleItemDgReqDto.setSubItemName(dgItemSkuPageRespDto.getItemName());
                    bundleItemDgReqDto.setSubSkuId(dgItemSkuPageRespDto.getItemId());
                    bundleItemDgReqDto.setSubType(dgItemSkuPageRespDto.getItemType());
                    bundleItemDgReqDto.setItemAttribute(dgItemSkuPageRespDto.getItemAttribute());
                    bundleItemDgReqDto.setSubSkuCode(dgItemSkuPageRespDto.getSkuCode());
                    bundleItemDgReqDto.setSubSkuName(dgItemSkuPageRespDto.getSkuName());
                    bundleItemDgReqDto.setUnit(dgItemSkuPageRespDto.getUnit());
                    bundleItemDgReqDto.setNum(itemCombineImportDto.getItemNum());
                    if (itemCombineImportDto.getDistributionType().equals(1)) {
                        bundleItemDgReqDto.setPriceAllocationRatio(itemCombineImportDto.getPriceAllocationRatio());
                    } else {
                        bundleItemDgReqDto.setPriceAllocationRatio(itemCombineImportDto.getPriceAllocationAmount());
                    }
                    bundleItemDgReqDto.setRemark(itemCombineImportDto.getSkuRemark());
                    bundleItemDtos.add(bundleItemDgReqDto);
                }
            }
        }
        log.info("bundleItemDtos: {}", (Object)JSON.toJSONString(bundleItemDtos));
        itemBundleDgReqDto.setBundleItemDtos(bundleItemDtos);
        skus.add(itemBundleDgReqDto);
        log.info("skus: {}", (Object)JSON.toJSONString(skus));
        itemChangeApplyDgDto.setSkus(skus);
        log.info("\u8f6c\u6362\u540e\u7684\u7ec4\u5408\u5546\u54c1\u6570\u636e, key:{},value: {}", (Object)key, (Object)JSON.toJSONString((Object)itemChangeApplyDgDto));
        return itemChangeApplyDgDto;
    }
}

