/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.service.enums.LogicWarehousePropertyEnum;
import com.yunxi.dg.base.mgmt.service.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.mgmt.service.enums.LogicWarehouseStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportLogicWarehouseModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_logic_warehouse_import")
public class LogicWarehouseCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LogicWarehouseCommonServiceImpl.class);
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy dgPhysicsWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u903b\u8f91\u4ed3\u6863\u6848");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportLogicWarehouseModeDto> passList = new ArrayList<ImportLogicWarehouseModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportLogicWarehouseModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u903b\u8f91\u4ed3\u6863\u6848,\u5bfc\u5165\u903b\u8f91\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List logicWarehouseRespDtoList = Optional.ofNullable(this.logicWarehouseApiProxy.queryList(new LogicWarehousePageReqDto()).getData()).orElse(new ArrayList());
        List<String> logicWarehouseCodeList = logicWarehouseRespDtoList.stream().map(LogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        List<String> logicWarehouseNameList = logicWarehouseRespDtoList.stream().map(LogicWarehouseRespDto::getWarehouseName).collect(Collectors.toList());
        Map<String, String> logicWarehouseCodeMap = logicWarehouseRespDtoList.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseName, LogicWarehouseRespDto::getWarehouseCode, (o1, o2) -> o1));
        Map<String, String> organizationMap = logicWarehouseRespDtoList.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getOrganizationName, LogicWarehouseRespDto::getOrganizationCode, (o1, o2) -> o1));
        Map<String, List<LogicWarehouseRespDto>> logicWarehouseMapByOrganization = logicWarehouseRespDtoList.stream().collect(Collectors.groupingBy(LogicWarehouseRespDto::getOrganizationName));
        List physicsWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgPhysicsWarehouseApiProxy.queryAll())).orElse(new ArrayList());
        Map<String, DgPhysicsWarehouseDto> physicsWarehouseMap = physicsWarehouseDtos.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseName, Function.identity(), (o1, o2) -> o1));
        for (ImportLogicWarehouseModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, logicWarehouseCodeList, logicWarehouseNameList, physicsWarehouseMap, organizationMap, logicWarehouseMapByOrganization, logicWarehouseCodeMap);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u903b\u8f91\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List logicWarehouseDtos = BeanUtil.copyToList((Collection)passList, LogicWarehouseDto.class);
        this.logicWarehouseApiProxy.batchInsert(logicWarehouseDtos);
    }

    private boolean paramVerify(ImportLogicWarehouseModeDto dto, List<String> logicWarehouseCodeList, List<String> logicWarehouseNameList, Map<String, DgPhysicsWarehouseDto> physicsWarehouseMap, Map<String, String> organizationMap, Map<String, List<LogicWarehouseRespDto>> logicWarehouseMapByOrganization, Map<String, String> logicWarehouseCodeMap) {
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u903b\u8f91\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtil.isNotEmpty(logicWarehouseNameList) && logicWarehouseNameList.contains(dto.getWarehouseName())) {
            this.setErrorMsg(dto, dto.getWarehouseName() + "\u903b\u8f91\u4ed3\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseCode())) {
            this.setErrorMsg(dto, "\u9009\u9879\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!dto.getWarehouseCode().matches("^[a-zA-Z0-9\\\\p{Punct}]+$")) {
            this.setErrorMsg(dto, "\u903b\u8f91\u4ed3\u7f16\u7801\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u5b57\u6bcd\u3001\u6807\u70b9\u7b26\u53f7\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        if (CollectionUtil.isNotEmpty(logicWarehouseCodeList) && logicWarehouseCodeList.contains(dto.getWarehouseCode())) {
            this.setErrorMsg(dto, dto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u7f16\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getPhysicsWarehouseName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u5f52\u5c5e\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!physicsWarehouseMap.containsKey(dto.getPhysicsWarehouseName())) {
            this.setErrorMsg(dto, "\u5f52\u5c5e\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setPhysicsWarehouseCode(physicsWarehouseMap.get(dto.getPhysicsWarehouseName()).getWarehouseCode());
        if (StringUtils.isBlank((CharSequence)dto.getOrganizationName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u5f52\u5c5e\u8d27\u6743\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!organizationMap.containsKey(dto.getOrganizationName())) {
            this.setErrorMsg(dto, "\u5f52\u5c5e\u8d27\u6743\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setOrganizationCode(organizationMap.get(dto.getOrganizationName()));
        if (StringUtils.isNotBlank((CharSequence)dto.getDeliveryReturnWarehouseName())) {
            if (!logicWarehouseMapByOrganization.containsKey(dto.getOrganizationName())) {
                this.setErrorMsg(dto, dto.getOrganizationName() + "\u4e0d\u5b58\u5728\u8be5\u9000\u8d27\u4ed3");
                return false;
            }
            dto.setDeliveryReturnWarehouseCode(logicWarehouseCodeMap.get(dto.getDeliveryReturnWarehouseName()));
        }
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseProperty())) {
            this.setErrorMsg(dto, "\u9009\u9879\u4e1a\u52a1\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        List<String> propertyEnumDescList = LogicWarehousePropertyEnum.getDescList();
        if (CollectionUtil.isNotEmpty(propertyEnumDescList) && !propertyEnumDescList.contains(dto.getWarehouseProperty())) {
            this.setErrorMsg(dto, "\u4e1a\u52a1\u5c5e\u6027\u586b\u5199\u6709\u8bef,\u8bf7\u68c0\u67e5");
            return false;
        }
        dto.setWarehouseProperty(LogicWarehousePropertyEnum.getByDesc(dto.getWarehouseProperty()).getCode());
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseQuality())) {
            this.setErrorMsg(dto, "\u9009\u9879\u4ed3\u5e93\u54c1\u8d28\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        List<String> qualityEnumDescList = LogicWarehouseQualityEnum.getDescList();
        if (CollectionUtil.isNotEmpty(qualityEnumDescList) && !qualityEnumDescList.contains(dto.getWarehouseQuality())) {
            this.setErrorMsg(dto, "\u4ed3\u5e93\u54c1\u8d28\u586b\u5199\u6709\u8bef,\u8bf7\u68c0\u67e5");
            return false;
        }
        dto.setWarehouseQuality(LogicWarehouseQualityEnum.getByDesc(dto.getWarehouseQuality()).getCode());
        if (!"\u662f".equals(dto.getIsVirtualFlag()) && !"\u5426".equals(dto.getIsVirtualFlag())) {
            this.setErrorMsg(dto, "\u865a\u62df\u903b\u8f91\u4ed3\u586b\u5199\u6709\u8bef");
            return false;
        }
        if ("\u662f".equals(dto.getIsVirtualFlag())) {
            dto.setIsVirtual(YesNoEnum.YES.getValue());
        } else {
            dto.setIsVirtual(YesNoEnum.NO.getValue());
        }
        if (!"\u662f".equals(dto.getIsNegativeFlag()) && !"\u5426".equals(dto.getIsNegativeFlag())) {
            this.setErrorMsg(dto, "\u5141\u8bb8\u8d1f\u5e93\u5b58\u586b\u5199\u6709\u8bef");
            return false;
        }
        if ("\u662f".equals(dto.getIsNegativeFlag())) {
            dto.setNegativeFlag(YesNoEnum.YES.getValue());
        } else {
            dto.setNegativeFlag(YesNoEnum.NO.getValue());
        }
        dto.setWarehouseStatus(LogicWarehouseStatusEnum.ENABLE.getCode());
        return true;
    }

    private String setErrorMsg(ImportLogicWarehouseModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

