/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.BizTagDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reoprt.IReBizTagApiProxy;
import com.yunxi.dg.base.mgmt.service.enums.TagExtendEnum;
import com.yunxi.dg.base.mgmt.service.enums.TagGroupEnum;
import com.yunxi.dg.base.mgmt.service.enums.TagStatusEnum;
import com.yunxi.dg.base.mgmt.service.enums.TagTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportOrderTagDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="AbstractBaseFileOperationCommonService_order_tag_import")
public class OrderTagImportServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(OrderTagImportServiceImpl.class);
    @Resource
    private IReBizTagApiProxy reBizTagApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportOrderTagDto.class);
        List tagNameList = list.stream().map(ImportOrderTagDto::getTagName).distinct().collect(Collectors.toList());
        List tagNamesList = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagApi.listByTagNames(tagNameList));
        HashSet<String> sourcTtagNames = new HashSet<String>();
        ArrayList<BizTagDto> insertList = new ArrayList<BizTagDto>();
        for (ImportOrderTagDto dto : list) {
            BizTagDto tagDto;
            Boolean verify = this.verify(dto, tagNamesList, sourcTtagNames, tagDto = new BizTagDto());
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            insertList.add(tagDto);
        }
        respDto.setDetails(insertList);
        return insertList;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.batchInsertData((List)object, respDto);
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.batchInsertData((List)object, respDto);
    }

    private void batchInsertData(List<BizTagDto> insertList, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtil.isEmpty(insertList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty(insertList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        insertList.forEach(en -> {
            en.setTagGroupName(TagGroupEnum.ORDER.getName());
            en.setTagGroupCode(TagGroupEnum.ORDER.getCode());
            en.setTagType(TagTypeEnum.MANUAL_CUSTOM_TAG.getCode());
            en.setTagCode(IdWorker.getIdStr());
        });
        this.reBizTagApi.batchInsert(insertList);
    }

    private Boolean verify(ImportOrderTagDto dto, List<String> tagNamesList, Set<String> sourcTtagNames, BizTagDto tagDto) {
        BeanUtils.copyProperties((Object)dto, (Object)tagDto);
        String tagExtend = dto.getTagExtendName();
        if (StringUtils.hasText((String)tagExtend)) {
            TagExtendEnum tagExtendEnum = TagExtendEnum.getEnumName(tagExtend);
            if (tagExtendEnum == null) {
                dto.setErrorMsg("\u62c6\u5206\u5355\u7ee7\u627f\u6807\u8bc6\u9519\u8bef!");
                return false;
            }
            tagDto.setTagExtend(tagExtendEnum.getCode());
        } else {
            tagDto.setTagExtend(TagExtendEnum.NO.getCode());
        }
        String tagStatus = dto.getTagStatusName();
        if (StringUtils.hasText((String)tagStatus)) {
            TagStatusEnum tagStatusEnum = TagStatusEnum.getEnumName(tagStatus);
            if (tagStatusEnum == null) {
                dto.setErrorMsg("\u6807\u7b7e\u72b6\u6001\u9519\u8bef!");
                return false;
            }
            tagDto.setTagStatus(tagStatusEnum.getCode());
        } else {
            tagDto.setTagStatus(TagStatusEnum.YES.getCode());
        }
        String tagName = dto.getTagName();
        if (StringUtils.hasText((String)tagName)) {
            if (tagName.length() > 50) {
                dto.setErrorMsg("\u6807\u7b7e\u540d\u79f0\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
                return false;
            }
        } else {
            dto.setErrorMsg("\u6807\u7b7e\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a!");
            return false;
        }
        if (tagNamesList.contains(tagName)) {
            dto.setErrorMsg("\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (sourcTtagNames.contains(tagName)) {
            dto.setErrorMsg("\u6807\u7b7e\u540d\u79f0\u91cd\u590d");
            return false;
        }
        if (StringUtils.hasText((String)dto.getRemark()) && dto.getRemark().length() > 200) {
            dto.setErrorMsg("\u6807\u7b7e\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7200\u4e2a\u5b57");
            return false;
        }
        if (StringUtils.hasText((String)dto.getTagFontColor())) {
            if (dto.getTagFontColor().length() > 20) {
                dto.setErrorMsg("\u6807\u7b7e\u5b57\u4f53\u989c\u8272\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
                return false;
            }
        } else {
            tagDto.setTagFontColor("#000000");
        }
        if (StringUtils.hasText((String)dto.getTagBackgroudColor())) {
            if (dto.getTagBackgroudColor().length() > 20) {
                dto.setErrorMsg("\u6807\u7b7e\u80cc\u666f\u989c\u8272\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
                return false;
            }
        } else {
            tagDto.setTagBackgroudColor("#FFFFFF");
        }
        sourcTtagNames.add(tagName);
        return true;
    }
}

