/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.customerbiz.IDgTobOrganizationApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.userbiz.IDgOrganizationApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.customer.DgOrganizationReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrganizationDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportSaleOrganizationDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_sale_organization_import")
public class SaleOrganizationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrganizationCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(SaleOrganizationCommonServiceImpl.class);
    @Resource
    private IDgTobOrganizationApi iDgTobOrganizationApi;
    @Resource
    private IDgOrganizationApi iDgOrganizationApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportSaleOrganizationDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)list.size());
        ArrayList<ImportSaleOrganizationDto> passList = new ArrayList<ImportSaleOrganizationDto>();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List<String> existOrgCodeList = ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApi.queryOrgListByCode(list.stream().map(ImportSaleOrganizationDto::getCode).collect(Collectors.toList())))).orElse(new ArrayList())).stream().map(OrganizationDto::getCode).collect(Collectors.toList());
        List existEnterpriseList = (List)RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApi.queryOrgListByCode(list.stream().map(ImportSaleOrganizationDto::getEnterpriseCode).collect(Collectors.toList())));
        List<String> existEnterpriseCodeList = ((List)Optional.ofNullable(existEnterpriseList).orElse(new ArrayList())).stream().map(OrganizationDto::getCode).collect(Collectors.toList());
        for (ImportSaleOrganizationDto dto : list) {
            Boolean verify = this.saleOrgVerify(dto, existOrgCodeList, existEnterpriseCodeList);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("existEnterpriseList", existEnterpriseList);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        List existEnterpriseList = (List)dataMap.get("existEnterpriseList");
        Map<String, Long> idMap = existEnterpriseList.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId));
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList<DgOrganizationReqDto> reqDtoList = new ArrayList<DgOrganizationReqDto>();
        try {
            for (ImportSaleOrganizationDto dto : passList) {
                DgOrganizationReqDto reqDto = new DgOrganizationReqDto();
                reqDto.setCode(dto.getCode());
                reqDto.setName(dto.getName());
                reqDto.setParentCode(dto.getEnterpriseCode());
                reqDto.setParentName(dto.getEnterpriseName());
                reqDto.setParentId(idMap.get(dto.getEnterpriseCode()));
                reqDtoList.add(reqDto);
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u9500\u552e\u7ec4\u7ec7,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
            this.iDgTobOrganizationApi.addOrgBatch(reqDtoList);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            passList.forEach(item -> item.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", item.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5199\u5165\u5931\u8d25" + e.getMessage())));
        }
    }

    private Boolean saleOrgVerify(ImportSaleOrganizationDto dto, List<String> existOrgList, List<String> existEnterpriseList) {
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setErrorMsg("\u7ec4\u7ec7\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCode())) {
            dto.setErrorMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getEnterpriseCode())) {
            dto.setErrorMsg("\u516c\u53f8\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (existOrgList.contains(dto.getCode())) {
            dto.setErrorMsg("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u5230\u7cfb\u7edf\u9875\u9762\u64cd\u4f5c\uff1a" + dto.getCode());
            return false;
        }
        if (!existEnterpriseList.contains(dto.getEnterpriseCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u5148\u6dfb\u52a0\u9500\u552e\u516c\u53f8\uff1a" + dto.getEnterpriseCode());
            return false;
        }
        return true;
    }
}

