/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.api.specification.ISpecificationNameApi;
import com.yunxi.dg.base.center.item.api.specification.ISpecificationValueApi;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNameDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNamePageReqDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValueDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValuePageReqDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationValueReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SpecificationValueImportReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_specification_value_import")
public class SpecificationValueCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SpecificationValueCommonServiceImpl.class);
    @Resource
    private ISpecificationNameApi specificationNameApi;
    @Resource
    private ISpecificationValueApi specificationValueApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), SpecificationValueImportReqDto.class);
        ArrayList<SpecificationValueImportReqDto> passList = new ArrayList<SpecificationValueImportReqDto>();
        ArrayList<String> nameCodeList = new ArrayList<String>();
        for (SpecificationValueImportReqDto importDto : list) {
            if (!Objects.nonNull(importDto.getName())) continue;
            nameCodeList.add(importDto.getPropNameCode());
        }
        Map<String, SpecificationNameDto> nameDtoMap = this.getNameDtoMap(nameCodeList);
        ArrayList<String> leastKeyList = new ArrayList<String>();
        for (SpecificationValueImportReqDto importReqDto : list) {
            SpecificationNameDto specificationNameDto;
            if (!Objects.nonNull(importReqDto.getPropNameCode()) || !Objects.nonNull(importReqDto.getName()) || Objects.isNull(specificationNameDto = nameDtoMap.get(importReqDto.getPropNameCode()))) continue;
            String leastKey = specificationNameDto.getId() + importReqDto.getName();
            importReqDto.setLeastKey(leastKey);
            leastKeyList.add(leastKey);
        }
        Map<String, SpecificationValueDto> valueDtoMap = this.getValueDtoMapByLeastKeys(leastKeyList);
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        for (SpecificationValueImportReqDto dto : list) {
            Boolean verify = this.unitVerify(dto, nameDtoMap, valueDtoMap, codeSet, nameSet);
            if (verify.booleanValue()) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    private Map<String, SpecificationValueDto> getValueDtoMapByLeastKeys(List<String> leastKeyList) {
        Map<String, Object> nameDtoMap = new HashMap<String, SpecificationValueDto>();
        if (CollectionUtil.isNotEmpty(leastKeyList)) {
            SpecificationValuePageReqDto reqDto = new SpecificationValuePageReqDto();
            reqDto.setLeastKeyList(leastKeyList);
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(leastKeyList.size()));
            List nameDtos = ((PageInfo)this.specificationValueApi.queryPage(reqDto).getData()).getList();
            if (CollectionUtil.isNotEmpty((Collection)nameDtos)) {
                nameDtoMap = nameDtos.stream().collect(Collectors.toMap(SpecificationValueDto::getLeastKey, Function.identity(), (k1, k2) -> k2));
            }
        }
        return nameDtoMap;
    }

    private Map<String, SpecificationNameDto> getNameDtoMap(List<String> nameCodeList) {
        Map<String, Object> nameDtoMap = new HashMap<String, SpecificationNameDto>();
        if (CollectionUtil.isNotEmpty(nameCodeList)) {
            SpecificationNamePageReqDto reqDto = new SpecificationNamePageReqDto();
            reqDto.setCodeList(nameCodeList);
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(nameCodeList.size()));
            List nameDtos = ((PageInfo)this.specificationNameApi.queryPage(reqDto).getData()).getList();
            if (CollectionUtil.isNotEmpty((Collection)nameDtos)) {
                nameDtoMap = nameDtos.stream().collect(Collectors.toMap(SpecificationNameDto::getCode, Function.identity(), (k1, k2) -> k2));
            }
        }
        return nameDtoMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtos = Lists.newArrayList();
        try {
            for (SpecificationValueImportReqDto modeDto : passList) {
                SpecificationValueReqDto dto = new SpecificationValueReqDto();
                BeanUtil.copyProperties((Object)modeDto, (Object)dto, (String[])new String[0]);
                reqDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specificationValueApi.addBatch((List)reqDtos);
    }

    private Boolean unitVerify(SpecificationValueImportReqDto dto, Map<String, SpecificationNameDto> nameDtoMap, Map<String, SpecificationValueDto> valueDtoMap, Set<String> codeList, Set<String> nameList) {
        if (Objects.isNull(dto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (codeList.contains(dto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (Objects.isNull(dto.getPropNameCode())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (Objects.isNull(nameDtoMap.get(dto.getPropNameCode()))) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u4e0d\u5b58\u5728!");
            return false;
        }
        if (Objects.isNull(dto.getName())) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (nameList.contains(dto.getName())) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u540d\u79f0\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (dto.getName().length() > 50) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (dto.getCode().length() > 50) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (Objects.nonNull(dto.getExternalCode()) && dto.getExternalCode().length() > 50) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u5916\u90e8\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (Objects.isNull(dto.getLeastKey())) {
            dto.setErrorMsg(dto.getPropNameCode() + "\u89c4\u683c\u9879\u4fe1\u606f\u4e0d\u5b58\u5728");
            return false;
        }
        SpecificationValueDto specificationvalueDto = valueDtoMap.get(dto.getLeastKey());
        if (Objects.nonNull(specificationvalueDto) && !Objects.equals(dto.getCode(), specificationvalueDto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u503c\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        codeList.add(dto.getCode());
        nameList.add(dto.getName());
        return true;
    }
}

