/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yundt.boot.center.data.dto.request.AreaReqDto;
import com.yundt.boot.center.data.proxy.api.IAreaExtApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AreaDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportAreaDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_area_import")
public class AreaCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AreaCommonServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(AreaCommonServiceImpl.class);
    @Resource
    private IAreaExtQueryApiProxy iAreaExtQueryApiProxy;
    @Resource
    private IAreaExtApiProxy iAreaExtApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        this.logger.info("\u533a\u57df\u8bfb\u53d6\u6570\u91cf====>>>{}", (Object)result.getList().size());
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportAreaDto.class);
        ArrayList<ImportAreaDto> passList = new ArrayList<ImportAreaDto>();
        AreaQueryExtReqDto extReqDto = new AreaQueryExtReqDto();
        Set nameList = list.stream().map(ImportAreaDto::getName).collect(Collectors.toSet());
        this.logger.info("\u4f20\u5165\u7684\u540d\u5b57\u5217\u8868====>>>{}", nameList);
        HashSet parentNameList = list.stream().map(ImportAreaDto::getParentName).collect(Collectors.toSet());
        nameList.addAll(CollectionUtils.isNotEmpty(parentNameList) ? parentNameList : new HashSet());
        extReqDto.setNameList(new ArrayList(nameList));
        this.logger.info("\u67e5\u8be2\u5168\u90e8\u7684\u5730\u5740\u4fe1\u606f\u524d\u7684\u5165\u53c2====>>>{}", (Object)extReqDto);
        List existAreas = (List)this.iAreaExtQueryApiProxy.queryList(extReqDto).getData();
        this.logger.info("\u5168\u90e8\u7684\u5730\u5740\u4fe1\u606f====>>>{}", (Object)existAreas);
        Map<String, AreaDto> nameAreaDtoMap = ((List)Optional.ofNullable(existAreas).orElse(new ArrayList())).stream().collect(Collectors.toMap(AreaDto::getName, Function.identity(), (v1, v2) -> v1));
        ArrayList<String> repeatAreas = new ArrayList<String>();
        for (ImportAreaDto dto : list) {
            Boolean verify = this.verifyAreaImportParams(repeatAreas, dto, nameAreaDtoMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        this.logger.info("passList:{}", passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        ArrayList reqDtoList = new ArrayList();
        passList.forEach(dto -> {
            AreaReqDto reqDto = new AreaReqDto();
            CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
            reqDto.setName(dto.getName());
            reqDto.setLevelId(dto.getLevelId());
            reqDto.setParentCode(dto.getParentCode());
            reqDtoList.add(reqDto);
        });
        this.iAreaExtApiProxy.addAreaBatch(reqDtoList);
        this.logger.info("\u533a\u57df\u5bfc\u5165\u6570\u91cf====>>>{}", (Object)reqDtoList.size());
    }

    private Boolean verifyAreaImportParams(List<String> repeatAreas, ImportAreaDto dto, Map<String, AreaDto> existAreas) {
        if (StringUtils.isBlank((CharSequence)dto.getAreaType())) {
            dto.setErrorMsg("\u533a\u57df\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!("\u56fd\u5bb6".equals(dto.getAreaType()) || "\u7701".equals(dto.getAreaType()) || "\u5e02".equals(dto.getAreaType()) || "\u533a".equals(dto.getAreaType()))) {
            dto.setErrorMsg("\u533a\u57df\u7c7b\u578b\u4e0d\u6b63\u786e");
            return false;
        }
        if ("\u56fd\u5bb6".equals(dto.getAreaType())) {
            dto.setErrorMsg("\u6682\u4e0d\u652f\u6301\u56fd\u5bb6\u5bfc\u5165");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setErrorMsg("\u533a\u57df\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (repeatAreas.contains(dto.getUniqueKey())) {
            dto.setErrorMsg("\u91cd\u590d\u6570\u636e\uff0c\u533a\u57df\u540d\u79f0\u4e0e\u533a\u57df\u7c7b\u578b\u91cd\u590d");
            return false;
        }
        if (!"\u7701".equals(dto.getAreaType()) && StringUtils.isBlank((CharSequence)dto.getParentName())) {
            dto.setErrorMsg("\u533a\u57df\u7c7b\u578b\u4e3a\u975e\u4e00\u7ea7\u7c7b\u578b\u65f6\uff0c\u4e0a\u7ea7\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (dto.getName().length() > 20) {
            dto.setErrorMsg("\u533a\u57df\u540d\u79f0\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc720");
            return false;
        }
        if (Objects.nonNull(existAreas.get(dto.getName()))) {
            dto.setErrorMsg("\u533a\u57df\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(existAreas.get(dto.getParentName()))) {
            dto.setErrorMsg("\u4e0a\u7ea7\u533a\u57df\u540d\u79f0\u4e0d\u5b58\u5728");
            return false;
        }
        String regex = "^-?\\d+(\\.\\d{1,6})?$";
        if (StringUtils.isNotBlank((CharSequence)dto.getLocationX())) {
            if (!dto.getLocationX().matches(regex)) {
                dto.setErrorMsg("\u7ecf\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e");
                return false;
            }
            if (dto.getLocationX().length() > 100) {
                dto.setErrorMsg("\u7ecf\u5ea6\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7100");
                return false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getLocationY())) {
            if (!dto.getLocationY().matches(regex)) {
                dto.setErrorMsg("\u7eac\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e");
                return false;
            }
            if (dto.getLocationY().length() > 100) {
                dto.setErrorMsg("\u7eac\u5ea6\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7100");
                return false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAlias())) {
            String[] split;
            for (String s : split = dto.getAlias().split(",")) {
                if (s.length() <= 100) continue;
                dto.setErrorMsg("\u5355\u4e2a\u522b\u540d\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7100");
                return false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark()) && dto.getRemark().length() > 200) {
            dto.setErrorMsg("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7100");
            return false;
        }
        repeatAreas.add(dto.getUniqueKey());
        dto.setParentCode(existAreas.get(dto.getParentName()).getCode());
        switch (dto.getAreaType()) {
            case "\u7701": {
                dto.setLevelId(Integer.valueOf(0));
                break;
            }
            case "\u5e02": {
                dto.setLevelId(Integer.valueOf(1));
                break;
            }
            case "\u533a": {
                dto.setLevelId(Integer.valueOf(2));
            }
        }
        return true;
    }
}

