/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.api.description.IDgMultilevelDescriptionBizApi;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.description.DgMultilevelDescriptionDto;
import com.yunxi.dg.base.center.trade.dto.description.DgMultilevelDescriptionPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordPageReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterTypeRecordApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.LitterNoAmountRefundOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_after_no_litter_amount_refund_order_import")
public class LitterNoAmountRefundOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LitterNoAmountRefundOrderCommonServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IDgAfterTypeRecordApiProxy dgAfterTypeRecordApiProxy;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    @Resource
    private IDgMultilevelDescriptionBizApi dgMultilevelDescriptionBizApi;
    public static final String BIZ_MODEL = "FHHTK";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
    public static final SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy.MM.dd");
    public static final SimpleDateFormat dateFormat4 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static final SimpleDateFormat dateFormat5 = new SimpleDateFormat("MM\u6708dd\u65e5");

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u53d1\u8d27\u540e\u9000\u6b3e\u65e0\u539f\u5355\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), LitterNoAmountRefundOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            throw new BizException("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (resultList.size() > 1000) {
            throw new BizException("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
        }
        Set skuCodes = resultList.stream().map(LitterNoAmountRefundOrderImportDto::getSkuCode).collect(Collectors.toSet());
        Set shopCodes = resultList.stream().map(LitterNoAmountRefundOrderImportDto::getShopCode).collect(Collectors.toSet());
        Map<String, DgItemSkuDetailRespDto> skuInfoMap = this.getSkuInfoByCodes(new ArrayList<String>(skuCodes));
        Map<String, DgShopRespDto> shopInfoMap = this.getShop(new ArrayList<String>(shopCodes));
        Map<String, DgAfterTypeRecordDto> afterTypeMap = this.getAfterTypeMap();
        Map<String, String> paymentMethodMap = this.getDict("yunxi-dg-base-center-trade", "after_payment_method_enum");
        Map<String, Long> childrenMap = this.getChildren();
        for (LitterNoAmountRefundOrderImportDto importDto : resultList) {
            boolean isPass = this.checkAndInitParam(importDto, skuInfoMap, shopInfoMap, afterTypeMap, paymentMethodMap, childrenMap);
            if (isPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private Map<String, Long> getChildren() {
        DgMultilevelDescriptionPageReqDto dgMultilevelDescriptionPageReqDto = new DgMultilevelDescriptionPageReqDto();
        dgMultilevelDescriptionPageReqDto.setType("after_sale");
        DgMultilevelDescriptionDto dgMultilevelDescriptionDto = (DgMultilevelDescriptionDto)RestResponseHelper.extractData((RestResponse)this.dgMultilevelDescriptionBizApi.queryTree(dgMultilevelDescriptionPageReqDto));
        log.info("\u5185\u90e8\u552e\u540e\u539f\u56e0\u7684\u8fd4\u56de\u7ed3\u679c1\uff1a{}", (Object)JSON.toJSONString((Object)dgMultilevelDescriptionDto));
        HashMap<String, Long> names = new HashMap<String, Long>();
        if (dgMultilevelDescriptionDto != null) {
            this.collectIdsByName(dgMultilevelDescriptionDto, names);
            log.info("\u5185\u90e8\u552e\u540e\u539f\u56e0\u7684\u8fd4\u56de\u7ed3\u679c2\uff1a{}", (Object)JSON.toJSONString(names));
        }
        return names;
    }

    private void collectIdsByName(DgMultilevelDescriptionDto dto, Map<String, Long> names) {
        if (dto != null && dto.getName() != null && dto.getId() != null) {
            names.put(dto.getName(), dto.getId());
        }
        if (dto.getChildren() != null) {
            for (DgMultilevelDescriptionDto child : dto.getChildren()) {
                this.collectIdsByName(child, names);
            }
        }
    }

    private boolean checkAndInitParam(LitterNoAmountRefundOrderImportDto importDto, Map<String, DgItemSkuDetailRespDto> skuInfoMap, Map<String, DgShopRespDto> shopInfoMap, Map<String, DgAfterTypeRecordDto> afterTypeMap, Map<String, String> paymentMethodMap, Map<String, Long> childrenMap) {
        StringBuffer errorMsg = new StringBuffer();
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuInfoMap.get(importDto.getSkuCode());
        if (Objects.isNull(dgItemSkuDetailRespDto)) {
            errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728;");
        } else {
            importDto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
            importDto.setItemId(dgItemSkuDetailRespDto.getItemId());
            importDto.setItemCode(dgItemSkuDetailRespDto.getItemCode());
            importDto.setItemName(dgItemSkuDetailRespDto.getItemName());
            importDto.setVolume(dgItemSkuDetailRespDto.getVolume());
            importDto.setWeight(dgItemSkuDetailRespDto.getGrossWeight());
        }
        DgShopRespDto dgShopRespDto = shopInfoMap.get(importDto.getShopCode());
        if (Objects.isNull(dgShopRespDto)) {
            errorMsg.append("\u5e97\u94fa\u4e0d\u5b58\u5728;");
        } else if (Objects.isNull(dgShopRespDto.getStoreType())) {
            errorMsg.append("\u5e97\u94fa\u7c7b\u578b\u4e0d\u5b58\u5728");
        } else {
            importDto.setShopId(dgShopRespDto.getId());
            importDto.setShopName(dgShopRespDto.getStoreName());
        }
        DgAfterTypeRecordDto afterTypeRecordDto = afterTypeMap.get(importDto.getAfterBusinessTypeName());
        if (afterTypeRecordDto == null) {
            errorMsg.append("\u552e\u540e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b");
        } else {
            importDto.setIfInvoice(afterTypeRecordDto.getIfInvoice());
            importDto.setIfRecord(afterTypeRecordDto.getIfRecord());
            importDto.setAfterBusinessTypeCode(afterTypeRecordDto.getAfterBusinessTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getPaymentMethodStr())) {
            if (paymentMethodMap.containsKey(importDto.getPaymentMethodStr())) {
                importDto.setPaymentMethod(paymentMethodMap.get(importDto.getPaymentMethodStr()));
            } else {
                errorMsg.append("\u552e\u540e\u6536\u6b3e\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getAfterSaleOrderReason())) {
            Long id = childrenMap.get(importDto.getAfterSaleOrderReason());
            log.info("\u5185\u90e8\u552e\u540e\u539f\u56e0\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)id);
            if (id == null) {
                errorMsg.append("\u5185\u90e8\u552e\u540e\u539f\u56e0\u4e0d\u5b58\u5728;");
            }
        }
        if (importDto.getRefundAmount().compareTo(BigDecimal.ZERO) <= 0) {
            errorMsg.append("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5c0f\u7b49\u4e8e0\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getResponsiblePartyStr())) {
            if (importDto.getResponsiblePartyStr().equals("\u5ba2\u6237")) {
                importDto.setResponsibleParty(Integer.valueOf(1));
            } else if (importDto.getResponsiblePartyStr().equals("\u516c\u53f8")) {
                importDto.setResponsibleParty(Integer.valueOf(2));
            } else if (importDto.getResponsiblePartyStr().equals("\u7269\u6d41")) {
                importDto.setResponsibleParty(Integer.valueOf(3));
            } else if (importDto.getResponsiblePartyStr().equals("\u5176\u4ed6\u4e09\u65b9")) {
                importDto.setResponsibleParty(Integer.valueOf(4));
            } else {
                errorMsg.append("\u8d23\u4efb\u65b9\u4e0d\u5b58\u5728");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getPlanRefundDate())) {
            log.info("\u5bfc\u5165\u7684\u9000\u6b3e\u65f6\u95f4\u662f\uff1a{}", (Object)importDto.getPlanRefundDate());
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                String inputDateStr = importDto.getPlanRefundDate();
                Date date = this.dateTransformer(inputDateStr);
                importDto.setPlanRefundDate(outputFormat.format(date));
            }
            catch (Exception e) {
                errorMsg.append("\u5efa\u8bae\u9000\u6b3e\u65f6\u95f4\u5f02\u5e38");
                log.info("\u683c\u5f0f\u5316\u65f6\u95f4\u5f02\u5e38");
            }
        }
        importDto.setErrorMsg(errorMsg.toString());
        log.info("\u53d1\u8d27\u540e\u9000\u6b3e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)errorMsg));
        return errorMsg.length() > 0;
    }

    private Map<String, String> getDict(String groupCode, String code) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(groupCode, code));
        if (Objects.isNull(dictDto) || CollectionUtil.isEmpty((Collection)dictDto.getDictValueList())) {
            return MapUtil.empty();
        }
        return dictDto.getDictValueList().stream().collect(Collectors.toMap(DictValueDto::getLabel, DictValueDto::getValue, (v1, v2) -> v2));
    }

    private Map<String, DgItemSkuDetailRespDto> getSkuInfoByCodes(List<String> skuCodes) {
        ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
        skuReqDto.setSkuCodes(skuCodes);
        return ((List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData()).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity()));
    }

    private Map<String, DgShopRespDto> getShop(List<String> shopCodes) {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setStoreCodeList(shopCodes);
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{1}));
        List dgShopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.queryListShop(reqDto));
        if (Objects.isNull(dgShopRespDtos) || CollectionUtil.isEmpty((Collection)dgShopRespDtos)) {
            return MapUtil.empty();
        }
        return dgShopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, DgAfterTypeRecordDto> getAfterTypeMap() {
        DgAfterTypeRecordPageReqDto reqDto = new DgAfterTypeRecordPageReqDto();
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setAfterTypeCode(BIZ_MODEL);
        reqDto.setTypeStatus(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgAfterTypeRecordApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgAfterTypeRecordDto::getAfterBusinessTypeName, Function.identity(), (v1, v2) -> v2));
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u53d1\u8d27\u540e\u9000\u6b3e\u65e0\u539f\u5355-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        Map<String, Long> childrenMap = this.getChildren();
        Map<String, List<LitterNoAmountRefundOrderImportDto>> orderMap = passList.stream().collect(Collectors.groupingBy(LitterNoAmountRefundOrderImportDto::getOrderUniqueKey));
        for (String orderKey : orderMap.keySet()) {
            List<LitterNoAmountRefundOrderImportDto> importDtos = this.processSameSkuCode(orderMap.get(orderKey));
            LitterNoAmountRefundOrderImportDto dto = importDtos.get(0);
            DgBizAfterSaleOrderReqDto reqDto = this.buildDgBizAfterSaleOrderReqDto(importDtos, childrenMap);
            this.saveOrder(respDto, reqDto, dto);
            importDtos.forEach(giftDto -> giftDto.setErrorMsg(dto.getErrorMsg()));
        }
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizAfterSaleOrderReqDto reqDto, LitterNoAmountRefundOrderImportDto dto) {
        try {
            log.info("createAfterSale\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.dgAfterSaleOrderApiProxy.createAfterSale(BIZ_MODEL, reqDto));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u5bfc\u5165\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    private void setErrorMsg(LitterNoAmountRefundOrderImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }

    private DgBizAfterSaleOrderReqDto buildDgBizAfterSaleOrderReqDto(List<LitterNoAmountRefundOrderImportDto> importDtos, Map<String, Long> childrenMap) {
        Long id;
        LitterNoAmountRefundOrderImportDto litterAmountRefundOrderImportDto = importDtos.get(0);
        DgBizAfterSaleOrderReqDto reqDto = new DgBizAfterSaleOrderReqDto();
        BeanUtil.copyProperties((Object)litterAmountRefundOrderImportDto, (Object)reqDto, (String[])new String[]{"planRefundDate"});
        log.info("\u5bfc\u5165\u7684\u9000\u6b3e\u65f6\u95f4\u662f\uff1a{}", (Object)litterAmountRefundOrderImportDto.getPlanRefundDate());
        reqDto.setPlanRefundDate((Date)DateUtil.beginOfDay((Date)DateUtil.parse((CharSequence)litterAmountRefundOrderImportDto.getPlanRefundDate())));
        String afterSaleOrderReason = litterAmountRefundOrderImportDto.getAfterSaleOrderReason();
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReason) && (id = childrenMap.get(afterSaleOrderReason)) != null) {
            reqDto.setAfterSaleOrderReason(id.toString());
        }
        reqDto.setBizDate(new Date());
        reqDto.setBizType(BIZ_MODEL);
        reqDto.setChannelCode("INNER");
        reqDto.setAfterSaleOrderType(BIZ_MODEL);
        reqDto.setPlatformApplyRefundType("REFUND_RETURN");
        reqDto.setStatus("WAIT_AUDIT");
        reqDto.setRelateToPlatformOrder(Integer.valueOf(1));
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setRefundStatus("1");
        BigDecimal refundFee = BigDecimal.ZERO;
        ArrayList<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (LitterNoAmountRefundOrderImportDto detail : importDtos) {
            DgAfterSaleOrderItemModifyReqDto modifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
            BeanUtil.copyProperties((Object)detail, (Object)modifyReqDto, (String[])new String[0]);
            modifyReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
            modifyReqDto.setIsGift(Integer.valueOf(0));
            refundFee = refundFee.add(detail.getRefundAmount());
            afterSaleOrderItemReqDtoList.add(modifyReqDto);
        }
        reqDto.setRefundFee(refundFee);
        reqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        return reqDto;
    }

    private List<LitterNoAmountRefundOrderImportDto> processSameSkuCode(List<LitterNoAmountRefundOrderImportDto> list) {
        return list.stream().collect(Collectors.toMap(LitterNoAmountRefundOrderImportDto::getSkuCode, Function.identity(), (o1, o2) -> {
            o1.setRefundAmount(o1.getRefundAmount().add(o2.getRefundAmount()));
            return o1;
        })).values().stream().collect(Collectors.toList());
    }

    private Date dateTransformer(String dataStr) {
        Date date;
        block13: {
            log.info("\u65e5\u671f\u8f6c\u6362\u5165\u53c2\u5b57\u7b26\u4e32\uff1a{}", (Object)dataStr);
            date = null;
            try {
                date = dateFormat.parse(dataStr);
            }
            catch (ParseException e1) {
                try {
                    date = dateFormat1.parse(dataStr);
                }
                catch (ParseException e2) {
                    try {
                        date = dateFormat2.parse(dataStr);
                    }
                    catch (ParseException e3) {
                        try {
                            date = dateFormat3.parse(dataStr);
                        }
                        catch (ParseException e4) {
                            try {
                                date = dateFormat4.parse(dataStr);
                            }
                            catch (ParseException e5) {
                                try {
                                    date = dateFormat5.parse(dataStr);
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTime(date);
                                    calendar.set(1, Calendar.getInstance().get(1));
                                    date = calendar.getTime();
                                }
                                catch (ParseException e) {
                                    if (dataStr.length() == 5) {
                                        date = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)new Double(dataStr));
                                        break block13;
                                    }
                                    log.info("\u8f93\u5165\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)dataStr);
                                }
                            }
                        }
                    }
                }
            }
        }
        log.info("\u65e5\u671f\u8f6c\u6362\u7ed3\u679c\uff1a{}", (Object)date);
        return date;
    }
}

