/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoQueryExtDto;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IShippingMarkManagementApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportShippingMarkManagementItemReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportShippingMarkManagementItemRespDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_shipping_mark_management_item")
public class ShippingMarkManagementItemCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ShippingMarkManagementItemCommonServiceImpl.class);
    @Resource
    private IShippingMarkManagementApiProxy iShippingMarkManagementApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy iTransactionCustomerQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u551b\u5934\u7ba1\u7406\u6309\u5546\u54c1\u5bfc\u5165");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List list = BeanUtil.copyToList((Collection)result.getList(), ImportShippingMarkManagementItemReqDto.class);
        ArrayList passList = Lists.newArrayList();
        HashMap<String, ImportShippingMarkManagementItemReqDto> map = new HashMap<String, ImportShippingMarkManagementItemReqDto>();
        for (ImportShippingMarkManagementItemReqDto dto : list) {
            boolean isPass = this.paramVerify(dto, map);
            if (isPass) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        List reqDto = BeanUtil.copyToList((Collection)passList, ShippingMarkManagementDto.class);
        for (ShippingMarkManagementDto dto : reqDto) {
            ShippingMarkManagementPageReqDto pageReqDto = new ShippingMarkManagementPageReqDto();
            pageReqDto.setCustomerCode(dto.getCustomerCode());
            pageReqDto.setSkuCode(dto.getSkuCode());
            List shippingMarkManagementDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iShippingMarkManagementApiProxy.page(pageReqDto))).getList();
            if (CollectionUtil.isNotEmpty((Collection)shippingMarkManagementDtoList)) {
                RestResponseHelper.checkOrThrow((RestResponse)this.iShippingMarkManagementApiProxy.update(dto));
                continue;
            }
            RestResponseHelper.checkOrThrow((RestResponse)this.iShippingMarkManagementApiProxy.insert(dto));
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u551b\u5934\u7ba1\u7406\u6309\u5546\u54c1\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.SHIPPING_MARK_MANAGEMENT_ITEM.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        ShippingMarkManagementPageReqDto pageReqDto = new ShippingMarkManagementPageReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            pageReqDto = (ShippingMarkManagementPageReqDto)JSON.parseObject((String)filter, ShippingMarkManagementPageReqDto.class);
        }
        List pageList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iShippingMarkManagementApiProxy.page(pageReqDto))).getList();
        ArrayList<ExportShippingMarkManagementItemRespDto> list = new ArrayList<ExportShippingMarkManagementItemRespDto>();
        if (CollectionUtil.isEmpty((Collection)pageList)) {
            return Collections.EMPTY_LIST;
        }
        Integer num = 1;
        for (ShippingMarkManagementDto dto : pageList) {
            ExportShippingMarkManagementItemRespDto exportDto = (ExportShippingMarkManagementItemRespDto)BeanUtil.copyProperties((Object)dto, ExportShippingMarkManagementItemRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportDto.setNumber(n);
            list.add(exportDto);
        }
        log.info("\u551b\u5934\u7ba1\u7406\u6309\u5546\u54c1\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private boolean paramVerify(ImportShippingMarkManagementItemReqDto dto, Map<String, ImportShippingMarkManagementItemReqDto> map) {
        if (CollectionUtil.isNotEmpty(map) && map.containsKey(dto.getUniqueKey())) {
            dto.setErrorMsg("\u8be5\u5ba2\u6237+SKU\u7f16\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
            return false;
        }
        DgCustomerInfoQueryExtDto queryExtDto = new DgCustomerInfoQueryExtDto();
        queryExtDto.setCustomerCode(dto.getCustomerCode());
        List dgCustomerInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iTransactionCustomerQueryApiProxy.queryListExt(queryExtDto));
        if (CollectionUtil.isEmpty((Collection)dgCustomerInfoRespDtos)) {
            dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(dto.getSkuCode());
        List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(codeList));
        if (CollectionUtil.isEmpty((Collection)itemSkuDgRespDtos)) {
            dto.setErrorMsg("SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        map.put(dto.getUniqueKey(), dto);
        return true;
    }
}

