/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehousePageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.SeparateRuleChannelWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.SeparateRuleChannelWarehousePageReqDto;
import com.yunxi.dg.base.center.share.proxy.rule.ISeparateRuleChannelWarehouseApiProxy;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgChannelWarehouseApiProxy;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgVirtualWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ExportSplitWarehouseConfigurationDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportSplitWarehouseConfigurationModeDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_split_warehouse_configuration")
public class SplitWarehouseConfigurationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SplitWarehouseConfigurationCommonServiceImpl.class);
    @Resource
    private ISeparateRuleChannelWarehouseApiProxy separateRuleChannelWarehouseApiProxy;
    @Resource
    private IDgChannelWarehouseApiProxy channelWarehouseApiProxy;
    @Resource
    private IDgVirtualWarehouseApiProxy virtualWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5206\u4ed3\u4ed3\u5e93\u914d\u7f6e");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportSplitWarehouseConfigurationModeDto> passList = new ArrayList<ImportSplitWarehouseConfigurationModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportSplitWarehouseConfigurationModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u5206\u4ed3\u4ed3\u5e93\u914d\u7f6e,\u5bfc\u5165\u5206\u4ed3\u4ed3\u5e93\u914d\u7f6e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List virtualWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApiProxy.list(new DgVirtualWarehousePageReqDto()))).orElse(new ArrayList());
        Map<String, DgVirtualWarehouseDto> virtualWarehouseDtoMap = virtualWarehouseDtos.stream().collect(Collectors.toMap(DgVirtualWarehouseDto::getWarehouseName, Function.identity(), (e1, e2) -> e1));
        List channelWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.channelWarehouseApiProxy.list(new DgChannelWarehousePageReqDto()))).orElse(new ArrayList());
        Map<String, DgChannelWarehouseDto> channelWarehouseDtoMap = channelWarehouseDtos.stream().collect(Collectors.toMap(DgChannelWarehouseDto::getWarehouseName, Function.identity(), (e1, e2) -> e1));
        for (ImportSplitWarehouseConfigurationModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, virtualWarehouseDtoMap, channelWarehouseDtoMap);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u5206\u4ed3\u4ed3\u5e93\u914d\u7f6e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List separateRuleChannelWarehouseDtos = BeanUtil.copyToList((Collection)passList, SeparateRuleChannelWarehouseDto.class);
        this.separateRuleChannelWarehouseApiProxy.batchInsert(separateRuleChannelWarehouseDtos);
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        SeparateRuleChannelWarehousePageReqDto reqDto = new SeparateRuleChannelWarehousePageReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            reqDto = (SeparateRuleChannelWarehousePageReqDto)JSON.parseObject((String)filter, SeparateRuleChannelWarehousePageReqDto.class);
        }
        log.info("\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        if (FileModeTypeEnum.SPLIT_WAREHOUSE_CONFIGURATION.getKey().equals(key)) {
            List separateRuleChannelWarehouseDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.separateRuleChannelWarehouseApiProxy.page(reqDto))).getList();
            List splitWarehouseConfigurationDtoList = BeanUtil.copyToList((Collection)separateRuleChannelWarehouseDtos, ExportSplitWarehouseConfigurationDto.class);
            Map configurationDtoMap = separateRuleChannelWarehouseDtos.stream().collect(Collectors.toMap(SeparateRuleChannelWarehouseDto::getWarehouseCode, Function.identity(), (e1, e2) -> e1));
            int number = 0;
            for (ExportSplitWarehouseConfigurationDto dto : splitWarehouseConfigurationDtoList) {
                dto.setNumber(Integer.valueOf(++number));
                dto.setUpdatePerson(((SeparateRuleChannelWarehouseDto)configurationDtoMap.get(dto.getWarehouseCode())).getUpdatePerson());
                dto.setUpdateTime(DateUtil.formatDateTime((Date)((SeparateRuleChannelWarehouseDto)configurationDtoMap.get(dto.getWarehouseCode())).getUpdateTime()));
                dto.setCreatePerson(((SeparateRuleChannelWarehouseDto)configurationDtoMap.get(dto.getWarehouseCode())).getCreatePerson());
                dto.setCreateTime(DateUtil.formatDateTime((Date)((SeparateRuleChannelWarehouseDto)configurationDtoMap.get(dto.getWarehouseCode())).getCreateTime()));
            }
            return splitWarehouseConfigurationDtoList;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean paramVerify(ImportSplitWarehouseConfigurationModeDto dto, Map<String, DgVirtualWarehouseDto> virtualWarehouseDtoMap, Map<String, DgChannelWarehouseDto> channelWarehouseDtoMap) {
        if (StringUtils.isBlank((CharSequence)dto.getChannelName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!channelWarehouseDtoMap.containsKey(dto.getChannelName())) {
            this.setErrorMsg(dto, dto.getChannelName() + "\u6e20\u9053\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setChannelCode(channelWarehouseDtoMap.get(dto.getChannelName()).getWarehouseCode());
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!virtualWarehouseDtoMap.containsKey(dto.getWarehouseName())) {
            this.setErrorMsg(dto, dto.getWarehouseName() + "\u4f9b\u8d27\u4ed3\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setWarehouseCode(virtualWarehouseDtoMap.get(dto.getWarehouseName()).getWarehouseCode());
        return true;
    }

    private String setErrorMsg(ImportSplitWarehouseConfigurationModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

