/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.blakclistbiz.IWarehouseBlacklistApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgLogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.AddBatchWarehouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.AddWarehouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.PageWarehouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.WareHouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.DgLogicWarehouseOrgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportWarehouseBlacklistModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_warehouse_blacklist")
public class WarehouseBlacklistCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(WarehouseBlacklistCommonServiceImpl.class);
    @Resource
    private IDgPhysicsWarehouseApiProxy iDgPhysicsWarehouseApiProxy;
    @Resource
    private IWarehouseBlacklistApiProxy iWarehouseBlacklistApiProxy;
    @Resource
    private IDgLogicWarehouseApiProxy iDgLogicWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), ImportWarehouseBlacklistModeDto.class);
        logger.info("\u8fdb\u5165\u8865\u8d27\u4ed3\u9ed1\u540d\u5355\u5bfc\u5165:{}", JSON.toJSON((Object)importDtoList));
        Map<String, List<DgPhysicsWarehouseDto>> warehouseDtoMap = this.dgPhysicsWarehouseDtoMap();
        Map<String, Map<String, WareHouseBlacklistDto>> blacklistMap = this.getWareHouseBlacklistMap();
        Map<String, DgLogicWarehouseOrgRespDto> mapOrgDtoInfo = this.mapOrgDtoInfo();
        Map<String, WareHouseBlacklistDto> wareHouseBlacklistDtoMap = this.mapWarehouseBlackExist(importDtoList);
        HashMap<String, ImportWarehouseBlacklistModeDto> repetitionMap = new HashMap<String, ImportWarehouseBlacklistModeDto>();
        ArrayList<ImportWarehouseBlacklistModeDto> list = new ArrayList<ImportWarehouseBlacklistModeDto>();
        for (ImportWarehouseBlacklistModeDto blacklistModeDto : importDtoList) {
            blacklistModeDto.setCreatePerson(commonReqDto.getCreatePerson());
            blacklistModeDto.setUpdatePerson(commonReqDto.getCreatePerson());
            this.verifyInfo(repetitionMap, blacklistModeDto, commonReqDto, respDto);
            this.verifyUnique(blacklistModeDto, respDto, commonReqDto, wareHouseBlacklistDtoMap);
            boolean b = this.verifyPhysicsWarehouseInfo(warehouseDtoMap, blacklistMap, mapOrgDtoInfo, blacklistModeDto, commonReqDto, respDto);
            if (!StrUtil.isBlank((CharSequence)blacklistModeDto.getErrorMsg())) continue;
            list.add(blacklistModeDto);
        }
        return list;
    }

    private boolean verifyInfo(Map<String, ImportWarehouseBlacklistModeDto> repetitionMap, ImportWarehouseBlacklistModeDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return false;
        }
        ImportWarehouseBlacklistModeDto repeatDto = repetitionMap.get(importDto.getUniqueKey());
        if (Objects.nonNull(repeatDto)) {
            repeatDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", repeatDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u5e93\u5b58\u7ec4\u7ec7+\u7269\u7406\u4ed3\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u5e93\u5b58\u7ec4\u7ec7+\u7269\u7406\u4ed3\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            if (!respDto.getErrorDetails().contains(repeatDto)) {
                respDto.getErrorDetails().add(repeatDto);
            }
            return false;
        }
        repetitionMap.put(importDto.getUniqueKey(), importDto);
        return true;
    }

    private void verifyUnique(ImportWarehouseBlacklistModeDto warehouseDto, ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto, Map<String, WareHouseBlacklistDto> warehousePageReqDtoMap) {
        if (StrUtil.isNotBlank((CharSequence)warehouseDto.getErrorMsg())) {
            return;
        }
        WareHouseBlacklistDto reqDto = warehousePageReqDtoMap.get(warehouseDto.getUniqueKey());
        if (Objects.nonNull(reqDto)) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5e93\u5b58\u7ec4\u7ec7+\u7269\u7406\u4ed3\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
        }
    }

    private Map<String, WareHouseBlacklistDto> mapWarehouseBlackExist(List<ImportWarehouseBlacklistModeDto> importDtoList) {
        Set warehouseCodeSet = importDtoList.stream().filter(dto -> StringUtil.isNotBlank((CharSequence)dto.getWarehouseCode())).map(ImportWarehouseBlacklistModeDto::getWarehouseCode).collect(Collectors.toSet());
        Set organizationCodeSet = importDtoList.stream().filter(dto -> StringUtil.isNotBlank((CharSequence)dto.getOrganizationCode())).map(ImportWarehouseBlacklistModeDto::getOrganizationCode).collect(Collectors.toSet());
        if (warehouseCodeSet.isEmpty() || organizationCodeSet.isEmpty()) {
            return new HashMap<String, WareHouseBlacklistDto>();
        }
        PageWarehouseBlacklistDto queryDto = new PageWarehouseBlacklistDto();
        queryDto.setWarehouseCodes(new ArrayList(warehouseCodeSet));
        queryDto.setOrganizationCodeList(new ArrayList(organizationCodeSet));
        PageInfo wareHouseBlacklistDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iWarehouseBlacklistApiProxy.pageinfo(queryDto));
        if (CollectionUtil.isEmpty((Collection)wareHouseBlacklistDtoPageInfo.getList())) {
            return new HashMap<String, WareHouseBlacklistDto>();
        }
        Map<String, WareHouseBlacklistDto> warehouseBlackListMap = wareHouseBlacklistDtoPageInfo.getList().stream().collect(Collectors.toMap(e -> e.getOrganizationCode() + "_" + e.getWarehouseCode(), Function.identity(), (k1, k2) -> k1));
        return warehouseBlackListMap;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonAsync(result, commonReqDto, respDto, object);
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        List warehouseBlacklists = (List)object;
        if (CollectionUtil.isEmpty((Collection)warehouseBlacklists)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)warehouseBlacklists) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        this.iWarehouseBlacklistApiProxy.addBatch(AddBatchWarehouseBlacklistDto.builder().list(BeanUtil.copyToList((Collection)warehouseBlacklists, AddWarehouseBlacklistDto.class)).build());
    }

    private Map<String, DgLogicWarehouseOrgRespDto> mapOrgDtoInfo() {
        RestResponse response = this.iDgLogicWarehouseApiProxy.queryOrgList();
        Map<String, DgLogicWarehouseOrgRespDto> orgCheckMap = ((List)response.getData()).stream().collect(Collectors.toMap(DgLogicWarehouseOrgRespDto::getOrgCode, Function.identity(), (e1, e2) -> e2));
        return orgCheckMap;
    }

    private Map<String, Map<String, WareHouseBlacklistDto>> getWareHouseBlacklistMap() {
        List wareHouseBlacklist;
        RestResponse response = this.iWarehouseBlacklistApiProxy.pageinfo(PageWarehouseBlacklistDto.builder().pageNum(Integer.valueOf(Integer.MAX_VALUE)).pageSize(Integer.valueOf(1)).build());
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)response);
        List list = wareHouseBlacklist = Objects.nonNull(pageInfo) ? pageInfo.getList() : new ArrayList();
        if (CollectionUtil.isEmpty((Collection)wareHouseBlacklist)) {
            return Collections.emptyMap();
        }
        return wareHouseBlacklist.stream().collect(Collectors.groupingBy(WareHouseBlacklistDto::getWarehouseCode, Collectors.toMap(WareHouseBlacklistDto::getOrganizationCode, Function.identity())));
    }

    private boolean verifyPhysicsWarehouseInfo(Map<String, List<DgPhysicsWarehouseDto>> warehouseDtoMap, Map<String, Map<String, WareHouseBlacklistDto>> blacklistMap, Map<String, DgLogicWarehouseOrgRespDto> mapOrgDtoInfo, ImportWarehouseBlacklistModeDto blacklistModeDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        WareHouseBlacklistDto blacklistDto;
        List<DgPhysicsWarehouseDto> physicsWarehouseDtos = warehouseDtoMap.get(blacklistModeDto.getWarehouseCode());
        if (CollectionUtil.isEmpty(physicsWarehouseDtos)) {
            blacklistModeDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", blacklistModeDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(blacklistModeDto);
            return false;
        }
        if (physicsWarehouseDtos.size() > 1) {
            blacklistModeDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", blacklistModeDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u7269\u7406\u4ed3\u5b58\u5728\u591a\u4e2a\u540c\u540d\u7684\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(blacklistModeDto);
            return false;
        }
        blacklistModeDto.setWarehouseName(physicsWarehouseDtos.get(0).getWarehouseName());
        DgLogicWarehouseOrgRespDto orgDto = mapOrgDtoInfo.get(blacklistModeDto.getOrganizationCode());
        if (Objects.isNull(orgDto)) {
            blacklistModeDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", blacklistModeDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8be5\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(blacklistModeDto);
            return false;
        }
        blacklistModeDto.setOrganizationName(orgDto.getOrgName());
        Map<String, WareHouseBlacklistDto> map = blacklistMap.get(blacklistModeDto.getWarehouseCode());
        if (CollectionUtil.isNotEmpty(map) && Objects.nonNull(blacklistDto = map.get(blacklistModeDto.getOrganizationCode()))) {
            blacklistModeDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", blacklistModeDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5bfc\u5165\u540c\u7269\u7406\u4ed3\u540c\u5e93\u5b58\u7ec4\u7ec7\u7684\u6570\u636e\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(blacklistModeDto);
            return false;
        }
        return true;
    }

    private Map<String, List<DgPhysicsWarehouseDto>> dgPhysicsWarehouseDtoMap() {
        RestResponse response = this.iDgPhysicsWarehouseApiProxy.queryAll();
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgPhysicsWarehouseDto::getWarehouseCode));
    }
}

