/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.item.IItemSkuDgReportQueryApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryTakeStockOrderPageReqDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.InventoryTakeStockOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IInventoryTakeStockOrderApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.GlobalSystemConfigEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.InventoryListMappingNoBatchVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.InventoryListMappingVO;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_inventory_list_mapping")
public class InventoryListMappingCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InventoryListMappingCommonServiceImpl.class);
    @Resource
    protected IInventoryTakeStockOrderApiProxy inventoryTakeStockOrderApiProxy;
    @Resource
    private IItemSkuDgReportQueryApiProxy itemSkuDgReportQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    private Integer enableBatch = 1;

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        InventoryTakeStockOrderPageReqDto reqDto = null;
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            reqDto = (InventoryTakeStockOrderPageReqDto)JSON.parseObject((String)filter, InventoryTakeStockOrderPageReqDto.class);
        }
        log.info("\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        HashMap<String, BigDecimal> accountNumMap = new HashMap<String, BigDecimal>();
        List<Object> inventoryListMappingVOS = new ArrayList();
        if (FileModeTypeEnum.INVENTORY_LIST_MAPPING.getKey().equals(key)) {
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(100000));
            log.info("\u67e5\u8be2\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)reqDto));
            List dtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryTakeStockOrderApiProxy.queryByItemPage(reqDto))).getList();
            if (CollectionUtil.isEmpty((Collection)dtoList)) {
                return Collections.EMPTY_LIST;
            }
            log.info("\u67e5\u8be2\u5230\u6570\u636e\u8bb0\u5f55\u6570:{}", (Object)dtoList.size());
            ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
            itemQueryDgReqDto.setSkuCodes(dtoList.stream().map(InventoryTakeStockOrderDto::getSkuCode).collect(Collectors.toList()));
            List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgReportQueryApiProxy.querySkuList(itemQueryDgReqDto));
            Map itemSkuDgRespDtoMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
            for (InventoryTakeStockOrderDto inventoryTakeStockOrderDto : dtoList) {
                InventoryListMappingVO mappingVO = new InventoryListMappingVO();
                BigDecimal accountNum = BigDecimal.ZERO;
                String accountNumMapKey = inventoryTakeStockOrderDto.getSkuCode() + "_" + inventoryTakeStockOrderDto.getLogicWarehouseCode();
                LogicWarehouseQualityEnum qualityEnum = LogicWarehouseQualityEnum.getByCode((String)inventoryTakeStockOrderDto.getInventoryProperty());
                inventoryTakeStockOrderDto.setInventoryProperty(Objects.nonNull(qualityEnum) ? qualityEnum.getDesc() : null);
                if (Objects.nonNull(itemSkuDgRespDtoMap.get(inventoryTakeStockOrderDto.getSkuCode()))) {
                    inventoryTakeStockOrderDto.setUnitName(((DgItemSkuDetailRespDto)itemSkuDgRespDtoMap.get(inventoryTakeStockOrderDto.getSkuCode())).getUnit());
                    inventoryTakeStockOrderDto.setSpecModel(((DgItemSkuDetailRespDto)itemSkuDgRespDtoMap.get(inventoryTakeStockOrderDto.getSkuCode())).getSpecModel());
                }
                if (Objects.nonNull(inventoryTakeStockOrderDto.getAccountNum())) {
                    accountNum = Objects.nonNull(accountNumMap.get(accountNumMapKey)) ? ((BigDecimal)accountNumMap.get(accountNumMapKey)).add(inventoryTakeStockOrderDto.getAccountNum()) : inventoryTakeStockOrderDto.getAccountNum();
                    accountNumMap.put(accountNumMapKey, accountNum);
                }
                BeanUtil.copyProperties((Object)inventoryTakeStockOrderDto, (Object)mappingVO, (String[])new String[0]);
                mappingVO.setFirmOfferNum((BigDecimal)Optional.ofNullable(mappingVO.getFirmOfferNum()).filter(r -> BigDecimalUtils.eqZero((BigDecimal)r) == false).orElse(null));
                inventoryListMappingVOS.add(mappingVO);
            }
            inventoryListMappingVOS = inventoryListMappingVOS.stream().sorted(Comparator.comparing(o -> o.getSkuCode() + o.getLogicWarehouseCode())).collect(Collectors.toList());
            for (InventoryListMappingVO inventoryListMappingVO : inventoryListMappingVOS) {
                String accountNumMapKey = inventoryListMappingVO.getSkuCode() + "_" + inventoryListMappingVO.getLogicWarehouseCode();
                BigDecimal decimal = (BigDecimal)accountNumMap.get(accountNumMapKey);
                if (Objects.nonNull(decimal)) {
                    decimal = this.getDecimal(decimal);
                    inventoryListMappingVO.setInventoryNum(decimal);
                    accountNumMap.remove(accountNumMapKey);
                } else {
                    inventoryListMappingVO.setInventoryNum(BigDecimal.ZERO);
                }
                inventoryListMappingVO.setAccountNum(this.getDecimal(inventoryListMappingVO.getAccountNum()));
                inventoryListMappingVO.setFirmOfferNum(this.getDecimal(inventoryListMappingVO.getFirmOfferNum()));
            }
            log.info("\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55\u6570:{}", (Object)inventoryListMappingVOS.size());
            if (this.enableBatch == null || this.enableBatch == YesNoEnum.NO.getValue()) {
                List noBatchResult = BeanUtil.copyToList(inventoryListMappingVOS, InventoryListMappingNoBatchVO.class);
                return noBatchResult;
            }
        }
        return inventoryListMappingVOS;
    }

    private BigDecimal getDecimal(BigDecimal decimal) {
        BigDecimal finalBigDecimal = null;
        if (Objects.nonNull(decimal)) {
            String regex = "\\.0+$";
            String result = decimal.stripTrailingZeros().toPlainString().replaceAll(regex, "");
            finalBigDecimal = new BigDecimal(result);
        }
        return finalBigDecimal;
    }

    public void initTemplateMap(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        DictDto dictDto = (DictDto)com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByGroupCodeAndCode("GLOBAL_SYSTEM_CONFIG", "GLOBAL_SYSTEM_CONFIG"));
        List dictValueList = dictDto.getDictValueList();
        Map<String, Integer> dictValueMap = dictValueList.stream().collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getStatus, (k1, k2) -> k1));
        this.enableBatch = dictValueMap.get(GlobalSystemConfigEnum.ENABLE_BATCH.getCode());
        FileModeTypeEnum fileModeTypeEnum = FileModeTypeEnum.INVENTORY_LIST_MAPPING;
        PoiFileModeMap.exportTemplateMap.remove((Object)fileModeTypeEnum.getKey());
        if (this.enableBatch == null || this.enableBatch == YesNoEnum.NO.getValue()) {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), InventoryListMappingNoBatchVO.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getName());
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getExportFunctionName());
        } else {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), InventoryListMappingVO.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getName());
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getExportFunctionName());
        }
    }
}

