/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.adjustbiz.ITransferAdjustOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.blakclistbiz.IWarehouseBlacklistApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgLogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.old.IItemDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.transferbiz.ITransferPlanOrderApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.constants.TransferAdjustBillsSourceEnum;
import com.yunxi.dg.base.ocs.mgmt.application.constants.TransferAdjustTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.adjustbiz.BatchCreateTransferAdjustDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.adjustbiz.CreateTransferAdjustDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.adjustbiz.TransferAdjustOrderDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.PageWarehouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.WareHouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.TransferPlanOrderDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.TransferPlanOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.TransferPlanOrderStatus;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.DgLogicWarehouseOrgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemDgDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemSkuQueryDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.TransferAdjustOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_transfer_adjust_order")
public class TransferAdjustOrderOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(TransferAdjustOrderOperationCommonServiceImpl.class);
    @Resource
    private ITransferAdjustOrderApiProxy iTransferAdjustOrderApiProxy;
    @Resource
    private ITransferPlanOrderApiProxy transferPlanOrderApiProxy;
    @Resource
    private IDgLogicWarehouseApiProxy iDgLogicWarehouseApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy iDgPhysicsWarehouseApiProxy;
    @Resource
    private IItemDgQueryApiProxy iItemDgQueryApiProxy;
    @Resource
    private IWarehouseBlacklistApiProxy warehouseBlacklistApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        HashMap<String, TransferAdjustOrderImportDto> repetitionMap = new HashMap<String, TransferAdjustOrderImportDto>();
        HashMap<String, List> mergeMap = new HashMap<String, List>();
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), TransferAdjustOrderImportDto.class);
        logger.info("\u8fdb\u5165\u8c03\u62e8\u8c03\u6574\u5355\u5bfc\u5165:{}", JSON.toJSON((Object)importDtoList));
        Map<String, List<DgPhysicsWarehouseDto>> physicsWarehouseDtoMap = this.mapDgPhysicsWarehouse();
        List<String> itemCodeList = importDtoList.stream().map(e -> e.getSkuCode()).collect(Collectors.toList());
        Map<String, ItemSkuDgRespDto> mapItemSkuDgResp = this.mapItemSkuDgResp(itemCodeList);
        Map<String, DgLogicWarehouseOrgRespDto> mapOrgInfo = this.mapOrgDtoInfo();
        Set<String> transferPlanOrderNoSet = importDtoList.stream().map(TransferAdjustOrderImportDto::getTransferPlanOrderNo).collect(Collectors.toSet());
        Map<String, TransferPlanOrderDto> planOrderMap = this.getTransferPlanOrderMap(transferPlanOrderNoSet);
        Map<Long, List<TransferPlanOrderDetailDto>> detailDtoMap = this.getPlanOrderDetailDtoMap(planOrderMap.values().stream().map(BaseDto::getId).collect(Collectors.toList()));
        for (TransferAdjustOrderImportDto importDto : importDtoList) {
            importDto.setCreatePerson(commonReqDto.getCreatePerson());
            this.verifyRepetitionPlanOrderInfo(repetitionMap, importDto, commonReqDto, respDto);
            this.verifyInventoryMsg(physicsWarehouseDtoMap, importDto, commonReqDto, respDto);
            this.verifyItemMsg(mapItemSkuDgResp, importDto, commonReqDto, respDto);
            this.verifyAdjustTypeMsg(importDto, commonReqDto, respDto);
            this.verifyOrg(mapOrgInfo, importDto, commonReqDto, respDto);
            this.verifyTransferPlan(planOrderMap, importDto, commonReqDto, respDto);
            this.verifyTransferPlanDetail(detailDtoMap, importDto, commonReqDto, respDto);
            if (!StrUtil.isBlank((CharSequence)importDto.getErrorMsg())) continue;
            List mergeAdjustOrders = mergeMap.getOrDefault(importDto.mergeUniqueKey(), new ArrayList());
            mergeAdjustOrders.add(importDto);
            mergeMap.put(importDto.mergeUniqueKey(), mergeAdjustOrders);
        }
        return mergeMap;
    }

    private Map<String, WareHouseBlacklistDto> mapWarehouseBlackExist(List<TransferAdjustOrderImportDto> importDtoList) {
        Set warehouseCodeSet = importDtoList.stream().filter(dto -> StringUtil.isNotBlank((CharSequence)dto.getPhysicsWarehouseCode())).map(TransferAdjustOrderImportDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        Set organizationCodeSet = importDtoList.stream().filter(dto -> StringUtil.isNotBlank((CharSequence)dto.getOrganizationCode())).map(TransferAdjustOrderImportDto::getOrganizationCode).collect(Collectors.toSet());
        if (warehouseCodeSet.isEmpty() || organizationCodeSet.isEmpty()) {
            return new HashMap<String, WareHouseBlacklistDto>();
        }
        PageWarehouseBlacklistDto queryDto = new PageWarehouseBlacklistDto();
        queryDto.setWarehouseCodes(new ArrayList(warehouseCodeSet));
        queryDto.setOrganizationCodeList(new ArrayList(organizationCodeSet));
        PageInfo wareHouseBlacklistDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseBlacklistApiProxy.pageinfo(queryDto));
        if (CollectionUtil.isEmpty((Collection)wareHouseBlacklistDtoPageInfo.getList())) {
            return new HashMap<String, WareHouseBlacklistDto>();
        }
        Map<String, WareHouseBlacklistDto> warehouseBlackListMap = wareHouseBlacklistDtoPageInfo.getList().stream().collect(Collectors.toMap(e -> e.getOrganizationCode() + "_" + e.getWarehouseCode(), Function.identity(), (k1, k2) -> k1));
        return warehouseBlackListMap;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map mergeMap = (Map)object;
        if (CollectionUtil.isEmpty((Map)mergeMap)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Map)mergeMap) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            this.insertTransferAdjustOrderBatch(mergeMap);
        }
        catch (Exception e) {
            logger.info("\u5bfc\u5165\u8c03\u62e8\u5355\u8ba1\u5212\u5931\u8d25:{}", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private void verifyItemMsg(Map<String, ItemSkuDgRespDto> mapItemSkuDgResp, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ItemSkuDgRespDto itemSkuDgRespDto = mapItemSkuDgResp.get(importDto.getSkuCode());
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        if (Objects.isNull(itemSkuDgRespDto)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        ItemDgDto itemDgDto = itemSkuDgRespDto.getItemDgDto();
        importDto.setItemName(itemDgDto.getName());
        importDto.setItemCode(itemDgDto.getCode());
        importDto.setSkuName(itemSkuDgRespDto.getName());
        importDto.setUnit(itemDgDto.getUnit());
    }

    private Map<String, TransferPlanOrderDto> getTransferPlanOrderMap(Set<String> transferPlanOrderNoSet) {
        List transferPlanOrderDtos = (List)RestResponseHelper.extractData((RestResponse)this.transferPlanOrderApiProxy.queryByNoList((List)Lists.newArrayList(transferPlanOrderNoSet)));
        return ((List)Optional.ofNullable(transferPlanOrderDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(TransferPlanOrderDto::getTransferPlanOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<Long, List<TransferPlanOrderDetailDto>> getPlanOrderDetailDtoMap(List<Long> transferPlanIdList) {
        if (CollectionUtil.isEmpty(transferPlanIdList)) {
            return Collections.emptyMap();
        }
        List planDetailList = (List)RestResponseHelper.extractData((RestResponse)this.transferPlanOrderApiProxy.queryDetailByIdList(transferPlanIdList));
        return ((List)Optional.ofNullable(planDetailList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(TransferPlanOrderDetailDto::getPlanTransferId));
    }

    private Map<String, DgLogicWarehouseOrgRespDto> mapOrgDtoInfo() {
        RestResponse response = this.iDgLogicWarehouseApiProxy.queryOrgList();
        Map<String, DgLogicWarehouseOrgRespDto> orgCheckMap = ((List)Optional.ofNullable(response.getData()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgLogicWarehouseOrgRespDto::getOrgCode, Function.identity(), (e1, e2) -> e2));
        return orgCheckMap;
    }

    private Map<String, ItemSkuDgRespDto> mapItemSkuDgResp(List<String> itemCodeList) {
        RestResponse response = this.iItemDgQueryApiProxy.querySkuList(ItemSkuQueryDgReqDto.builder().skuCodeList(itemCodeList).build());
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity()));
    }

    private Map<String, List<DgPhysicsWarehouseDto>> mapDgPhysicsWarehouse() {
        RestResponse response = this.iDgPhysicsWarehouseApiProxy.queryAll();
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgPhysicsWarehouseDto::getWarehouseCode));
    }

    private void verifyOrg(Map<String, DgLogicWarehouseOrgRespDto> orgCheckMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        DgLogicWarehouseOrgRespDto orgAdvRespDto = orgCheckMap.get(importDto.getOrganizationCode());
        if (Objects.isNull(orgAdvRespDto)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        importDto.setOrganizationCode(orgAdvRespDto.getOrgCode());
        importDto.setOrganizationName(orgAdvRespDto.getOrgName());
        importDto.setOrganizationId(orgAdvRespDto.getOrgId());
    }

    private void verifyWarehouseBlack(Map<String, WareHouseBlacklistDto> wareHouseBlacklistDtoMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        String warehouseBlackKey = importDto.getOrganizationCode() + "_" + importDto.getPhysicsWarehouseCode();
        if (wareHouseBlacklistDtoMap.containsKey(warehouseBlackKey)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5e93\u5b58\u7ec4\u7ec7+\u7269\u7406\u4ed3\u5b58\u5728\u8865\u8d27\u4ed3\u9ed1\u540d\u5355"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
    }

    private void verifyInventoryMsg(Map<String, List<DgPhysicsWarehouseDto>> checkWarehouseMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        List<DgPhysicsWarehouseDto> warehouseDtos = checkWarehouseMap.get(importDto.getPhysicsWarehouseCode());
        if (CollectionUtil.isEmpty(warehouseDtos)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        if (CollectionUtil.isNotEmpty(warehouseDtos) && warehouseDtos.size() > 1) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        importDto.setPhysicsWarehouseName(warehouseDtos.get(0).getWarehouseName());
    }

    private Boolean verifyAdjustTypeMsg(TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return false;
        }
        String adjustTypeName = importDto.getAdjustTypeName().trim();
        if (StringUtils.isEmpty((CharSequence)adjustTypeName)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u6574\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        TransferAdjustTypeEnum transferAdjustTypeEnum = TransferAdjustTypeEnum.forEnumName((String)adjustTypeName);
        if (null == transferAdjustTypeEnum) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u6574\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        importDto.setAdjustType(transferAdjustTypeEnum.getCode());
        String adjustQuantityStr = importDto.getAdjustQuantityStr().trim();
        if (StringUtils.isEmpty((CharSequence)adjustQuantityStr)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u6574\u6570\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        importDto.setAdjustQuantity(new BigDecimal(adjustQuantityStr));
        return true;
    }

    private void verifyTransferPlan(Map<String, TransferPlanOrderDto> transferPlanMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        TransferPlanOrderDto transferPlanOrderDto = transferPlanMap.get(importDto.getTransferPlanOrderNo());
        if (ObjectUtil.isNotNull((Object)transferPlanOrderDto)) {
            if (!transferPlanOrderDto.getStatus().equals(TransferPlanOrderStatus.UNDERWAY.getCode())) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8ba1\u5212\u5355\u53f7\u8fdb\u884c\u4e2d\u624d\u53ef\u8c03\u6574\uff0c\u8bf7\u68c0\u67e5"));
                respDto.getErrorDetails().add(importDto);
                return;
            }
            importDto.setTransferPlanId(transferPlanOrderDto.getId());
            importDto.setTransferPlanName(transferPlanOrderDto.getPlanName());
            importDto.setSupplyCycle(transferPlanOrderDto.getSupplyCycle());
            return;
        }
        importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8ba1\u5212\u5355\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        respDto.getErrorDetails().add(importDto);
    }

    private void verifyTransferPlanDetail(Map<Long, List<TransferPlanOrderDetailDto>> planOrderDetailDtoMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        BigDecimal quantity;
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        List<TransferPlanOrderDetailDto> transferPlanOrderDetailDtos = planOrderDetailDtoMap.get(importDto.getTransferPlanId());
        if (CollectionUtils.isEmpty(transferPlanOrderDetailDtos)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u62e8\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        String key = importDto.getSkuCode() + "_" + importDto.getPhysicsWarehouseCode() + "_" + importDto.getOrganizationCode();
        Map transferPlanDetailMap = transferPlanOrderDetailDtos.stream().collect(Collectors.toMap(dto -> dto.getSkuCode() + "_" + dto.getPhysicsWarehouseCode() + "_" + dto.getOrganizationCode(), Function.identity(), (k1, k2) -> k1));
        if (!transferPlanDetailMap.containsKey(key)) {
            if (importDto.getAdjustType().equals(TransferAdjustTypeEnum.REDUCE.getCode()) && importDto.getAdjustQuantity().compareTo(BigDecimal.ZERO) > 0) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "SKU+\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\u8c03\u62e8\u8ba1\u5212\u4e2d\uff0c\u8c03\u6574\u7684\u4e3a\u51cf\u5c11\uff0c\u5219\u8c03\u6570\u91cf\u5fc5\u987b\u662f0 "));
                respDto.getErrorDetails().add(importDto);
            }
            return;
        }
        TransferPlanOrderDetailDto transferPlanOrderDetailDto = (TransferPlanOrderDetailDto)transferPlanDetailMap.get(key);
        if (importDto.getAdjustType().equals(TransferAdjustTypeEnum.REDUCE.getCode()) && (quantity = transferPlanOrderDetailDto.getPlanQuantity()).compareTo(importDto.getAdjustQuantity()) < 0) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u6574\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u8c03\u62e8\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        importDto.setPlanDetailId(transferPlanOrderDetailDto.getId());
        importDto.setSkuName(transferPlanOrderDetailDto.getSkuName());
        importDto.setItemCode(transferPlanOrderDetailDto.getItemCode());
        importDto.setItemName(transferPlanOrderDetailDto.getItemName());
    }

    private void insertTransferAdjustOrderBatch(Map<String, List<TransferAdjustOrderImportDto>> mergeMap) {
        BatchCreateTransferAdjustDto adjustDto = new BatchCreateTransferAdjustDto();
        ArrayList<CreateTransferAdjustDto> list = new ArrayList<CreateTransferAdjustDto>();
        for (Map.Entry<String, List<TransferAdjustOrderImportDto>> entry : mergeMap.entrySet()) {
            TransferAdjustOrderImportDto firstImportDto = entry.getValue().get(0);
            CreateTransferAdjustDto createTransferAdjustDto = new CreateTransferAdjustDto();
            CubeBeanUtils.copyProperties((Object)createTransferAdjustDto, (Object)firstImportDto, (String[])new String[0]);
            createTransferAdjustDto.setUpdatePerson(createTransferAdjustDto.getCreatePerson());
            createTransferAdjustDto.setBillsSource(TransferAdjustBillsSourceEnum.IMPORT.getCode());
            createTransferAdjustDto.setTransferPlanName(firstImportDto.getTransferPlanName());
            ArrayList details = Lists.newArrayList();
            for (TransferAdjustOrderImportDto detail : entry.getValue()) {
                TransferAdjustOrderDetailDto adjustOrderDetailDto = new TransferAdjustOrderDetailDto();
                CubeBeanUtils.copyProperties((Object)adjustOrderDetailDto, (Object)detail, (String[])new String[0]);
                details.add(adjustOrderDetailDto);
            }
            createTransferAdjustDto.setDetails((List)details);
            list.add(createTransferAdjustDto);
        }
        adjustDto.setList(list);
        RestResponseHelper.extractData((RestResponse)this.iTransferAdjustOrderApiProxy.batchInsert(adjustDto));
    }

    private boolean verifyRepetitionPlanOrderInfo(Map<String, TransferAdjustOrderImportDto> repetitionMap, TransferAdjustOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return false;
        }
        TransferAdjustOrderImportDto repeatDto = repetitionMap.get(importDto.repetitionUniqueKey());
        if (Objects.nonNull(repeatDto)) {
            repeatDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", repeatDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u8ba1\u5212\u5355\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u8ba1\u5212\u5355\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            if (!respDto.getErrorDetails().contains(repeatDto)) {
                respDto.getErrorDetails().add(repeatDto);
            }
            return false;
        }
        repetitionMap.put(importDto.repetitionUniqueKey(), importDto);
        return true;
    }
}

