/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.operation;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.yunxi.dg.base.mgmt.excel.EasyPoiExportUtil;
import com.yunxi.dg.base.mgmt.excel.ExcelUtils;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ExportFileOperationCommonReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import java.io.InputStream;

public abstract class AbstractFileOperationCommonService {
    public ExcelImportResult<ImportBaseModeDto> parseExcelDataResult(ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ExcelImportResult<ImportBaseModeDto> result;
        EasyPoiExportUtil.checkFileInfo(commonReqDto.getUrl());
        InputStream inputStream = ExcelUtils.getInputStream(commonReqDto.getUrl());
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance((String)commonReqDto.getKey());
        Class<ImportBaseModeDto> importTemplate = anEnum.getImportTemplate();
        if (anEnum.getImportTemplate() == null) {
            importTemplate = EasyPoiExportUtil.getClassTemplate(anEnum.getKey());
        }
        if ((result = EasyPoiExportUtil.handlerExcelDataResult(anEnum.getImportTemplate(), commonReqDto.getUrl(), anEnum.getHeadRows())).isVerfiyFail()) {
            int index = anEnum.getHeadRows() > 0 ? 1 : 0;
            result.getFailList().forEach(l -> respDto.getErrorMsgs().add(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg())));
        }
        return result;
    }

    public abstract Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> var1, ImportFileOperationCommonReqDto var2, ImportFileOperationCommonRespDto var3);

    public abstract String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> var1, ImportFileOperationCommonReqDto var2, ImportFileOperationCommonRespDto var3, Object var4);

    public abstract String exportFileOperationCommon(ExportFileOperationCommonReqDto var1);

    public abstract Integer exportTotal(ExportFileOperationCommonReqDto var1);
}

