/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum MaterialTypeEnum {
    CARGO("cargo", "\u8d27\u7269"),
    EXPENSE("expense", "\u8d39\u7528");

    private String code;
    private String desc;

    private MaterialTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static MaterialTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.asList(MaterialTypeEnum.values()).stream().filter(e -> e.getCode().equals(code)).findAny().orElse(null);
    }

    public static MaterialTypeEnum getByDesc(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return null;
        }
        return Arrays.asList(MaterialTypeEnum.values()).stream().filter(e -> e.getDesc().equals(desc)).findAny().orElse(null);
    }

    public static List<String> getDescList() {
        ArrayList<String> descList = new ArrayList<String>();
        for (MaterialTypeEnum item : MaterialTypeEnum.values()) {
            descList.add(item.getDesc());
        }
        return descList;
    }
}

