/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceVerificationQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceVerificationRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillInfoApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IPushKeepAccountsApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementInvoiceVerificationService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceVerificationListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceVerificationVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinancialManagementInvoiceManagementInvoiceVerificationServiceImpl
implements FinancialManagementInvoiceManagementInvoiceVerificationService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementInvoiceVerificationServiceImpl.class);
    @Resource
    private IBillInfoApiProxy billInfoApi;
    @Resource
    private IPushKeepAccountsApiProxy pushKeepAccountsApiProxy;

    @Override
    public RestResponse<PageInfo<InvoiceVerificationVO>> getInvoiceVerificationPage(GetInvoiceVerificationListPageParams getInvoiceVerificationPageParams) {
        InvoiceVerificationQueryDto invoiceVerificationQueryDto = new InvoiceVerificationQueryDto();
        this.queryPageParam(invoiceVerificationQueryDto, getInvoiceVerificationPageParams);
        RestResponse pageInfoRestResponse = this.billInfoApi.queryVerificationByPage(invoiceVerificationQueryDto);
        logger.info("\u53d1\u7968\u4fe1\u606f\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)pageInfoRestResponse));
        PageInfo billInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billInfoRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billInfoRespDtoPageInfo.getList())) {
            new RestResponse();
        }
        List invoiceVerificationVOList = billInfoRespDtoPageInfo.getList().stream().map(billInfo -> {
            InvoiceVerificationVO invoiceVerificationVO = new InvoiceVerificationVO();
            this.getInvoiceResponseParams(invoiceVerificationVO, (InvoiceVerificationRespDto)billInfo);
            return invoiceVerificationVO;
        }).collect(Collectors.toList());
        pageInfo.setList(invoiceVerificationVOList);
        return new RestResponse((Object)pageInfo);
    }

    public void queryPageParam(InvoiceVerificationQueryDto invoiceVerificationQueryDto, GetInvoiceVerificationListPageParams getInvoiceVerificationListPageParams) {
        invoiceVerificationQueryDto.setInvoicingDateStart(getInvoiceVerificationListPageParams.getInvoicingDateStart());
        invoiceVerificationQueryDto.setInvoicingDateEnd(getInvoiceVerificationListPageParams.getInvoicingDateEnd());
        invoiceVerificationQueryDto.setPageNum(getInvoiceVerificationListPageParams.getPageNum());
        invoiceVerificationQueryDto.setPageSize(getInvoiceVerificationListPageParams.getPageSize());
        invoiceVerificationQueryDto.setPlatformOrderNo(getInvoiceVerificationListPageParams.getPlatformOrderNo());
        invoiceVerificationQueryDto.setDivergence(getInvoiceVerificationListPageParams.getDivergence());
    }

    public void getInvoiceResponseParams(InvoiceVerificationVO invoiceVerificationVO, InvoiceVerificationRespDto billInfoRespDto) {
        invoiceVerificationVO.setShopId(ParamConverter.convertToString((Object)billInfoRespDto.getShopId()));
        invoiceVerificationVO.setShopCode(billInfoRespDto.getShopCode());
        invoiceVerificationVO.setShopName(billInfoRespDto.getShopName());
        invoiceVerificationVO.setPlatformOrderNo(billInfoRespDto.getPlatformOrderNo());
        invoiceVerificationVO.setCustomerCode(billInfoRespDto.getCustomerCode());
        invoiceVerificationVO.setCustomerName(billInfoRespDto.getCustomerName());
        invoiceVerificationVO.setInvoiceEntityCode(billInfoRespDto.getInvoiceEntityCode());
        invoiceVerificationVO.setInvoiceEntityName(billInfoRespDto.getInvoiceEntityName());
        invoiceVerificationVO.setInvoiceEntityId(ParamConverter.convertToString((Object)billInfoRespDto.getInvoiceEntityId()));
        invoiceVerificationVO.setInvoiceEnterprise(billInfoRespDto.getInvoiceEnterprise());
        invoiceVerificationVO.setInvoiceAmount(billInfoRespDto.getInvoiceAmount());
        invoiceVerificationVO.setRealAmount(billInfoRespDto.getRealAmount());
        invoiceVerificationVO.setVarianceAmount(billInfoRespDto.getVarianceAmount());
    }
}

