/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.share.IDgVirtualInventoryApi;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryPageReqDto;
import com.yunxi.dg.base.center.share.api.entity.IBorrowGoodsOrderApi;
import com.yunxi.dg.base.center.share.dto.entity.BorrowGoodsOrderDto;
import com.yunxi.dg.base.center.share.dto.entity.BorrowGoodsOrderPageReqDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.mgmt.service.enums.ExportBorrowGoodsOrderEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportBorrowGoodsOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportBorrowGoodsOrderRespDto;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_borrow_goods_order")
public class BorrowGoodsOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(BorrowGoodsOrderCommonServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApi iItemSkuDgQueryApi;
    @Resource
    private IDgVirtualInventoryApi iDgVirtualInventoryApi;
    @Resource
    private IBorrowGoodsOrderApi iBorrowGoodsOrderApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        String supplyWarehouseCode;
        log.info("\u5f00\u59cb\u5bfc\u5165\u501f\u8d27\u5355");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        ArrayList<ImportBorrowGoodsOrderDto> passList = new ArrayList<ImportBorrowGoodsOrderDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportBorrowGoodsOrderDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u501f\u8d27\u5355,\u5bfc\u5165\u501f\u8d27\u5355\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        Map extFields = commonReqDto.getExtFields();
        AssertUtils.notNull(extFields.get("supplyWarehouseCode"), (String)"\u4f9b\u5e94\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            supplyWarehouseCode = (String)extFields.get("supplyWarehouseCode");
        }
        catch (Exception e) {
            throw new BizException("\u4f9b\u5e94\u4ed3\u7f16\u7801\u8f6c\u6362\u5f02\u5e38");
        }
        DgVirtualInventoryPageReqDto virtualInventoryPageReqDto = new DgVirtualInventoryPageReqDto();
        virtualInventoryPageReqDto.setWarehouseCode(supplyWarehouseCode);
        List dgVirtualInventoryDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgVirtualInventoryApi.queryList(virtualInventoryPageReqDto));
        if (CollectionUtil.isEmpty((Collection)dgVirtualInventoryDtos)) {
            return new ArrayList();
        }
        Map<String, BigDecimal> skuCodeAndAvailableList = dgVirtualInventoryDtos.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) && Objects.nonNull(dto.getAvailable())).collect(Collectors.toMap(DgVirtualInventoryDto::getSkuCode, DgVirtualInventoryDto::getAvailable));
        ArrayList<String> skuCodePassList = new ArrayList<String>();
        for (ImportBorrowGoodsOrderDto dto2 : resultList) {
            boolean isPass = this.paramVerify(dto2, skuCodePassList, skuCodeAndAvailableList);
            if (!isPass) {
                this.setErrorMsg(dto2, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto2.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto2.getErrorMsg()));
                respDto.getErrorDetails().add(dto2);
            }
            skuCodePassList.add(dto2.getSkuCode());
            passList.add(dto2);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u501f\u8d27\u5355\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.BORROW_GOODS_ORDER.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        BorrowGoodsOrderPageReqDto reqDto = new BorrowGoodsOrderPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (BorrowGoodsOrderPageReqDto)JSON.parseObject((String)filter, BorrowGoodsOrderPageReqDto.class);
        }
        List pageData = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iBorrowGoodsOrderApi.page(reqDto))).getList();
        ArrayList<ExportBorrowGoodsOrderRespDto> list = new ArrayList<ExportBorrowGoodsOrderRespDto>();
        Integer num = 1;
        for (BorrowGoodsOrderDto dto : pageData) {
            ExportBorrowGoodsOrderRespDto exportBorrowGoodsOrderRespDto = (ExportBorrowGoodsOrderRespDto)BeanUtil.copyProperties((Object)dto, ExportBorrowGoodsOrderRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportBorrowGoodsOrderRespDto.setNumber(n);
            if (Objects.nonNull(dto.getOrderSource())) {
                exportBorrowGoodsOrderRespDto.setOrderSource(ExportBorrowGoodsOrderEnum.getInstance(dto.getOrderSource().toString()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOrderStatus())) {
                exportBorrowGoodsOrderRespDto.setOrderStatus(ExportBorrowGoodsOrderEnum.getInstance(dto.getOrderStatus()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOaStatus())) {
                exportBorrowGoodsOrderRespDto.setOaStatus(ExportBorrowGoodsOrderEnum.getInstance(dto.getOaStatus()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getBusinessType())) {
                exportBorrowGoodsOrderRespDto.setBusinessType(ExportBorrowGoodsOrderEnum.getInstance(dto.getBusinessType()).getDesc());
            }
            exportBorrowGoodsOrderRespDto.setTotalQuantity(Integer.valueOf(dto.getTotalQuantity().intValue()));
            exportBorrowGoodsOrderRespDto.setCreateTime(DateUtil.formatDateTime((Date)dto.getCreateTime()));
            list.add(exportBorrowGoodsOrderRespDto);
        }
        log.info("\u501f\u8d27\u5355\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private boolean paramVerify(ImportBorrowGoodsOrderDto dto, List<String> skuCodePassList, Map<String, BigDecimal> skuCodeAndAvailableList) {
        if (CollectionUtil.isNotEmpty(skuCodePassList) && skuCodePassList.contains(dto.getSkuCode())) {
            dto.setErrorMsg("sku\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        List list = (List)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApi.queryBySkuCode((List)ListUtil.toList((Object[])new String[]{dto.getSkuCode()})));
        if (CollectionUtil.isEmpty((Collection)list)) {
            dto.setErrorMsg("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
            return false;
        }
        if (CollectionUtil.isNotEmpty(skuCodeAndAvailableList) && !skuCodeAndAvailableList.containsKey(dto.getSkuCode())) {
            dto.setErrorMsg("\u5546\u54c1\u6570\u636e\u4e0d\u5728\u8be5\u4ed3\u5e93");
            return false;
        }
        if (Objects.nonNull(skuCodeAndAvailableList.get(dto.getSkuCode())) && dto.getQuantity().compareTo(skuCodeAndAvailableList.get(dto.getSkuCode())) > 0) {
            dto.setErrorMsg("\u501f\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u7528\u6570\u91cf");
            return false;
        }
        return true;
    }

    private String setErrorMsg(ImportBorrowGoodsOrderDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }

    public void initTemplateMap(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        String filter = exportQueryParamsReqDto.getFilter();
        BorrowGoodsOrderPageReqDto reqDto = new BorrowGoodsOrderPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (BorrowGoodsOrderPageReqDto)JSON.parseObject((String)filter, BorrowGoodsOrderPageReqDto.class);
        }
        FileModeTypeEnum fileModeTypeEnum = FileModeTypeEnum.BORROW_GOODS_ORDER;
        PoiFileModeMap.exportTemplateMap.remove((Object)fileModeTypeEnum.getKey());
        if (reqDto != null && reqDto.getOrderType() == 2) {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), ExportBorrowGoodsOrderRespDto.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)"\u5728\u5236\u501f\u8d27\u5355");
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)"\u5728\u5236\u501f\u8d27\u5355\u5bfc\u51fa");
        } else {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), ExportBorrowGoodsOrderRespDto.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getName());
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getExportFunctionName());
        }
    }
}

