/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehousePageReqDto;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgChannelWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.enums.ChannelWarehouseStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportChannelWarehouseModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_channel_warehouse_import")
public class ChannelWarehouseCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ChannelWarehouseCommonServiceImpl.class);
    @Resource
    private IDgChannelWarehouseApiProxy channelWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u6e20\u9053\u4ed3\u6863\u6848");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportChannelWarehouseModeDto> passList = new ArrayList<ImportChannelWarehouseModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportChannelWarehouseModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u6e20\u9053\u4ed3\u6863\u6848,\u5bfc\u5165\u6e20\u9053\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List channelWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.channelWarehouseApiProxy.list(new DgChannelWarehousePageReqDto()))).orElse(new ArrayList());
        List<String> warehouseCodeList = channelWarehouseDtos.stream().map(DgChannelWarehouseDto::getWarehouseCode).collect(Collectors.toList());
        List<String> warehouseNameList = channelWarehouseDtos.stream().map(DgChannelWarehouseDto::getWarehouseName).collect(Collectors.toList());
        for (ImportChannelWarehouseModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, warehouseCodeList, warehouseNameList);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u6e20\u9053\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List channelWarehouseDtos = BeanUtil.copyToList((Collection)passList, DgChannelWarehouseDto.class);
        this.channelWarehouseApiProxy.batchInsert(channelWarehouseDtos);
    }

    private boolean paramVerify(ImportChannelWarehouseModeDto dto, List<String> warehouseCodeList, List<String> warehouseNameList) {
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u6e20\u9053\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtil.isNotEmpty(warehouseNameList) && warehouseNameList.contains(dto.getWarehouseName())) {
            this.setErrorMsg(dto, dto.getWarehouseName() + "\u6e20\u9053\u4ed3\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseCode())) {
            this.setErrorMsg(dto, "\u9009\u9879\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtil.isNotEmpty(warehouseCodeList) && warehouseCodeList.contains(dto.getWarehouseCode())) {
            this.setErrorMsg(dto, dto.getWarehouseCode() + "\u6e20\u9053\u4ed3\u7f16\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (!dto.getWarehouseCode().matches("^[a-zA-Z0-9\\\\p{Punct}]+$")) {
            this.setErrorMsg(dto, "\u6e20\u9053\u4ed3\u7f16\u7801\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u5b57\u6bcd\u3001\u6807\u70b9\u7b26\u53f7\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        dto.setWarehouseStatus(ChannelWarehouseStatusEnum.ENABLE.getCode());
        return true;
    }

    private String setErrorMsg(ImportChannelWarehouseModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

