/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import com.wh.center.data.api.dto.request.MatchByNameOrAliasReqDto;
import com.wh.center.data.api.dto.response.AreaMatchRespDto;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import com.yundt.boot.center.data.dto.response.AreaTreeRespExtDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.openapi.dto.txt.TxtAdderssRespDto;
import com.yunxi.dg.base.center.openapi.dto.txt.TxtAdderssResqDto;
import com.yunxi.dg.base.center.openapi.proxy.txt.ITxtResolutionApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.proxy.order.IPerformOrderQueryApiProxy;
import com.yunxi.dg.base.center.trade.proxy.statemachine.IDgB2CSaleStatemachineApiProxy;
import com.yunxi.dg.base.commons.rpc.data.limit.customer.api.tob.query.IDgEmployeeManageShopQueryAuthApi;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.impl.PerformOrderOperationCommonServiceImpl;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.OpenAutoStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportPerformOrderReissueGiftDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportPerformOrderReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_reissue_gift")
public class PerformOrderReissueGiftOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(PerformOrderReissueGiftOperationCommonServiceImpl.class);
    @Autowired
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Autowired
    private IDgB2CSaleStatemachineApiProxy b2CSaleStatemachineApiProxy;
    @Autowired
    private IPerformOrderQueryApiProxy performOrderQueryApiProxy;
    @Resource
    private IDgEmployeeManageShopQueryAuthApi iDgEmployeeManageShopQueryAuthApi;
    @Resource
    private ITxtResolutionApiProxy txtResolutionApiProxy;
    @Autowired
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    private static final String ORDER_TYPE = "replenish_order";
    private static final List<String> MATCH_ORDER_TYPE = Arrays.asList("common_order", "pre_sale_order");

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5bfc\u5165\u8865\u53d1\u8d60\u54c1\u5355\uff0c\u6821\u9a8c\u5355\u636e\u6570\u636e");
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), ImportPerformOrderReissueGiftDto.class);
        Set skuCodes = importDtoList.stream().map(ImportPerformOrderReissueGiftDto::getSkuCode).collect(Collectors.toSet());
        Set platformOrderNos = importDtoList.stream().map(ImportPerformOrderReissueGiftDto::getPlatformOrderNo).collect(Collectors.toSet());
        Map<String, DgPerformOrderRespDto> platformOrderNoMap = this.getPlatformOrderNoMap(ListUtil.toList(platformOrderNos));
        Map<String, DgPerformOrderRespDto> distributionOrderNoMap = this.getDistributionOrderNoMap(ListUtil.toList(platformOrderNos));
        Map<String, DgItemSkuPageRespDto> itemSku = this.getItemSku(ListUtil.toList(skuCodes));
        HashMap rowDepulication = new HashMap(importDtoList.size());
        List shopCodesByEmployee = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgEmployeeManageShopQueryAuthApi.queryListShopCodesByEmployeeOrUserByUserId())).orElse(Lists.newArrayList());
        HashMap<Object, DgBizPerformOrderRespDto> orderAdderssMap = new HashMap<Object, DgBizPerformOrderRespDto>(platformOrderNos.size());
        for (ImportPerformOrderReissueGiftDto dto2 : importDtoList) {
            Object platformOrderNo;
            DgPerformOrderRespDto dgPerformOrderRespDto;
            if (!OpenAutoStatusEnum.TRUE.equalsStatus(dto2.getSourceAddress()) || Objects.isNull(dgPerformOrderRespDto = platformOrderNoMap.get(platformOrderNo = dto2.getPlatformOrderNo()))) continue;
            DgBizPerformOrderRespDto performOrderRespDto = (DgBizPerformOrderRespDto)orderAdderssMap.get(platformOrderNo);
            if (Objects.isNull(performOrderRespDto) && Objects.nonNull(performOrderRespDto = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(dgPerformOrderRespDto.getSaleOrderNo())))) {
                orderAdderssMap.put(platformOrderNo, performOrderRespDto);
            }
            if (Objects.isNull(performOrderRespDto) || Objects.isNull(performOrderRespDto.getOrderAddrRespDto())) {
                this.setErrorMsg(dto2, String.format("\u5e73\u53f0\u8ba2\u5355\u5bf9\u5e94\u9500\u552e\u5355%s\u4fe1\u606f\u4e0d\u5b58\u5728", dgPerformOrderRespDto.getSaleOrderNo()));
                orderAdderssMap.put(platformOrderNo, new DgBizPerformOrderRespDto());
                continue;
            }
            DgPerformOrderAddrRespDto orderAddrRespDto = performOrderRespDto.getOrderAddrRespDto();
            dto2.setProvince(orderAddrRespDto.getProvince());
            dto2.setCity(orderAddrRespDto.getCity());
            dto2.setCounty(orderAddrRespDto.getCounty());
            dto2.setDistrict(orderAddrRespDto.getStreet());
            dto2.setReceiveName(orderAddrRespDto.getReceiveName());
            dto2.setReceivePhone(orderAddrRespDto.getReceivePhone());
            dto2.setReceiveAddress(orderAddrRespDto.getReceiveAddress());
            dto2.setOaid(orderAddrRespDto.getOaid());
            dto2.setOriginalSaleOrderNo(performOrderRespDto.getSaleOrderNo());
        }
        HashMap<String, TxtAdderssRespDto> adderssMap = new HashMap<String, TxtAdderssRespDto>(platformOrderNos.size());
        ArrayList<AreaNameReqDto> provinces = new ArrayList<AreaNameReqDto>();
        for (ImportPerformOrderReissueGiftDto dto3 : importDtoList) {
            AreaNameReqDto provinceDto = this.addAreaNameReq(provinces, 0, dto3.getProvince());
            AreaNameReqDto city = this.addAreaNameReq(provinceDto.getChildren(), 1, dto3.getCity());
            this.addAreaNameReq(city.getChildren(), 2, dto3.getCounty());
            String province = dto3.getProvince();
            String receivePhone = dto3.getReceivePhone();
            if (!StrUtil.hasBlank((CharSequence[])new CharSequence[]{province, receivePhone})) continue;
            String receiveAddress = dto3.getReceiveAddress();
            String platformOrderNo = dto3.getPlatformOrderNo();
            this.addressResolution(adderssMap, platformOrderNo, receiveAddress);
            TxtAdderssRespDto txtAdderssRespDto = (TxtAdderssRespDto)adderssMap.get(platformOrderNo);
            if (Objects.isNull(txtAdderssRespDto)) {
                this.setErrorMsg(dto3, "\u6536\u8d27\u5730\u5740\u65e0\u6cd5\u89e3\u6790");
                continue;
            }
            dto3.setProvince(txtAdderssRespDto.getProvince());
            dto3.setCity(txtAdderssRespDto.getCity());
            dto3.setCounty(txtAdderssRespDto.getCounty());
            dto3.setDistrict(txtAdderssRespDto.getTown());
            dto3.setReceiveName(StrUtil.blankToDefault((CharSequence)txtAdderssRespDto.getPerson(), (String)dto3.getReceiveName()));
            dto3.setReceivePhone(StrUtil.blankToDefault((CharSequence)txtAdderssRespDto.getPhone(), (String)dto3.getReceivePhone()));
            dto3.setReceiveAddress(StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{txtAdderssRespDto.getTown(), txtAdderssRespDto.getDetail()}));
            provinceDto = this.addAreaNameReq(provinces, 0, dto3.getProvince());
            city = this.addAreaNameReq(provinceDto.getChildren(), 1, dto3.getCity());
            this.addAreaNameReq(city.getChildren(), 2, dto3.getCounty());
        }
        AreaMatchRespDto areaMatch = this.processAreaNameCodeMap(provinces);
        ArrayList passList = new ArrayList(result.getList().size());
        importDtoList.forEach(dto -> {
            DgItemSkuPageRespDto dgItemSkuPageRespDto;
            boolean isNotSourceAddress = !OpenAutoStatusEnum.TRUE.equalsStatus(dto.getSourceAddress());
            AreaNodeDto province = areaMatch.matchAndSet(null, 0, () -> ((ImportPerformOrderReissueGiftDto)dto).getProvince(), arg_0 -> ((ImportPerformOrderReissueGiftDto)dto).setProvince(arg_0));
            if ((province == null || StringUtils.isBlank((CharSequence)province.getCode())) && isNotSourceAddress) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u7701\u4e0d\u5b58\u5728");
            }
            AreaNodeDto city = areaMatch.matchAndSet(province, 1, () -> ((ImportPerformOrderReissueGiftDto)dto).getCity(), arg_0 -> ((ImportPerformOrderReissueGiftDto)dto).setCity(arg_0));
            if ((city == null || StringUtils.isBlank((CharSequence)city.getCode())) && isNotSourceAddress) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u5e02\u4e0d\u5b58\u5728");
            }
            AreaNodeDto county = areaMatch.matchAndSet(city, 2, () -> ((ImportPerformOrderReissueGiftDto)dto).getCounty(), arg_0 -> ((ImportPerformOrderReissueGiftDto)dto).setCounty(arg_0));
            if ((county == null || StringUtils.isBlank((CharSequence)county.getCode())) && isNotSourceAddress) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u533a\u4e0d\u5b58\u5728");
            }
            if (StrUtil.isBlank((CharSequence)dto.getReceivePhone())) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u6536\u8d27\u7535\u8bdd\u4e0d\u5b58\u5728");
            }
            if (StrUtil.isBlank((CharSequence)dto.getReceiveName())) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u6536\u8d27\u4eba\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(dgItemSkuPageRespDto = (DgItemSkuPageRespDto)itemSku.get(dto.getSkuCode()))) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u5546\u54c1\u4e0d\u5b58\u5728");
            } else if (!Objects.equals(1, dgItemSkuPageRespDto.getIsGift())) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u5546\u54c1\u4e0d\u662f\u8d60\u54c1");
            }
            DgPerformOrderRespDto dgPerformOrderRespDto = (DgPerformOrderRespDto)platformOrderNoMap.get(dto.getPlatformOrderNo());
            if (Objects.isNull(dgPerformOrderRespDto) && Objects.isNull(dgPerformOrderRespDto = (DgPerformOrderRespDto)distributionOrderNoMap.get(dto.getPlatformOrderNo()))) {
                this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, "\u5e73\u53f0\u8ba2\u5355\u539f\u5355\u4e0d\u5b58\u5728");
            }
            if (dgPerformOrderRespDto != null) {
                dto.setDistributionOrderNo(dgPerformOrderRespDto.getDistributionOrderNo());
                dto.setPlatformOrderNo(dgPerformOrderRespDto.getPlatformOrderNo());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getPlatformOrderNo()) && StringUtils.isNotBlank((CharSequence)dto.getSkuCode())) {
                String key = dto.getPlatformOrderNo() + ":" + dto.getSkuCode();
                Integer row = (Integer)rowDepulication.get(key);
                if (Objects.nonNull(row)) {
                    this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, String.format("\uff08\u5355\u53f7+sku\uff09\u4e0e\u7b2c%s\u884c\u91cd\u590d", row));
                } else {
                    rowDepulication.put(key, dto.getRowNum());
                }
            }
            if (StringUtils.isBlank((CharSequence)dto.getErrorMsg())) {
                dto.setDgOrderType(ORDER_TYPE);
                dto.setDgBizType("1001");
                DgBizPerformOrderRespDto dgBizPerformOrderRespDto = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(dgPerformOrderRespDto.getSaleOrderNo()));
                if (Objects.nonNull(dgBizPerformOrderRespDto.getPerformOrderSnapshotDto())) {
                    DgPerformOrderSnapshotDto performOrderSnapshotDto = dgBizPerformOrderRespDto.getPerformOrderSnapshotDto();
                    dto.setChannelId(performOrderSnapshotDto.getChannelId());
                    dto.setChannelCode(performOrderSnapshotDto.getChannelCode());
                    dto.setChannelName(performOrderSnapshotDto.getChannelName());
                    dto.setHsCustomerCode(performOrderSnapshotDto.getCustomerCode());
                    dto.setHsCustomerName(performOrderSnapshotDto.getCustomerName());
                    dto.setHsCustomerId(performOrderSnapshotDto.getCustomerId());
                    dto.setDgShopCode(performOrderSnapshotDto.getShopCode());
                    dto.setDgShopName(performOrderSnapshotDto.getShopName());
                    dto.setShopId(performOrderSnapshotDto.getShopId());
                    dto.setSiteId(performOrderSnapshotDto.getSiteId());
                    dto.setSiteCode(performOrderSnapshotDto.getSiteCode());
                    dto.setSiteName(performOrderSnapshotDto.getSiteName());
                    if (this.shopEmployee(shopCodesByEmployee) && !shopCodesByEmployee.contains(dto.getDgShopCode())) {
                        this.setErrorMsg((ImportPerformOrderReissueGiftDto)dto, String.format("\u7ba1\u8f96\u5e97\u94fa\u672a\u5339\u914d\u5230 %s %s ", dto.getDgShopCode(), dto.getDgShopName()));
                    }
                }
                dto.setProvinceCode(province == null ? null : province.getCode());
                dto.setCityCode(city == null ? null : city.getCode());
                dto.setCountyCode(county == null ? null : county.getCode());
                ImportPerformOrderReqDto.DgPerformOrderItemReqDto itemDto = PerformOrderReissueGiftOperationCommonServiceImpl.getDgPerformOrderItemReqDto(dto, dgItemSkuPageRespDto);
                dto.setItemDto(itemDto);
                if (StringUtils.isBlank((CharSequence)dto.getErrorMsg())) {
                    passList.add(dto);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getErrorMsg())) {
                respDto.getErrorDetails().add(dto);
            }
        });
        log.info("\u5bfc\u5165\u8865\u53d1\u8d60\u54c1\u5355\uff0c\u6821\u9a8c\u5355\u636e\u6570\u636e\uff0cpassList :{}", (Object)passList.size());
        return passList;
    }

    private Map<String, DgPerformOrderRespDto> getDistributionOrderNoMap(List<String> distributionOrderNos) {
        List dgPerformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryOrderByDistributionOrderNos(distributionOrderNos));
        if (Objects.isNull(dgPerformOrderRespDtos) || CollectionUtil.isEmpty((Collection)dgPerformOrderRespDtos)) {
            return MapUtil.empty();
        }
        return dgPerformOrderRespDtos.stream().collect(Collectors.toMap(DgPerformOrderInfoDto::getDistributionOrderNo, Function.identity(), (v1, v2) -> v2));
    }

    private AreaMatchRespDto processAreaNameCodeMap(List<AreaNameReqDto> provinces) {
        MatchByNameOrAliasReqDto req = new MatchByNameOrAliasReqDto();
        req.setProvinces(provinces);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u53c2\u6570\uff1a{}", JSON.toJSON((Object)req));
        RestResponse resp = this.areaExtQueryApiProxy.matchByNameOrAlias(req);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)resp));
        AreaMatchRespDto areaMatch = (AreaMatchRespDto)RestResponseHelper.extractData((RestResponse)resp);
        areaMatch.process();
        return areaMatch;
    }

    private AreaNameReqDto addAreaNameReq(List<AreaNameReqDto> list, int levelId, String name) {
        String finalName = Optional.ofNullable(name).orElse("");
        AreaNameReqDto req = list.stream().filter(s -> s.getLevelId().equals(levelId) && finalName.equals(s.getName())).findFirst().orElse(null);
        if (req != null) {
            return req;
        }
        req = new AreaNameReqDto();
        req.setLevelId(Integer.valueOf(levelId));
        req.setName(finalName);
        req.setChildren(new ArrayList());
        list.add(req);
        return req;
    }

    private Map<String, DgPerformOrderRespDto> getPlatformOrderNoMap(List<String> platformOrderNos) {
        List dgPerformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryOrderByPlatformOrderNo(platformOrderNos));
        if (Objects.isNull(dgPerformOrderRespDtos) || CollectionUtil.isEmpty((Collection)dgPerformOrderRespDtos)) {
            return MapUtil.empty();
        }
        return dgPerformOrderRespDtos.stream().collect(Collectors.toMap(DgPerformOrderInfoDto::getPlatformOrderNo, Function.identity(), (v1, v2) -> v2));
    }

    @NotNull
    private static ImportPerformOrderReqDto.DgPerformOrderItemReqDto getDgPerformOrderItemReqDto(ImportPerformOrderReissueGiftDto dto, DgItemSkuPageRespDto dgItemSkuPageRespDto) {
        ImportPerformOrderReqDto.DgPerformOrderItemReqDto itemDto = new ImportPerformOrderReqDto.DgPerformOrderItemReqDto();
        itemDto.setImgUrl(CollectionUtil.isEmpty((Collection)dgItemSkuPageRespDto.getImgUrlList()) ? "" : ((ItemMediasDgRespDto)dgItemSkuPageRespDto.getImgUrlList().get(0)).getPath1());
        itemDto.setItemBackCategoryOneCode(dgItemSkuPageRespDto.getDirCode());
        itemDto.setItemBackCategoryOneName(dgItemSkuPageRespDto.getDirName());
        itemDto.setItemCode(dgItemSkuPageRespDto.getItemCode());
        itemDto.setItemName(dgItemSkuPageRespDto.getItemName());
        itemDto.setItemId(dgItemSkuPageRespDto.getItemId());
        itemDto.setItemNum(new BigDecimal(dto.getSkuNum()));
        itemDto.setPayAmount(itemDto.getPayAmount());
        itemDto.setRealPayAmount(itemDto.getPayAmount());
        itemDto.setSalePrice(dgItemSkuPageRespDto.getSalePrice());
        itemDto.setDiscountAmount(BigDecimalUtils.multiply((BigDecimal)itemDto.getItemNum(), (BigDecimal)itemDto.getSalePrice()));
        itemDto.setPrice(itemDto.getSalePrice());
        itemDto.setSkuId(dgItemSkuPageRespDto.getId());
        itemDto.setSkuCode(dgItemSkuPageRespDto.getSkuCode());
        itemDto.setSkuName(dgItemSkuPageRespDto.getSkuName());
        itemDto.setType("1");
        itemDto.setGiftType(Integer.valueOf(3));
        itemDto.setGift(Integer.valueOf(1));
        return itemDto;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5bfc\u5165\u8865\u53d1\u8d60\u54c1\u5355\uff0ccallBackImportFileOperationCommonSync");
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u5bfc\u5165\u8865\u53d1\u8d60\u54c1\u5355:{}", (Object)JSON.toJSONString((Object)passList));
        Map<String, List<ImportPerformOrderReissueGiftDto>> giftMap = passList.stream().collect(Collectors.groupingBy(ImportPerformOrderReissueGiftDto::getPlatformOrderNo));
        giftMap.forEach((k, v) -> {
            ImportPerformOrderReissueGiftDto dto = (ImportPerformOrderReissueGiftDto)v.get(0);
            DgBizPerformOrderReqDto reqDto = this.assembleOrder(dto.getPlatformOrderNo(), dto);
            List<DgPerformOrderItemReqDto> giftList = PerformOrderReissueGiftOperationCommonServiceImpl.getItemList(v);
            reqDto.setGiftList(giftList);
            this.saveOrder(respDto, reqDto, dto);
            v.forEach(giftDto -> giftDto.setErrorMsg(dto.getErrorMsg()));
        });
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (!respDto.getErrorDetails().isEmpty()) {
            Object o = ServiceContext.getContext().get("INVOICE_ORDER");
            respDto.setStatus(Objects.isNull(o) ? FileOperationStatusEnum.IMPORT_ERROR.getCode() : FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
    }

    private static List<DgPerformOrderItemReqDto> getItemList(List<ImportPerformOrderReissueGiftDto> importdtos) {
        ArrayList<DgPerformOrderItemReqDto> itemList = new ArrayList<DgPerformOrderItemReqDto>(importdtos.size());
        importdtos.forEach(dto -> {
            ImportPerformOrderReqDto.DgPerformOrderItemReqDto item = dto.getItemDto();
            DgPerformOrderItemReqDto itemReqDto = new DgPerformOrderItemReqDto();
            itemReqDto.setDiscountAmount(item.getDiscountAmount());
            itemReqDto.setImgUrl(item.getImgUrl());
            itemReqDto.setItemBackCategoryOneCode(item.getItemBackCategoryOneCode());
            itemReqDto.setItemBackCategoryOneName(item.getItemBackCategoryOneName());
            itemReqDto.setItemCode(item.getItemCode());
            itemReqDto.setItemId(item.getItemId());
            itemReqDto.setItemName(item.getItemName());
            itemReqDto.setItemNum(item.getItemNum());
            itemReqDto.setPayAmount(item.getPayAmount());
            itemReqDto.setPrice(item.getPrice());
            itemReqDto.setRealPayAmount(item.getRealPayAmount());
            itemReqDto.setSalePrice(item.getSalePrice());
            itemReqDto.setSkuCode(item.getSkuCode());
            itemReqDto.setSkuName(item.getSkuName());
            itemReqDto.setSkuId(item.getSkuId());
            itemReqDto.setType(item.getType());
            itemReqDto.setGift(item.getGift());
            itemReqDto.setGiftType(item.getGiftType());
            DgPerformOrderItemExtensionDto performOrderItemExtensionDto = new DgPerformOrderItemExtensionDto();
            if (StringUtils.isNotBlank((CharSequence)dto.getHsCustomerCode())) {
                performOrderItemExtensionDto.setHsCustomerCode(dto.getHsCustomerCode());
                performOrderItemExtensionDto.setHsCustomerName(dto.getHsCustomerName());
            }
            itemReqDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
            itemList.add(itemReqDto);
        });
        return itemList;
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizPerformOrderReqDto reqDto, ImportPerformOrderReissueGiftDto dto) {
        try {
            reqDto.setOrderSource(Integer.valueOf(5));
            log.info("createSaleOrder\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.b2CSaleStatemachineApiProxy.createSaleOrder("INVOICE_ORDER", reqDto));
            ServiceContext.getContext().set("INVOICE_ORDER", (Object)"1");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u8865\u53d1\u8d60\u54c1\u5355\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    private DgBizPerformOrderReqDto assembleOrder(String plateformOrderNo, ImportPerformOrderReissueGiftDto dto) {
        DgBizPerformOrderReqDto reqDto = new DgBizPerformOrderReqDto();
        reqDto.setPlatformOrderNo(plateformOrderNo);
        reqDto.setDistributionOrderNo(dto.getDistributionOrderNo());
        reqDto.setOrderType(dto.getDgOrderType());
        reqDto.setBizType(dto.getDgBizType());
        reqDto.setDeliveryLogicalWarehouseCode(dto.getDeliveryLogicalWarehouseCode());
        reqDto.setLogicalWarehouseCode(dto.getLogicalWarehouseCode());
        reqDto.setLogicalWarehouseName(dto.getLogicalWarehouseName());
        reqDto.setLogicalWarehouseId(dto.getLogicalWarehouseId());
        reqDto.setShipmentEnterpriseCode(dto.getShipmentEnterpriseCode());
        reqDto.setShipmentEnterpriseName(dto.getShipmentEnterpriseName());
        reqDto.setShipmentEnterpriseId(dto.getShipmentEnterpriseId());
        reqDto.setRemark(dto.getRemark());
        reqDto.setBizModel("INVOICE_ORDER");
        reqDto.setIsManualCreate(Boolean.valueOf(true));
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setOrderSourceModel("INNER");
        reqDto.setOriginalSaleOrderNo(dto.getOriginalSaleOrderNo());
        DgPerformOrderAddrReqDto orderAddrReqDto = new DgPerformOrderAddrReqDto();
        orderAddrReqDto.setCity(dto.getCity());
        orderAddrReqDto.setCityCode(dto.getCityCode());
        orderAddrReqDto.setProvince(dto.getProvince());
        orderAddrReqDto.setProvinceCode(dto.getProvinceCode());
        orderAddrReqDto.setCounty(dto.getCounty());
        orderAddrReqDto.setCountyCode(dto.getCountyCode());
        orderAddrReqDto.setReceiveName(dto.getReceiveName());
        orderAddrReqDto.setReceivePhone(dto.getReceivePhone());
        orderAddrReqDto.setReceiveAddress(StringUtils.isNotBlank((CharSequence)dto.getDistrict()) ? dto.getDistrict() + dto.getReceiveAddress() : dto.getReceiveAddress());
        orderAddrReqDto.setOaid(dto.getOaid());
        reqDto.setOrderAddrReqDto(orderAddrReqDto);
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        performOrderPaymentDto.setPayTime(new Date());
        reqDto.setPerformOrderPaymentDto(performOrderPaymentDto);
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        BeanUtil.copyProperties((Object)dto, (Object)performOrderSnapshotDto, (String[])new String[0]);
        performOrderSnapshotDto.setShopId(dto.getShopId());
        performOrderSnapshotDto.setShopCode(dto.getDgShopCode());
        performOrderSnapshotDto.setShopName(dto.getDgShopName());
        performOrderSnapshotDto.setSiteId(dto.getSiteId());
        performOrderSnapshotDto.setSiteCode(dto.getSiteCode());
        performOrderSnapshotDto.setSiteName(dto.getSiteName());
        reqDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        return reqDto;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private void setErrorMsg(ImportPerformOrderReissueGiftDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }

    private void addressResolution(Map<String, TxtAdderssRespDto> adderssMap, String platformOrderNo, String address) {
        if (adderssMap.containsKey(platformOrderNo)) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)address)) {
            return;
        }
        try {
            TxtAdderssResqDto resqDto = new TxtAdderssResqDto();
            resqDto.setAddress(address);
            TxtAdderssRespDto txtAdderssRespDto = (TxtAdderssRespDto)RestResponseHelper.extractData((RestResponse)this.txtResolutionApiProxy.addressResolution(resqDto));
            if (Objects.isNull(txtAdderssRespDto) || StrUtil.isBlank((CharSequence)txtAdderssRespDto.getProvince())) {
                return;
            }
            adderssMap.put(platformOrderNo, txtAdderssRespDto);
        }
        catch (Exception e) {
            log.error("\u5730\u5740\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    private Map<String, DgItemSkuPageRespDto> getItemSku(List<String> skuCodes) {
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSubStatus(Integer.valueOf(1));
        reqDto.setSkuCodes(skuCodes);
        reqDto.setPageSize(Integer.valueOf(skuCodes.size()));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
    }

    private boolean shopEmployee(List<String> shopCodesByEmployee) {
        return !shopCodesByEmployee.contains("1!=1");
    }

    private String getAreaCodeByName(String name) {
        if (PerformOrderOperationCommonServiceImpl.areaNameDataMap.isEmpty()) {
            AreaQueryExtReqDto reqDto = new AreaQueryExtReqDto();
            reqDto.setLevelId(Integer.valueOf(3));
            List areaTreeRespExtDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByTree(reqDto));
            if (CollectionUtil.isEmpty((Collection)areaTreeRespExtDtos)) {
                return null;
            }
            this.getAreaNameMap(areaTreeRespExtDtos);
        }
        return PerformOrderOperationCommonServiceImpl.areaNameDataMap.get(name);
    }

    private void getAreaNameMap(List<AreaTreeRespExtDto> areaTreeRespExtDtos) {
        if (CollectionUtil.isEmpty(areaTreeRespExtDtos)) {
            return;
        }
        areaTreeRespExtDtos.forEach(dto -> {
            PerformOrderOperationCommonServiceImpl.areaNameDataMap.put(dto.getName(), dto.getCode());
            this.getAreaNameMap(dto.getChildren());
        });
    }
}

