/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.pda.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.constants.AuthStateEnum;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPlatformShopDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPlatformShopPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPrintTemplateDto;
import com.yunxi.dg.base.center.inventory.proxy.pda.ILogisticsPlatformShopApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.pda.ILogisticsPrintTemplateApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.AuthReqDto;
import com.yunxi.dg.base.center.openapi.proxy.kuaidi100.IKuaidi100ApiProxy;
import com.yunxi.dg.base.mgmt.service.pda.BasedataCenterElectronicsSurfaceService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.AddSurfaceModelParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeleteEletronicsSurfaceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.ElectronicsSurfaceVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.GetElectronicsSurfaceListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.HandleElectronicsSurfaceAuthAccessParams;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BasedataCenterElectronicsSurfaceServiceServiceImpl
implements BasedataCenterElectronicsSurfaceService {
    private static final Logger logger = LoggerFactory.getLogger(BasedataCenterElectronicsSurfaceServiceServiceImpl.class);
    @Resource
    private ILogisticsPlatformShopApiProxy logisticsPlatformShopApi;
    @Resource
    private ILogisticsPrintTemplateApiProxy logisticsPrintTemplateApi;
    @Resource
    private IKuaidi100ApiProxy kuaidi100Api;

    @Override
    public RestResponse<Object> addElectronicsSurface(@ApiParam(value="") @Valid @RequestBody(required=false) ElectronicsSurfaceVO electronicsSurfaceVO) {
        LogisticsPlatformShopDto addReqDto = new LogisticsPlatformShopDto();
        this.reqParamConvert(electronicsSurfaceVO, addReqDto);
        logger.info("\u65b0\u589e\u7535\u5b50\u9762\u5355\u6388\u6743\u884c\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.logisticsPlatformShopApi.addLogisticsPlatformShop(addReqDto)));
    }

    @Override
    public RestResponse<Object> addSuraceModel(@ApiParam(value="") @Valid @RequestBody(required=false) AddSurfaceModelParams addSurfaceModelParams) {
        LogisticsPrintTemplateDto addReqDto = new LogisticsPrintTemplateDto();
        this.printTemplateReqParamConvert(addSurfaceModelParams, addReqDto);
        logger.info("\u65b0\u589e\u7535\u5b50\u9762\u5355\u6a21\u7248\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.logisticsPrintTemplateApi.addLogisticsPrintTemplate(addReqDto)));
    }

    @Override
    public RestResponse<Object> deleteElectronicsSurface(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteEletronicsSurfaceParams deleteEletronicsSurfaceParams) {
        logger.info("\u7535\u5b50\u9762\u5355\u6a21\u677f\u5220\u9664\u884c\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)deleteEletronicsSurfaceParams));
        AssertUtil.assertTrue(null != deleteEletronicsSurfaceParams.getId(), "\u7535\u5b50\u9762\u5355\u6a21\u677f\u5220\u9664\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.logisticsPrintTemplateApi.removeLogisticsPrintTemplate(deleteEletronicsSurfaceParams.getId())));
    }

    @Override
    public RestResponse<PageInfo<ElectronicsSurfaceVO>> getElectronicsSurfaceListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetElectronicsSurfaceListPageParams getElectronicsSurfaceListPageParams) {
        LogisticsPlatformShopPageReqDto reqDto = new LogisticsPlatformShopPageReqDto();
        this.queryParamConvert(getElectronicsSurfaceListPageParams, reqDto);
        logger.info("\u5206\u9875\u67e5\u8be2\u7535\u5b50\u9762\u5355\u5217\u8868\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsPlatformShopApi.queryByPage(getElectronicsSurfaceListPageParams.getPageNum(), getElectronicsSurfaceListPageParams.getPageSize(), reqDto));
        PageInfo copyPage = (PageInfo)BeanUtil.copyProperties((Object)pageInfo, PageInfo.class, (String[])new String[]{"list"});
        copyPage.setList(BeanUtil.copyToList((Collection)pageInfo.getList(), ElectronicsSurfaceVO.class));
        return new RestResponse((Object)copyPage);
    }

    @Override
    public RestResponse<PageInfo<LogisticsPrintTemplateDto>> getSurfaceModelList(LogisticsPrintTemplateDto reqDto) {
        return this.logisticsPrintTemplateApi.queryByPage(reqDto.getPageNum(), reqDto.getPageSize(), reqDto);
    }

    @Override
    public RestResponse<Object> handleElectronicsSurfaceAuthAccess(@ApiParam(value="") @Valid @RequestBody(required=false) HandleElectronicsSurfaceAuthAccessParams handleElectronicsSurfaceAuthAccessParams) {
        AssertUtil.assertTrue(null != handleElectronicsSurfaceAuthAccessParams.getId(), "\u9762\u5355\u6388\u6743id\u4e0d\u80fd\u4e3a\u7a7a");
        LogisticsPlatformShopPageReqDto reqDto = new LogisticsPlatformShopPageReqDto();
        reqDto.setId(handleElectronicsSurfaceAuthAccessParams.getId());
        List logisticsPlatformShopRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.logisticsPlatformShopApi.queryByParam(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)logisticsPlatformShopRespDtoList)) {
            LogisticsPlatformShopDto logisticsPlatformShopRespDto = (LogisticsPlatformShopDto)logisticsPlatformShopRespDtoList.get(0);
            AuthReqDto authReqDto = new AuthReqDto();
            authReqDto.setChannelCode(StrUtil.isBlank((CharSequence)logisticsPlatformShopRespDto.getChannelCode()) ? "kuaidi100" : logisticsPlatformShopRespDto.getChannelCode());
            authReqDto.setShopCode(logisticsPlatformShopRespDto.getShopCode());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("platformCode", (Object)logisticsPlatformShopRespDto.getPlatformCode());
            authReqDto.setExtension(jsonObject.toJSONString());
            logger.info("\u8c03\u7528\u5feb\u9012100\u6388\u6743:{}", (Object)JSONObject.toJSONString((Object)authReqDto));
            RestResponse authCodeUrl = this.kuaidi100Api.getAuthCodeUrl(authReqDto);
            String data = (String)RestResponseHelper.extractData((RestResponse)authCodeUrl);
            return new RestResponse((Object)data);
        }
        return new RestResponse();
    }

    public void queryParamConvert(GetElectronicsSurfaceListPageParams getElectronicsSurfaceListPageParams, LogisticsPlatformShopPageReqDto queryDto) {
        queryDto.setShopCode(getElectronicsSurfaceListPageParams.getShopCode());
        queryDto.setAuthState(getElectronicsSurfaceListPageParams.getAuthState());
    }

    public void reqParamConvert(ElectronicsSurfaceVO electronicsSurfaceVO, LogisticsPlatformShopDto reqDto) {
        reqDto.setPlatformCode(electronicsSurfaceVO.getPlatformCode());
        reqDto.setPlatformName(electronicsSurfaceVO.getPlatformName());
        reqDto.setChannelCode(StrUtil.isBlank((CharSequence)electronicsSurfaceVO.getChannelCode()) ? "kuaidi100" : electronicsSurfaceVO.getChannelCode());
        reqDto.setChannelName(StrUtil.isBlank((CharSequence)electronicsSurfaceVO.getChannelName()) ? "\u5feb\u9012100" : electronicsSurfaceVO.getChannelName());
        reqDto.setShopId(null != electronicsSurfaceVO.getShopId() ? ParamConverter.convertToLong((Object)electronicsSurfaceVO.getShopId()) : null);
        reqDto.setShopCode(electronicsSurfaceVO.getShopCode());
        reqDto.setShopName(electronicsSurfaceVO.getShopName());
        reqDto.setAuthState(AuthStateEnum.UNAUTHORIZED.getCode());
    }

    public void respParamConvert(ElectronicsSurfaceVO electronicsSurfaceVO, LogisticsPlatformShopDto respDto) {
        electronicsSurfaceVO.setPlatformCode(respDto.getPlatformCode());
        electronicsSurfaceVO.setPlatformName(respDto.getPlatformName());
        electronicsSurfaceVO.setChannelCode(respDto.getChannelCode());
        electronicsSurfaceVO.setChannelName(respDto.getChannelName());
        electronicsSurfaceVO.setShopId(ParamConverter.convertToString((Object)respDto.getShopId()));
        electronicsSurfaceVO.setShopCode(respDto.getShopCode());
        electronicsSurfaceVO.setShopName(respDto.getShopName());
        electronicsSurfaceVO.setAuthState(respDto.getAuthState());
        electronicsSurfaceVO.setId(respDto.getId());
        electronicsSurfaceVO.setPartnerKey(respDto.getPartnerKey());
        electronicsSurfaceVO.setPartnerld(respDto.getPartnerId());
        electronicsSurfaceVO.setPartnerUrl(respDto.getPartnerUrl());
        electronicsSurfaceVO.setCreatePerson(respDto.getCreatePerson());
        electronicsSurfaceVO.setCreateTime(null != respDto.getCreateTime() ? DateUtil.format((Date)respDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        electronicsSurfaceVO.setUpdatePerson(respDto.getUpdatePerson());
        electronicsSurfaceVO.setUpdateTime(null != respDto.getUpdateTime() ? DateUtil.format((Date)respDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        electronicsSurfaceVO.setAuthorizationTime(null != respDto.getExpireTime() ? DateUtil.format((Date)respDto.getExpireTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
    }

    public void printTemplateReqParamConvert(AddSurfaceModelParams addSurfaceModelParams, LogisticsPrintTemplateDto reqDto) {
        reqDto.setLogisticsCompanyCode(addSurfaceModelParams.getLogisticsCompanyCode());
        reqDto.setLogisticsCompanyName(addSurfaceModelParams.getLogisticsCompanyName());
        reqDto.setPrintTemplateType(addSurfaceModelParams.getPrintTemplateType());
        reqDto.setPrintTemplateValue(addSurfaceModelParams.getPrintTemplateValue());
        reqDto.setPrintItem(addSurfaceModelParams.getPrintItem());
        reqDto.setPrintRemark(addSurfaceModelParams.getPrintRemark());
        reqDto.setOlpId(null != addSurfaceModelParams.getParentId() ? ParamConverter.convertToLong((Object)addSurfaceModelParams.getParentId()) : null);
    }
}

