/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.pda.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.OutNoticeOrderOperateLogPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.pda.CallBackPrintReqDto;
import com.yunxi.dg.base.center.inventory.dto.pda.CancelLogisticsOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.pda.CreateShipOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.pda.DeliveryInfoDto;
import com.yunxi.dg.base.center.inventory.dto.pda.DeliveryInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.pda.LogisticsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.pda.LogisticsOrderCancelReqDto;
import com.yunxi.dg.base.center.inventory.dto.pda.WarehouseDeliveryReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.proxy.pda.IDeliveryLogisticsApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.pda.IOutNoticeOrderOperateLogApiProxy;
import com.yunxi.dg.base.center.report.dto.pda.CsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.report.dto.pda.CsDeliveryQueryReqDto;
import com.yunxi.dg.base.center.report.proxy.pda.IPdaDeliveryOrderQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.pda.InventoryCenterDeliveryOrderService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.constants.BizPrintTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.CancelLogisticsOrderResp;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryNumberRetrievalParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryOrderLogVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryOrderPrintCallbackVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryOrderQueryDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryOrderUpdateReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.DeliveryOrderVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.GetDeliveryOrderListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.GetDeliveryOrderLogListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.InlineObject1;
import com.yunxi.dg.base.ocs.mgmt.application.dto.pda.UpdateDeliveryShippingCode;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_delivery_order_info")
public class InventoryCenterDeliveryOrderServiceServiceImpl
implements InventoryCenterDeliveryOrderService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterDeliveryOrderServiceServiceImpl.class);
    @Resource
    private IPdaDeliveryOrderQueryApiProxy pdaDeliveryOrderQueryApiProxy;
    @Resource
    private IDeliveryLogisticsApiProxy deliveryLogisticsApi;
    @Resource
    private IOutNoticeOrderOperateLogApiProxy outNoticeOrderOperateLogQueryApi;
    public static Executor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 50, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable r) {
            return new Thread(r, "\u6279\u91cf\u53d6\u53f7-");
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public RestResponse<DeliveryOrderVO> getDeliveryOrderDetail(@ApiParam(value="") @Valid @RequestParam(value="id", required=false) String id) {
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<DeliveryOrderVO>> getDeliveryOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetDeliveryOrderListPageParams getDeliveryOrderListPageParams) {
        CsDeliveryQueryReqDto queryReqDto = this.getDeliveryQueryReqDto(getDeliveryOrderListPageParams);
        logger.info("\u53d1\u8d27\u5355\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pdaDeliveryOrderQueryApiProxy.queryDeliveryOrderPage(queryReqDto));
        PageInfo orderVOPageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new RestResponse((Object)orderVOPageInfo);
        }
        CubeBeanUtils.copyProperties((Object)orderVOPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List siteCodes = pageInfo.getList().stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getSourcePlatformCode())).map(p -> p.getSourcePlatformCode()).collect(Collectors.toList());
        List list = pageInfo.getList().stream().map(info -> {
            DeliveryOrderVO deliveryOrderVO = new DeliveryOrderVO();
            this.getDeliveryOrderVO(deliveryOrderVO, (CsDeliveryOrderRespDto)info);
            return deliveryOrderVO;
        }).collect(Collectors.toList());
        orderVOPageInfo.setList(list);
        return new RestResponse((Object)orderVOPageInfo);
    }

    private CsDeliveryQueryReqDto getDeliveryQueryReqDto(GetDeliveryOrderListPageParams params) {
        CsDeliveryQueryReqDto dto = new CsDeliveryQueryReqDto();
        BeanUtils.copyProperties((Object)params, (Object)dto);
        dto.setBusinessType(params.getBusinessOrderType());
        dto.setDisplayBusinessType(params.getBusinessOrderBizType());
        dto.setOrderStatus(params.getDocumentStatus());
        dto.setLogisticsOrderStatus(params.getLogisticsOrderStatus());
        dto.setOutLogicWarehouseCode(params.getDeliveryLogicalWarehouseCode());
        dto.setOutLogicWarehouseName(params.getDeliveryLogicalWarehouseName());
        dto.setInLogicWarehouseCode(params.getReceiveLogicalWarehouseCode());
        dto.setInLogicWarehouseName(params.getReceiveLogicalWarehouseName());
        dto.setCreateBeginTime(params.getCreateTimeStart());
        dto.setCreateEndTime(params.getCreateTimeEnd());
        dto.setDeliveryWay(params.getDeliveryWay());
        dto.setPageSize(params.getPageSize());
        dto.setPageNum(params.getPageNum());
        if (CollectionUtils.isNotEmpty((Collection)params.getOrderNoList()) && 1 == params.getOrderNoList().size()) {
            dto.setOrderNo((String)params.getOrderNoList().get(0));
            dto.setOrderNoList(null);
        } else {
            dto.setOrderNoList(params.getOrderNoList());
        }
        dto.setOutLogicWarehouseNameList(params.getOutLogicWarehouseNameList());
        dto.setOutLogicWarehouseCodeList(params.getOutLogicWarehouseCodeList());
        dto.setShippingCodeList(params.getShippingCodeList());
        dto.setShippingCompanyList(params.getShippingCompanyList());
        dto.setShopCodeList(params.getShopCodeList());
        dto.setItemCodeList(params.getItemCodeList());
        dto.setItemNameList(params.getItemNameList());
        dto.setSkuDisplayNameList(params.getSkuDisplayNameList());
        dto.setLogisticsPrintBeginTime(params.getLogisticsPrintBeginTime());
        dto.setLogisticsPrintEndTime(params.getLogisticsPrintEndTime());
        dto.setDeliveryEnterBeginTime(params.getDeliveryEnterBeginTime());
        dto.setDeliveryEnterEndTime(params.getDeliveryEnterEndTime());
        dto.setKeepingResult(params.getKeepingResult());
        dto.setTransportStyle(params.getTransportStyle());
        if (StringUtils.isNotBlank((CharSequence)params.getHistoryShippingCode())) {
            dto.setShippingCode(params.getHistoryShippingCode());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSnCode())) {
            dto.setSnCode(params.getSnCode());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getBarCode())) {
            dto.setBarCode(params.getBarCode());
        }
        dto.setCreatePerson(params.getCreatePerson());
        return dto;
    }

    public void getDeliveryOrderVO(DeliveryOrderVO deliveryOrderVO, CsDeliveryOrderRespDto deliveryOrderRespDto) {
        BeanUtils.copyProperties((Object)deliveryOrderRespDto, (Object)deliveryOrderVO);
        deliveryOrderVO.setDeliveryLogicalWarehouseName(deliveryOrderRespDto.getOutLogicWarehouseName());
        deliveryOrderVO.setDeliveryLogicalWarehouseCode(deliveryOrderRespDto.getOutLogicWarehouseCode());
        deliveryOrderVO.setReceiveLogicalWarehouseName(deliveryOrderRespDto.getInLogicWarehouseName());
        deliveryOrderVO.setReceiveLogicalWarehouseCode(deliveryOrderRespDto.getInLogicWarehouseCode());
        deliveryOrderVO.setDocumentStatus(deliveryOrderRespDto.getOrderStatus());
        deliveryOrderVO.setBusinessOrderNo(deliveryOrderRespDto.getRelevanceNo());
        deliveryOrderVO.setCreateTime(DateUtil.format((Date)deliveryOrderRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        deliveryOrderVO.setBusinessOrderBizType(deliveryOrderRespDto.getDisplayBusinessType());
        deliveryOrderVO.setBusinessOrderBizTypeName(deliveryOrderRespDto.getDisplayBusinessName());
        deliveryOrderVO.setBusinessOrderType(deliveryOrderRespDto.getJumpDocumentType());
        deliveryOrderVO.setBusinessOrderTypeName(deliveryOrderRespDto.getJumpDocumentName());
        deliveryOrderVO.setLogisticsOrderStatus(deliveryOrderRespDto.getLogisticsOrderStatus());
        deliveryOrderVO.setItemTotalNum(null != deliveryOrderRespDto.getItemTotalNum() ? Integer.valueOf(deliveryOrderRespDto.getItemTotalNum().intValue()) : null);
        deliveryOrderVO.setItemInfo(deliveryOrderRespDto.getItemInfo());
        deliveryOrderVO.setLogisticsPrintNum(deliveryOrderRespDto.getLogisticsPrintNum());
        deliveryOrderVO.setBuyerRemark(deliveryOrderRespDto.getBuyerRemark());
        deliveryOrderVO.setSellerRemark(deliveryOrderRespDto.getSellerRemark());
        deliveryOrderVO.setSourcePlatformCode(deliveryOrderRespDto.getSourcePlatformCode());
        deliveryOrderVO.setAddress(deliveryOrderRespDto.getAddress());
        deliveryOrderVO.setLogisticsPrintId(deliveryOrderRespDto.getLogisticsPrintId());
        deliveryOrderVO.setDeliveryWay(deliveryOrderRespDto.getDeliveryWay());
        deliveryOrderVO.setKeepingResult(deliveryOrderRespDto.getKeepingResult());
        deliveryOrderVO.setDeliveryNote(deliveryOrderRespDto.getDeliveryNote());
        if (null != deliveryOrderRespDto.getDeliveryEnterTime()) {
            deliveryOrderVO.setDeliveryEnterTime(DateUtil.format((Date)deliveryOrderRespDto.getDeliveryEnterTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (null != deliveryOrderRespDto.getLogisticsPrintTime()) {
            deliveryOrderVO.setLogisticsPrintTime(DateUtil.format((Date)deliveryOrderRespDto.getLogisticsPrintTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        deliveryOrderVO.setHistoryShippingCode(deliveryOrderRespDto.getHistoryShippingCode());
        deliveryOrderVO.setBarCode(deliveryOrderRespDto.getBarCode());
        deliveryOrderVO.setSnCode(deliveryOrderRespDto.getSnCode());
        deliveryOrderVO.setDeliveryPhone(deliveryOrderRespDto.getDeliveryPhone());
    }

    @Override
    public RestResponse<PageInfo<DeliveryOrderLogVO>> getDeliveryOrderLogListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetDeliveryOrderLogListPageParams getDeliveryOrderLogListPageParams) {
        OutNoticeOrderOperateLogPageReqDto queryDto = new OutNoticeOrderOperateLogPageReqDto();
        queryDto.setPageNum(getDeliveryOrderLogListPageParams.getPageNum());
        queryDto.setPageSize(getDeliveryOrderLogListPageParams.getPageSize());
        queryDto.setOutNoticeOrderNo(getDeliveryOrderLogListPageParams.getDocumentNo());
        logger.info("\u67e5\u8be2\u53d1\u8d27\u5355\u64cd\u4f5c\u65e5\u5fd7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderOperateLogQueryApi.queryByPage(queryDto));
        PageInfo logVOPageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new RestResponse((Object)logVOPageInfo);
        }
        CubeBeanUtils.copyProperties((Object)logVOPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = pageInfo.getList().stream().map(info -> {
            DeliveryOrderLogVO logVO = new DeliveryOrderLogVO();
            logVO.setOperationUser(info.getOperator());
            logVO.setOperationContent(info.getOperateInfo());
            logVO.setOperationTime(DateUtil.format((Date)info.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            return logVO;
        }).collect(Collectors.toList());
        logVOPageInfo.setList(list);
        return new RestResponse((Object)logVOPageInfo);
    }

    @Override
    public RestResponse<Object> offerDeliveryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) DeliveryNumberRetrievalParams deliveryNumberRetrievalParams) {
        logger.info("\u53d1\u8d27\u5355\u5feb\u9012\u53d6\u53f7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)deliveryNumberRetrievalParams));
        if (CollectionUtils.isEmpty((Collection)deliveryNumberRetrievalParams.getParams())) {
            throw new BizException("\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u53f7\u7684\u53d1\u8d27\u5355");
        }
        List<CsDeliveryOrderRespDto> deliveryOrderRespDtoList = this.getDeliveryInfoList(deliveryNumberRetrievalParams);
        Map map = deliveryOrderRespDtoList.stream().collect(Collectors.toMap(CsDeliveryOrderRespDto::getId, Function.identity(), (v1, v2) -> v1));
        ArrayList logisticsDeliveryOrderRespDtos = new ArrayList();
        ArrayList<CompletableFuture<Void>> completableFutureTasks = new ArrayList<CompletableFuture<Void>>(deliveryNumberRetrievalParams.getParams().size());
        for (DeliveryNumberRetrievalParams.OfferParams param : deliveryNumberRetrievalParams.getParams()) {
            completableFutureTasks.add(CompletableFuture.runAsync(() -> {
                Long id = param.getId();
                String count = param.getCount();
                CreateShipOrderReqDto reqDto = new CreateShipOrderReqDto();
                reqDto.setCount(count);
                reqDto.setAction(deliveryNumberRetrievalParams.getAction());
                LogisticsDeliveryOrderRespDto logisticsDeliveryOrderRespDto = new LogisticsDeliveryOrderRespDto();
                if (map.containsKey(id)) {
                    CsDeliveryOrderRespDto deliveryOrderRespDto = (CsDeliveryOrderRespDto)map.get(param.getId());
                    if (deliveryOrderRespDto.getInterconnectionFlag() != null && 1 == deliveryOrderRespDto.getInterconnectionFlag()) {
                        logger.info("\u4ed3\u5e93\u63a8\u9001wms\u4e0d\u9700\u8981\u53d6\u53f7\uff1a{}", (Object)deliveryOrderRespDto.getOutLogicWarehouseCode());
                        logisticsDeliveryOrderRespDto.setMessage("\u53d1\u8d27\u4ed3\u5df2\u5bf9\u63a5WMS\uff0c\u4e0d\u652f\u6301\u53d6\u53f7");
                        logisticsDeliveryOrderRespDto.setPrintStatus(Integer.valueOf(5));
                        logisticsDeliveryOrderRespDto.setReturnCode("100000");
                        logisticsDeliveryOrderRespDto.setDeliveryId(id);
                        logisticsDeliveryOrderRespDtos.add(logisticsDeliveryOrderRespDto);
                        return;
                    }
                    this.getCreateShipOrderReqDto(reqDto, deliveryOrderRespDto);
                    logisticsDeliveryOrderRespDto.setDocumentNo(deliveryOrderRespDto.getDocumentNo());
                }
                try {
                    logisticsDeliveryOrderRespDto = (LogisticsDeliveryOrderRespDto)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.createShipOrder(reqDto));
                }
                catch (Exception e) {
                    logisticsDeliveryOrderRespDto.setMessage(e.getMessage());
                    logisticsDeliveryOrderRespDto.setPrintStatus(Integer.valueOf(5));
                    logisticsDeliveryOrderRespDto.setReturnCode("100000");
                    logisticsDeliveryOrderRespDto.setDeliveryId(id);
                }
                logisticsDeliveryOrderRespDtos.add(logisticsDeliveryOrderRespDto);
            }, executor));
        }
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(completableFutureTasks.toArray(new CompletableFuture[0]));
        try {
            allFuture.get();
        }
        catch (Exception e) {
            throw new BizException(String.format("\u6279\u91cf\u53d6\u53f7\u6267\u884c\u5f02\u5e38:%s", e.getMessage()));
        }
        return new RestResponse(logisticsDeliveryOrderRespDtos);
    }

    private String getExpMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (StrUtil.isNotBlank((CharSequence)message) && message.split(":").length > 1) {
            message = message.split(":", 2)[1];
        }
        return message;
    }

    public List<CsDeliveryOrderRespDto> getDeliveryInfoList(DeliveryNumberRetrievalParams deliveryNumberRetrievalParams) {
        ArrayList<CsDeliveryOrderRespDto> deliveryOrderRespDtoList = new ArrayList<CsDeliveryOrderRespDto>();
        List ids = deliveryNumberRetrievalParams.getParams().stream().map(DeliveryNumberRetrievalParams.OfferParams::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            List lists = Lists.partition(ids, (int)1000);
            lists.forEach(list -> {
                CsDeliveryQueryReqDto queryReqDto = new CsDeliveryQueryReqDto();
                queryReqDto.setIdList(list);
                queryReqDto.setPageSize(Integer.valueOf(1000));
                queryReqDto.setPageNum(Integer.valueOf(1));
                logger.info("\u53d1\u8d27\u5355\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pdaDeliveryOrderQueryApiProxy.queryDeliveryOrderPage(queryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    deliveryOrderRespDtoList.addAll(pageInfo.getList());
                }
            });
        }
        return deliveryOrderRespDtoList;
    }

    public void getCreateShipOrderReqDto(CreateShipOrderReqDto reqDto, CsDeliveryOrderRespDto respDto) {
        reqDto.setId(respDto.getId());
        reqDto.setContact(respDto.getReceiveName());
        reqDto.setContactPhone(respDto.getReceivePhone());
        reqDto.setProvince(respDto.getProvince());
        reqDto.setProvinceCode(respDto.getProvinceCode());
        reqDto.setCity(respDto.getCity());
        reqDto.setCityCode(respDto.getCityCode());
        reqDto.setArea(respDto.getArea());
        reqDto.setStreet(respDto.getStreet());
        reqDto.setAddress(respDto.getAddress());
        reqDto.setAddr(respDto.getAddr());
        reqDto.setSellerRemark(respDto.getSellerRemark());
        reqDto.setBuyerRemark(respDto.getBuyerRemark());
        reqDto.setSaleOrderNo(respDto.getSaleOrderNo());
        reqDto.setPlatformOrderNo(respDto.getPlatformOrderNo());
        reqDto.setRemark(respDto.getRemark());
    }

    @Override
    public RestResponse<Object> recoveryDeliveryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject1 inlineObject1) {
        logger.info("\u53d1\u8d27\u5355\u56de\u6536\u5feb\u9012\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)inlineObject1));
        AssertUtil.assertNotEmpty(inlineObject1.getDocumentNoList(), "\u8bf7\u9009\u62e9\u9700\u8981\u56de\u6536\u5feb\u9012\u7684\u53d1\u8d27\u5355");
        ArrayList cancelLogisticsOrderRespDtoList = new ArrayList();
        inlineObject1.getDocumentNoList().forEach(orderNo -> {
            LogisticsOrderCancelReqDto logisticsOrderCancelReqDto = new LogisticsOrderCancelReqDto();
            logisticsOrderCancelReqDto.setBizOrderNo(orderNo);
            logisticsOrderCancelReqDto.setBizPrintType(BizPrintTypeEnum.DELIVERY.getCode());
            CancelLogisticsOrderResp cancelLogisticsOrderResp = new CancelLogisticsOrderResp();
            try {
                CancelLogisticsOrderRespDto cancelLogisticsOrderRespDto = (CancelLogisticsOrderRespDto)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.cancel(logisticsOrderCancelReqDto));
                CubeBeanUtils.copyProperties((Object)cancelLogisticsOrderResp, (Object)cancelLogisticsOrderRespDto, (String[])new String[0]);
                cancelLogisticsOrderResp.setDocumentNo(orderNo);
            }
            catch (Exception e) {
                cancelLogisticsOrderResp.setReturnCode("100000");
                cancelLogisticsOrderResp.setResult(Boolean.FALSE);
                cancelLogisticsOrderResp.setMessage(e.getMessage());
                cancelLogisticsOrderResp.setDocumentNo(orderNo);
            }
            cancelLogisticsOrderRespDtoList.add(cancelLogisticsOrderResp);
        });
        return new RestResponse(cancelLogisticsOrderRespDtoList);
    }

    @Override
    public RestResponse<Object> sendOutDeliveryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) WarehouseDeliveryReqDto warehouseDeliveryReqDto) {
        AssertUtil.assertNotEmpty(warehouseDeliveryReqDto.getDeliveryInfoReqDtoList(), "\u8bf7\u9009\u62e9\u9700\u8981\u53d1\u8d27\u7684\u53d1\u8d27\u5355");
        logger.info("\u53d1\u8d27\u5355\u4ed3\u5e93\u53d1\u8d27\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)warehouseDeliveryReqDto));
        List warehouseDeliveryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.warehouseDelivery(warehouseDeliveryReqDto));
        return new RestResponse((Object)warehouseDeliveryRespDtoList);
    }

    @Override
    public RestResponse<Object> callbackDeliveryOrderPrintResult(@ApiParam(value="") @Valid @RequestBody(required=false) List<DeliveryOrderPrintCallbackVO> deliveryOrderPrintCallbackVO) {
        if (CollectionUtils.isEmpty(deliveryOrderPrintCallbackVO)) {
            throw new BizException("\u6253\u5370\u56de\u8c03\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList reqDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(reqDtoList, deliveryOrderPrintCallbackVO, CallBackPrintReqDto.class);
        logger.info("\u6253\u5370\u56de\u8c03\u5165\u53c2:{}", (Object)JSON.toJSONString(reqDtoList));
        Void data = (Void)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.printCallback(reqDtoList));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> queryDeliveryByExpressNo(DeliveryOrderQueryDto queryDto) {
        AssertUtil.assertTrue(StringUtils.isNotEmpty((CharSequence)queryDto.getExpressNo()), "\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryInfoQueryDto infoQueryDto = new DeliveryInfoQueryDto();
        infoQueryDto.setShippingCode(queryDto.getExpressNo());
        logger.info("\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)infoQueryDto));
        List deliveryOrderInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.queryDeliveryByParam(infoQueryDto));
        return new RestResponse((Object)deliveryOrderInfoRespDtoList);
    }

    @Override
    public RestResponse<Void> fillOutDeliveryOrderShippingCode(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateDeliveryShippingCode updateDeliveryShippingCode) {
        DeliveryInfoDto deliveryInfoDto = new DeliveryInfoDto();
        deliveryInfoDto.setDeliveryNo(updateDeliveryShippingCode.getOrderNo());
        deliveryInfoDto.setShippingCode(updateDeliveryShippingCode.getShippingCode());
        Void unused = (Void)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.updateDeliveryInfo(deliveryInfoDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> updateLogisticsOrderStatus(DeliveryOrderUpdateReqDto reqDto) {
        return this.deliveryLogisticsApi.updateLogisticsOrderStatus(reqDto);
    }

    @Override
    public RestResponse<Void> printPickingOrderCallback(List<DeliveryOrderPrintCallbackVO> deliveryOrderPrintCallbackVO) {
        if (CollectionUtils.isEmpty(deliveryOrderPrintCallbackVO)) {
            throw new BizException("\u6253\u5370\u56de\u8c03\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList reqDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(reqDtoList, deliveryOrderPrintCallbackVO, CallBackPrintReqDto.class);
        logger.info("\u6253\u5370\u56de\u8c03\u5165\u53c2:{}", (Object)JSON.toJSONString(reqDtoList));
        Void data = (Void)RestResponseHelper.extractData((RestResponse)this.deliveryLogisticsApi.printPickingOrderCallback(reqDtoList));
        return new RestResponse();
    }

    @Override
    public RestResponse<String> generatePickingOrderNo() {
        return this.deliveryLogisticsApi.generatePickingOrderNo();
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchUpdateShippingCompany(@RequestBody List<DeliveryInfoDto> reqDto) {
        return this.deliveryLogisticsApi.batchUpdateShippingCompany(reqDto);
    }
}

