/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.excel;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.mgmt.service.IDataExportServiceAble;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbleEasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(AbleEasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String BUCKET_NAME;
    private static String END_POINT;
    public static final int MAX_CNT = 10000;
    private static final Integer RETRY_MAX_COUNT;

    private static Workbook append(List excelRespDtos, Class tClass, String title, String excelName) {
        ExportParams params = new ExportParams(title, "");
        return ExcelExportUtil.exportBigExcel((ExportParams)params, (Class)tClass, (Collection)excelRespDtos);
    }

    private static void close() {
        ExcelExportUtil.closeExportBigExcel();
    }

    private static void initConfig() {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (BUCKET_NAME == null) {
            BUCKET_NAME = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        if (END_POINT == null) {
            END_POINT = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        }
    }

    private static String getLoadUrl(Workbook workbook, String excelName, String title) {
        String fileName = excelName;
        String suffixName = ".xlsx";
        if (!excelName.endsWith(suffixName)) {
            fileName = excelName + suffixName;
        }
        AbleEasyPoiExportUtil.initConfig();
        FileOutputStream fos = null;
        ByteArrayInputStream fis = null;
        String url = "";
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tmp", ".xlsx");
            fos = new FileOutputStream(tempFile);
            workbook.write((OutputStream)fos);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            url = objectStorageService.put(BUCKET_NAME, fileName, (InputStream)fileInputStream);
        }
        catch (IOException e) {
            logger.error("{}\u5bfc\u51faexcel\u5f02\u5e38", (Object)title, (Object)e);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
                if (tempFile != null) {
                    tempFile.deleteOnExit();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        return url;
    }

    public static String uploadFile(IDataExportServiceAble serviceAble, Object params, Class classTemplate, String fileName) {
        Workbook workbook = null;
        boolean hasNext = true;
        while (hasNext) {
            List scrollData = null;
            int count = 0;
            while (count < RETRY_MAX_COUNT) {
                try {
                    scrollData = serviceAble.scrollData(params);
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw e;
                }
            }
            if (CollectionUtil.isEmpty(scrollData)) {
                scrollData = new ArrayList();
                hasNext = false;
            }
            workbook = AbleEasyPoiExportUtil.append(scrollData, classTemplate, null, fileName);
        }
        AbleEasyPoiExportUtil.close();
        return AbleEasyPoiExportUtil.getLoadUrl(workbook, fileName, null);
    }

    public static String uploadFile(Function serviceAble, Object params, Class classTemplate, String fileName) {
        Workbook workbook = null;
        boolean hasNext = true;
        while (hasNext) {
            List scrollData = new ArrayList();
            int count = 0;
            while (count < RETRY_MAX_COUNT) {
                try {
                    scrollData = (List)serviceAble.apply(params);
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw e;
                }
            }
            if (CollectionUtil.isEmpty(scrollData)) {
                scrollData = new ArrayList();
                hasNext = false;
            }
            workbook = AbleEasyPoiExportUtil.append(scrollData, classTemplate, null, fileName);
        }
        AbleEasyPoiExportUtil.close();
        return AbleEasyPoiExportUtil.getLoadUrl(workbook, fileName, null);
    }

    public static Workbook appenData(List excelRespDtos, Class tClass, String title, String excelName) {
        ExportParams params = new ExportParams(title, "");
        if (Objects.isNull(excelRespDtos)) {
            excelRespDtos = new ArrayList();
        }
        return ExcelExportUtil.exportBigExcel((ExportParams)params, (Class)tClass, excelRespDtos);
    }

    public static String getLoadWorkbookUrl(Workbook workbook, String excelName, String title) {
        AbleEasyPoiExportUtil.close();
        return AbleEasyPoiExportUtil.getLoadUrl(workbook, excelName, title);
    }

    static {
        RETRY_MAX_COUNT = 3;
    }
}

