/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemSnRecordDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.description.DgMultilevelDescriptionPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterTypeRecordApiProxy;
import com.yunxi.dg.base.center.trade.proxy.description.IDgMultilevelDescriptionBizApiProxy;
import com.yunxi.dg.base.center.trade.proxy.order.IPerformOrderQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ShopReturnWarehouseConfigDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ShopReturnWarehouseConfigPageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.shop.IShopReturnWarehouseConfigApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.utils.StringFieldTrimmer;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AfterSaleReturnOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_after_return_order_import")
public class AfterSaleReturnOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AfterSaleReturnOrderCommonServiceImpl.class);
    @Resource
    private IPerformOrderQueryApiProxy performOrderQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource(name="warehouseApiProxy")
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgAfterTypeRecordApiProxy dgAfterTypeRecordApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    @Resource
    private IDgMultilevelDescriptionBizApiProxy dgMultilevelDescriptionBizApiProxy;
    @Resource
    private IShopReturnWarehouseConfigApiProxy shopReturnWarehouseConfigApiProxy;
    public static final String BIZ_MODEL = "THTK";
    public static final String BIZ_TYPE = "\u666e\u901a\u9000\u8d27";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u552e\u540e\u6709\u539f\u5355\u9000\u8d27\u9000\u6b3e\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), AfterSaleReturnOrderImportDto.class);
        StringFieldTrimmer.trimStringsInList(resultList, AfterSaleReturnOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        Map<String, DgBizPerformOrderRespDto> saleOrderMap = this.getSaleOrder(resultList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getSaleOrderNo())).map(AfterSaleReturnOrderImportDto::getSaleOrderNo).collect(Collectors.toList()));
        Set skuCodes = resultList.stream().map(AfterSaleReturnOrderImportDto::getSkuCode).collect(Collectors.toSet());
        Set<String> warehouseCodes = resultList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getReturnWarehouseCode())).map(AfterSaleReturnOrderImportDto::getReturnWarehouseCode).collect(Collectors.toSet());
        Set<String> shopCodes = this.getSaleOrderShopCode(new ArrayList<DgBizPerformOrderRespDto>(saleOrderMap.values()));
        Map<String, List<DgPerformOrderRespDto>> saleOrderListMap = this.getSaleOrderListMap(resultList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getPlatformOrderNo())).map(AfterSaleReturnOrderImportDto::getPlatformOrderNo).collect(Collectors.toList()));
        Map<String, DgItemSkuDetailRespDto> skuInfoMap = this.getSkuInfoByCodes(new ArrayList<String>(skuCodes));
        Map<String, DgShopRespDto> shopInfoMap = this.getShop(new ArrayList<String>(shopCodes));
        Map<String, List<LogicWarehouseRespDto>> warehouseByCodeMap = this.getWarehouseByCode(warehouseCodes);
        Map<String, List<ShopReturnWarehouseConfigDto>> returnWarehouseConfigDtoMap = this.getReturnWarehouseList();
        for (AfterSaleReturnOrderImportDto importDto : resultList) {
            boolean isPass = this.checkAndInitParam(importDto, skuInfoMap, shopInfoMap, warehouseByCodeMap, saleOrderMap, returnWarehouseConfigDtoMap, saleOrderListMap);
            if (isPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private Map<String, List<DgPerformOrderRespDto>> getSaleOrderListMap(List<String> performOrderNos) {
        if (CollectionUtils.isEmpty(performOrderNos)) {
            return Maps.newHashMap();
        }
        List list = (List)this.performOrderQueryApiProxy.queryOrderByPlatformOrderNo(performOrderNos).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(p -> "DELIVERED".equals(p.getOrderStatus()) || "COMPLETE".equals(p.getOrderStatus())).collect(Collectors.groupingBy(p -> p.getPlatformOrderNo()));
    }

    private Map<String, List<ShopReturnWarehouseConfigDto>> getReturnWarehouseList() {
        List list = (List)this.shopReturnWarehouseConfigApiProxy.queryList(new ShopReturnWarehouseConfigPageReqDto()).getData();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return MapUtil.empty();
        }
        return list.stream().collect(Collectors.groupingBy(p -> this.getShopReturnWarehouseKey(p.getShopCode(), p.getDeliveryWarehouseCode())));
    }

    private String getShopReturnWarehouseKey(String shopCode, String deliveryWarehouseCode) {
        return shopCode + ":" + deliveryWarehouseCode;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList;
        log.info("\u552e\u540e\u9000\u8d27\u9000\u6b3e\u6709\u539f\u5355-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        if (CollectionUtil.isEmpty((Collection)(passList = (List)object))) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        Map<String, List<AfterSaleReturnOrderImportDto>> mapBySaleOrderNo = passList.stream().collect(Collectors.groupingBy(AfterSaleReturnOrderImportDto::getSaleOrderNo));
        mapBySaleOrderNo.forEach((saleOrderNo, itemList) -> {
            AfterSaleReturnOrderImportDto afterSaleReturnOrderImportDto = (AfterSaleReturnOrderImportDto)itemList.get(0);
            DgBizAfterSaleOrderReqDto dto = this.buildDgBizAfterSaleOrderReqDto((List<AfterSaleReturnOrderImportDto>)itemList, afterSaleReturnOrderImportDto);
            this.saveOrder(respDto, dto, afterSaleReturnOrderImportDto);
            itemList.forEach(item -> item.setErrorMsg(afterSaleReturnOrderImportDto.getErrorMsg()));
        });
    }

    private DgBizAfterSaleOrderReqDto buildDgBizAfterSaleOrderReqDto(List<AfterSaleReturnOrderImportDto> itemList, AfterSaleReturnOrderImportDto importDto) {
        DgBizAfterSaleOrderReqDto dto = new DgBizAfterSaleOrderReqDto();
        BeanUtil.copyProperties((Object)importDto, (Object)dto, (String[])new String[0]);
        dto.setAfterSaleOrderType(BIZ_MODEL);
        dto.setChannelCode(importDto.getChannelCode());
        dto.setOrderSource(Integer.valueOf(0));
        dto.setBizDate(new Date());
        dto.setAfterBusinessTypeCode(importDto.getAfterBusinessTypeCode());
        dto.setAfterBusinessTypeName(importDto.getAfterBusinessTypeName());
        dto.setIfRecord(importDto.getIfRecord());
        dto.setIfInvoice(importDto.getIfInvoice());
        dto.setPlatformApplyRefundType("REFUND_RETURN");
        dto.setStatus("WAIT_AUDIT");
        dto.setRelateToPlatformOrder(Integer.valueOf(0));
        dto.setSaleOrderId(importDto.getSaleOrderId());
        dto.setSaleOrderNo(importDto.getSaleOrderNo());
        dto.setRefundType("\u662f".equals(importDto.getIsSmallRefund()) ? "small_refund" : null);
        List<AfterSaleReturnOrderImportDto> itemListForSave = this.processSameSkuCode(itemList);
        BigDecimal refundFee = BigDecimal.ZERO;
        ArrayList<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (AfterSaleReturnOrderImportDto detail : itemListForSave) {
            DgAfterSaleOrderItemModifyReqDto modifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
            BeanUtil.copyProperties((Object)detail, (Object)modifyReqDto, (String[])new String[0]);
            modifyReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
            refundFee = refundFee.add(detail.getRefundAmount());
            afterSaleOrderItemReqDtoList.add(modifyReqDto);
        }
        dto.setRefundFee(refundFee);
        dto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        return dto;
    }

    private List<AfterSaleReturnOrderImportDto> processSameSkuCode(List<AfterSaleReturnOrderImportDto> list) {
        return list.stream().collect(Collectors.toMap(AfterSaleReturnOrderImportDto::getSkuCode, Function.identity(), (o1, o2) -> {
            o1.setItemNum(Integer.valueOf(o1.getItemNum() + o2.getItemNum()));
            o1.setRefundAmount(o1.getRefundAmount().add(o2.getRefundAmount()));
            return o1;
        })).values().stream().collect(Collectors.toList());
    }

    public boolean checkAndInitParam(AfterSaleReturnOrderImportDto importDto, Map<String, DgItemSkuDetailRespDto> skuInfoMap, Map<String, DgShopRespDto> shopInfoMap, Map<String, List<LogicWarehouseRespDto>> warehouseByCodeMap, Map<String, DgBizPerformOrderRespDto> saleOrderMap, Map<String, List<ShopReturnWarehouseConfigDto>> returnWarehouseConfigDtoMap, Map<String, List<DgPerformOrderRespDto>> saleOrderListMap) {
        boolean allowSmallTypeText;
        List itemList;
        DgPerformOrderItemExtRespDto saleOrderLine;
        StringBuffer errorMsg = new StringBuffer();
        if (StringUtils.isEmpty((CharSequence)importDto.getSaleOrderNo()) && StringUtils.isEmpty((CharSequence)importDto.getPlatformOrderNo())) {
            errorMsg.append("\u5e73\u53f0\u8ba2\u5355\u53f7\u548c\u5185\u90e8\u9500\u552e\u5355\u53f7\u81f3\u5c11\u8981\u586b\u5199\u4e00\u4e2a;");
            importDto.setErrorMsg(errorMsg.toString());
            return true;
        }
        DgBizPerformOrderRespDto saleOrder = saleOrderMap.getOrDefault(importDto.getSaleOrderNo(), null);
        if (Objects.isNull(saleOrder)) {
            List saleOrderList = saleOrderListMap.getOrDefault(importDto.getPlatformOrderNo(), null);
            if (CollectionUtils.isEmpty((Collection)saleOrderList)) {
                errorMsg.append("\u539f\u5355\u4e0d\u5b58\u5728;");
                importDto.setErrorMsg(errorMsg.toString());
                return true;
            }
            if (saleOrderList.size() > 1) {
                errorMsg.append("\u5b58\u5728\u591a\u4e2a\u539f\u5355\u4fe1\u606f;");
                saleOrder = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(((DgPerformOrderRespDto)saleOrderList.get(0)).getSaleOrderNo()));
            } else {
                saleOrder = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(((DgPerformOrderRespDto)saleOrderList.get(0)).getSaleOrderNo()));
            }
        }
        if (!Objects.equals(saleOrder.getOrderStatus(), "DELIVERED") && !Objects.equals(saleOrder.getOrderStatus(), "COMPLETE")) {
            errorMsg.append("\u539f\u5355\u5fc5\u987b\u662f\u5df2\u53d1\u8d27\u6216\u8005\u5df2\u5b8c\u6210\u72b6\u6001;");
        } else {
            importDto.setChannelCode(saleOrder.getPerformOrderSnapshotDto().getChannelCode());
            importDto.setSaleOrderId(saleOrder.getId());
            importDto.setSaleOrderNo(saleOrder.getSaleOrderNo());
            importDto.setShopId(saleOrder.getPerformOrderSnapshotDto().getShopId());
            importDto.setShopName(saleOrder.getPerformOrderSnapshotDto().getShopName());
            importDto.setShopCode(saleOrder.getPerformOrderSnapshotDto().getShopCode());
            DgPerformOrderAddrRespDto orderAddrRespDto = saleOrder.getOrderAddrRespDto();
            importDto.setReturnAddress(orderAddrRespDto.getReceiveAddress());
            importDto.setReturnCityCode(orderAddrRespDto.getCityCode());
            importDto.setReturnCityName(orderAddrRespDto.getCity());
            importDto.setReturnCountyCode(orderAddrRespDto.getCountyCode());
            importDto.setReturnCountyName(orderAddrRespDto.getCounty());
            importDto.setReturnProvinceCode(orderAddrRespDto.getProvinceCode());
            importDto.setReturnProvinceName(orderAddrRespDto.getProvince());
            importDto.setReturnRecipient(orderAddrRespDto.getReceiveName());
            importDto.setReturnRecipientPhone(orderAddrRespDto.getReceivePhone());
        }
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuInfoMap.get(importDto.getSkuCode());
        if (Objects.isNull(dgItemSkuDetailRespDto)) {
            errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728;");
        } else {
            importDto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
            importDto.setItemId(dgItemSkuDetailRespDto.getItemId());
            importDto.setItemCode(dgItemSkuDetailRespDto.getItemCode());
            importDto.setItemName(dgItemSkuDetailRespDto.getItemName());
            importDto.setVolume(dgItemSkuDetailRespDto.getVolume());
            importDto.setWeight(dgItemSkuDetailRespDto.getGrossWeight());
        }
        String shopCode = saleOrder.getPerformOrderSnapshotDto().getShopCode();
        String deliveryLogicalWarehouseCode = saleOrder.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode();
        List<ShopReturnWarehouseConfigDto> shopReturnWarehouseConfigDtos = returnWarehouseConfigDtoMap.get(this.getShopReturnWarehouseKey(shopCode, deliveryLogicalWarehouseCode));
        List<LogicWarehouseRespDto> logicWarehouseRespDtoList = warehouseByCodeMap.get(importDto.getReturnWarehouseCode());
        if (CollectionUtil.isEmpty(logicWarehouseRespDtoList)) {
            if (CollectionUtils.isEmpty(shopReturnWarehouseConfigDtos)) {
                errorMsg.append("\u9000\u8d27\u5165\u5e93\u4ed3\u4e0d\u5b58\u5728;");
            } else {
                ShopReturnWarehouseConfigDto shopReturnWarehouseConfigDto = this.getDefaultReturnWarehouse(shopReturnWarehouseConfigDtos);
                if (shopReturnWarehouseConfigDto != null) {
                    importDto.setReturnWarehouseName(shopReturnWarehouseConfigDto.getReturnWarehouseName());
                    importDto.setReturnWarehouseCode(shopReturnWarehouseConfigDto.getReturnWarehouseCode());
                } else {
                    log.info("\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u9000\u8d27\u4ed3,shopCode:{},deliveryLogicalWarehouseCode:{}", (Object)shopCode, (Object)deliveryLogicalWarehouseCode);
                    errorMsg.append("\u9000\u8d27\u5165\u5e93\u4ed3\u4e0d\u5b58\u5728;");
                }
            }
        } else if (Objects.nonNull(logicWarehouseRespDtoList.get(0))) {
            LogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseRespDtoList.get(0);
            if (!Objects.equals(logicWarehouseRespDto.getWarehouseProperty(), "damaged") && !Objects.equals(logicWarehouseRespDto.getWarehouseProperty(), "aftersales")) {
                errorMsg.append("\u9000\u8d27\u4ed3\u5fc5\u987b\u662f\u552e\u540e\u4ed3/\u6b8b\u635f\u4ed3;");
            } else {
                importDto.setReturnWarehouseName(logicWarehouseRespDto.getWarehouseName());
                importDto.setReturnWarehouseId(logicWarehouseRespDto.getId());
            }
            try {
                if (CollectionUtils.isEmpty(shopReturnWarehouseConfigDtos)) {
                    log.info("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a");
                    errorMsg.append("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u672a\u914d\u7f6e\u6b64\u9000\u8d27\u5165\u5e93\u4ed3;");
                } else {
                    List returnWarehouseCodeList = shopReturnWarehouseConfigDtos.stream().map(ShopReturnWarehouseConfigDto::getReturnWarehouseCode).collect(Collectors.toList());
                    if (!returnWarehouseCodeList.contains(importDto.getReturnWarehouseCode())) {
                        log.info("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u914d\u7f6e\u6570\u636e\u627e\u4e0d\u5230,returnWarehouseCode:{},list:{}", (Object)importDto.getReturnWarehouseCode(), returnWarehouseCodeList);
                        errorMsg.append("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u672a\u914d\u7f6e\u6b64\u9000\u8d27\u5165\u5e93\u4ed3;");
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u672a\u914d\u7f6e\u6b64\u9000\u8d27\u5165\u5e93\u4ed3\u5f02\u5e38,msg:{}", (Object)e.getMessage(), (Object)e);
                errorMsg.append("\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u672a\u914d\u7f6e\u6b64\u9000\u8d27\u5165\u5e93\u4ed3;");
            }
        }
        importDto.setBizType(saleOrder.getBizType());
        Map<String, DgAfterTypeRecordDto> afterTypeMap = this.getAfterTypeMap();
        DgAfterTypeRecordDto afterTypeRecordDto = afterTypeMap.getOrDefault(importDto.getAfterBusinessTypeName(), null);
        if (Objects.isNull(afterTypeRecordDto)) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getAfterBusinessTypeName())) {
                errorMsg.append("\u552e\u540e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728;");
            } else {
                afterTypeRecordDto = afterTypeMap.get(BIZ_TYPE);
            }
        }
        if (afterTypeRecordDto != null) {
            importDto.setAfterBusinessTypeCode(afterTypeRecordDto.getAfterBusinessTypeCode());
            importDto.setAfterBusinessTypeName(afterTypeRecordDto.getAfterBusinessTypeName());
            importDto.setIfRecord(afterTypeRecordDto.getIfRecord());
            importDto.setIfInvoice(afterTypeRecordDto.getIfInvoice());
        }
        if (Objects.isNull(saleOrderLine = (DgPerformOrderItemExtRespDto)(itemList = saleOrder.getItemList()).stream().filter(item -> Objects.equals(item.getSkuCode(), importDto.getSkuCode())).findAny().orElse(null))) {
            errorMsg.append("sku\u5728\u9500\u552e\u539f\u5355\u4e2d\u4e0d\u5b58\u5728;");
        } else {
            BigDecimal refundableAmount = saleOrderLine.getRefundableAmount();
            if (Objects.isNull(refundableAmount)) {
                errorMsg.append("\u5269\u4f59\u53ef\u9000\u91d1\u989d\u67e5\u8be2\u4e0d\u5230;");
            }
            if (Objects.isNull(importDto.getRefundAmount())) {
                errorMsg.append("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (importDto.getRefundAmount().compareTo(saleOrderLine.getRefundableAmount()) > 0 && importDto.getRefundAmount().compareTo(refundableAmount) > 0) {
                errorMsg.append("\u9000\u6b3e\u91d1\u989d\u8d85\u8fc7\u53ef\u9000\u91d1\u989d;");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getAfterSaleOrderReasonName())) {
            Long afterSaleOrderReason = this.getAfterSaleOrderReason(importDto.getAfterSaleOrderReasonName());
            if (Objects.isNull(afterSaleOrderReason)) {
                errorMsg.append("\u5185\u90e8\u552e\u540e\u539f\u56e0\u4e0d\u5b58\u5728;");
            } else {
                importDto.setAfterSaleOrderReason(afterSaleOrderReason);
            }
        }
        boolean bl = allowSmallTypeText = StringUtils.isBlank((CharSequence)importDto.getIsSmallRefund()) || "\u662f".equals(importDto.getIsSmallRefund().trim()) || "\u5426".equals(importDto.getIsSmallRefund().trim());
        if (!allowSmallTypeText) {
            errorMsg.append("\u662f\u5426\u5c0f\u989d\u4ec5\u5141\u8bb8\u586b\u5199[\u662f/\u5426];");
        }
        importDto.setErrorMsg(errorMsg.toString());
        return errorMsg.length() > 0;
    }

    private ShopReturnWarehouseConfigDto getDefaultReturnWarehouse(List<ShopReturnWarehouseConfigDto> list) {
        List filterList = list.stream().filter(p -> p.getDefaultReturnWarehouseFlag() == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterList)) {
            return (ShopReturnWarehouseConfigDto)filterList.get(0);
        }
        return null;
    }

    private Long getAfterSaleOrderReason(String name) {
        DgMultilevelDescriptionPageReqDto dto = new DgMultilevelDescriptionPageReqDto();
        dto.setName(name);
        List dgMultilevelDescriptionDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgMultilevelDescriptionBizApiProxy.queryAll(dto));
        if (CollectionUtil.isEmpty((Collection)dgMultilevelDescriptionDtos)) {
            return null;
        }
        return dgMultilevelDescriptionDtos.stream().filter(d -> Objects.equals(d.getName(), name)).findAny().map(BaseDto::getId).orElse(null);
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizAfterSaleOrderReqDto reqDto, AfterSaleReturnOrderImportDto dto) {
        try {
            DgBizPerformOrderRespDto saleOrder = this.getSaleOrder(Lists.newArrayList((Object[])new String[]{dto.getSaleOrderNo()})).get(dto.getSaleOrderNo());
            List itemList = saleOrder.getItemList();
            reqDto.getAfterSaleOrderItemReqDtoList().forEach(afterItem -> {
                DgPerformOrderItemExtRespDto saleOrderLine = itemList.stream().filter(item -> Objects.equals(item.getSkuCode(), afterItem.getSkuCode())).findAny().orElse(null);
                BigDecimal totalRefundAmount = afterItem.getRefundAmount();
                if (Objects.isNull(saleOrderLine)) {
                    this.setErrorMsg(dto, "sku\u5728\u9500\u552e\u539f\u5355\u4e2d\u4e0d\u5b58\u5728;");
                } else {
                    BigDecimal refundableAmount = saleOrderLine.getRefundableAmount();
                    if (Objects.isNull(refundableAmount)) {
                        this.setErrorMsg(dto, "\u5269\u4f59\u53ef\u9000\u91d1\u989d\u67e5\u8be2\u4e0d\u5230;");
                    }
                    if (totalRefundAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        this.setErrorMsg(dto, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c0f\u4e8e0;");
                    } else if (totalRefundAmount.compareTo(saleOrderLine.getRefundableAmount()) > 0) {
                        this.setErrorMsg(dto, "\u4e0d\u53ef\u8d85\u8fc7\u5269\u4f59\u53ef\u9000\u91d1\u989d;");
                    }
                    List amountDtoList = saleOrderLine.getAmountDtoList();
                    BigDecimal lineOrigPrice = amountDtoList.stream().filter(amount -> Objects.equals("LINE_ORIG_PRICE", amount.getAccountType())).map(DgPerformOrderLineAmountDto::getAmount).findAny().orElse(BigDecimal.ZERO);
                    BigDecimal lineActualPrice = amountDtoList.stream().filter(amount -> Objects.equals("LINE_ACTUAL_PRICE", amount.getAccountType())).map(DgPerformOrderLineAmountDto::getAmount).findAny().orElse(BigDecimal.ZERO);
                    afterItem.setSaleOrderItemId(saleOrderLine.getId());
                    afterItem.setPlatformItemName(saleOrderLine.getPlatformItemName());
                    afterItem.setOrigRealPayAmount(lineActualPrice);
                    afterItem.setRealPayAmount(lineActualPrice);
                    afterItem.setPayAmount(lineOrigPrice);
                    afterItem.setOrigPayAmount(lineOrigPrice);
                    afterItem.setOrigItemNum(Integer.valueOf(saleOrderLine.getItemNum().intValue()));
                    String snCode = saleOrderLine.getSnCode();
                    if (StringUtils.isNotBlank((CharSequence)snCode)) {
                        List collect = Stream.of(snCode.split(";")).map(sn -> {
                            DgAfterSaleOrderItemSnRecordDto snDto = new DgAfterSaleOrderItemSnRecordDto();
                            snDto.setSnCode(sn);
                            return snDto;
                        }).collect(Collectors.toList());
                        afterItem.setSnRecordDtoList(collect);
                    }
                }
            });
            log.info("createAfterSale\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.dgAfterSaleOrderApiProxy.createAfterSale(BIZ_MODEL, reqDto));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u552e\u540e\u65e0\u539f\u5355\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u5bfc\u5165\u552e\u540e\u6709\u539f\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    private void setErrorMsg(AfterSaleReturnOrderImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }

    private Set<String> getSaleOrderShopCode(List<DgBizPerformOrderRespDto> saleOrderList) {
        HashSet<String> shopCodes = new HashSet<String>();
        saleOrderList.forEach(order -> Optional.ofNullable(order).map(DgPerformOrderRespDto::getPerformOrderSnapshotDto).map(DgPerformOrderSnapshotDto::getShopCode).ifPresent(shopCodes::add));
        return shopCodes;
    }

    private Map<String, DgBizPerformOrderRespDto> getSaleOrder(List<String> saleOrderNoList) {
        if (CollectionUtils.isEmpty(saleOrderNoList)) {
            return Maps.newHashMap();
        }
        HashMap<String, DgBizPerformOrderRespDto> result = new HashMap<String, DgBizPerformOrderRespDto>();
        saleOrderNoList.forEach(saleOrderNo -> {
            DgBizPerformOrderRespDto dgBizPerformOrderRespDto = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(saleOrderNo));
            Optional.ofNullable(dgBizPerformOrderRespDto).ifPresent(order -> result.put((String)saleOrderNo, dgBizPerformOrderRespDto));
        });
        return result;
    }

    private Map<String, DgItemSkuDetailRespDto> getSkuInfoByCodes(List<String> skuCodes) {
        ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
        skuReqDto.setSkuCodes(skuCodes);
        return ((List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData()).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity()));
    }

    private Map<String, DgShopRespDto> getShop(List<String> shopCodes) {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setStoreCodeList(shopCodes);
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{1}));
        List dgShopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.queryListShop(reqDto));
        if (Objects.isNull(dgShopRespDtos) || CollectionUtil.isEmpty((Collection)dgShopRespDtos)) {
            return MapUtil.empty();
        }
        return dgShopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, List<LogicWarehouseRespDto>> getWarehouseByCode(Set<String> warehouseCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return new HashMap<String, List<LogicWarehouseRespDto>>();
        }
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(new ArrayList<String>(warehouseCodes));
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setWarehouseStatus("enable");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryData(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseCode())).collect(Collectors.groupingBy(LogicWarehouseRespDto::getWarehouseCode));
    }

    private Map<String, DgAfterTypeRecordDto> getAfterTypeMap() {
        DgAfterTypeRecordPageReqDto reqDto = new DgAfterTypeRecordPageReqDto();
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgAfterTypeRecordApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgAfterTypeRecordDto::getAfterBusinessTypeName, Function.identity(), (v1, v2) -> v2));
    }
}

