/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.wh.center.expenses.api.dto.request.ExpenseQueryDetailReqDto;
import com.wh.center.expenses.api.dto.response.ExpenseRespDto;
import com.wh.center.expenses.api.query.IExpenseQueryApi;
import com.yunxi.dg.base.center.report.dto.entity.CostArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchivePageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCategoryDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCategoryPageReqDto;
import com.yunxi.dg.base.center.report.proxy.entity.ICostArchiveApiProxy;
import com.yunxi.dg.base.center.report.proxy.entity.ICostCategoryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.CostArchiveImport;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_COST_ARCHIVE_MANAGE")
public class CostArchiveFileOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    @Resource
    private ICostArchiveApiProxy iCostArchiveApiProxy;
    @Resource
    private ICostCategoryApiProxy iCostCategoryApiProxy;
    @Resource
    private IExpenseQueryApi expenseQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List<CostArchiveImport> costArchiveImports = this.convertToList(result.getList());
        ArrayList<CostArchiveImport> passList = new ArrayList<CostArchiveImport>();
        this.verifyCostArchive(respDto, costArchiveImports, passList, commonReqDto);
        return passList;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtils.isEmpty((Collection)passList)) {
            return;
        }
        try {
            RestResponseHelper.extractData((RestResponse)this.iCostArchiveApiProxy.insertBatch(BeanUtil.copyToList((Collection)passList, CostArchiveDto.class)));
        }
        catch (Exception e) {
            passList.stream().forEach(item -> {
                item.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", item.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5bfc\u5165\u5f02\u5e38" + e.getMessage()));
                respDto.getErrorDetails().add(item);
            });
        }
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private List<CostArchiveImport> convertToList(List<ImportBaseModeDto> resultList) {
        ArrayList<CostArchiveImport> list = new ArrayList<CostArchiveImport>();
        CubeBeanUtils.copyCollection(list, resultList, CostArchiveImport.class);
        return list;
    }

    private void verifyCostArchive(ImportFileOperationCommonRespDto respDto, List<CostArchiveImport> skuCostImports, List<CostArchiveImport> passList, ImportFileOperationCommonReqDto commonReqDto) {
        if (CollectionUtils.isEmpty(skuCostImports)) {
            return;
        }
        List<String> codes = skuCostImports.stream().map(CostArchiveImport::getCode).collect(Collectors.toList());
        Map<String, CostArchiveDto> costArchiveDtoMap = this.mapCostArchiveByCodes(codes);
        List<String> categoryCodeList = skuCostImports.stream().map(CostArchiveImport::getCategoryCode).collect(Collectors.toList());
        Map<String, CostCategoryDto> costCategoryDtoMap = this.mapCostCategoryByCodes(categoryCodeList);
        List<String> expenseCodes = skuCostImports.stream().map(CostArchiveImport::getExpenseCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, String> expenseMap = this.getExpenseNameMap(expenseCodes);
        for (CostArchiveImport skuCostImport : skuCostImports) {
            CostArchiveDto costArchiveDto;
            CostCategoryDto costCategoryDto = costCategoryDtoMap.get(skuCostImport.getCategoryCode());
            if (Objects.isNull(costCategoryDto)) {
                skuCostImport.setErrorMsg("\u7c7b\u76ee\u7f16\u7801\u4e0d\u5b58\u5728");
                skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                respDto.getErrorDetails().add(skuCostImport);
                continue;
            }
            if (StrUtil.isNotBlank((CharSequence)skuCostImport.getExpenseCode())) {
                if (!expenseMap.containsKey(skuCostImport.getExpenseCode())) {
                    skuCostImport.setErrorMsg("\u5173\u8054\u8d22\u52a1\u79d1\u76ee\u7f16\u7801\u4e0d\u5b58\u5728");
                    skuCostImport.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", skuCostImport.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), skuCostImport.getErrorMsg()));
                    respDto.getErrorDetails().add(skuCostImport);
                    continue;
                }
                skuCostImport.setExpenseName(expenseMap.get(skuCostImport.getExpenseCode()));
            }
            if (Objects.nonNull(costArchiveDto = costArchiveDtoMap.get(skuCostImport.getCode()))) {
                skuCostImport.setId(costArchiveDto.getId());
            }
            passList.add(skuCostImport);
        }
    }

    private Map<String, String> getExpenseNameMap(List<String> expenseCodes) {
        if (expenseCodes == null || expenseCodes.isEmpty()) {
            return new HashMap<String, String>();
        }
        ExpenseQueryDetailReqDto req = new ExpenseQueryDetailReqDto();
        req.setCodes(expenseCodes);
        RestResponse resp = this.expenseQueryApi.queryByCodes(req);
        List expenses = (List)RestResponseHelper.extractData((RestResponse)resp);
        return expenses.stream().collect(Collectors.toMap(ExpenseRespDto::getExpenseCode, ExpenseRespDto::getExpenseName));
    }

    private Map<String, CostCategoryDto> mapCostCategoryByCodes(List<String> categoryCodeList) {
        CostCategoryPageReqDto pageReqDto = new CostCategoryPageReqDto();
        pageReqDto.setCodeList(categoryCodeList);
        List costCategoryDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCostCategoryApiProxy.queryList(pageReqDto));
        if (CollectionUtil.isEmpty((Collection)costCategoryDtos)) {
            return Collections.emptyMap();
        }
        return costCategoryDtos.stream().collect(Collectors.toMap(CostCategoryDto::getCode, Function.identity(), (v1, v2) -> v1));
    }

    private Map<String, CostArchiveDto> mapCostArchiveByCodes(List<String> codes) {
        CostArchivePageReqDto archivePageReqDto = new CostArchivePageReqDto();
        archivePageReqDto.setCodeList(codes);
        List archiveDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iCostArchiveApiProxy.queryList(archivePageReqDto));
        if (CollectionUtil.isEmpty((Collection)archiveDtoList)) {
            return Collections.emptyMap();
        }
        return archiveDtoList.stream().collect(Collectors.toMap(CostArchiveDto::getCode, Function.identity(), (v1, v2) -> v1));
    }
}

