/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.customer.dto.entity.CustomerDiscountConfigDto;
import com.yunxi.dg.base.center.customer.dto.entity.CustomerDiscountConfigPageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerInfoExtRespDto;
import com.yunxi.dg.base.center.customer.proxy.entity.ICustomerDiscountConfigApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.CustomerDiscountConfigImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportSplitWarehouseConfigurationModeDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.CustomerDiscountConfigExportDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_customer_discount_config")
public class CustomerDiscountConfigCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(CustomerDiscountConfigCommonServiceImpl.class);
    @Resource
    private ICustomerDiscountConfigApiProxy iCustomerDiscountConfigApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy iTransactionCustomerQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List list = BeanUtil.copyToList((Collection)result.getList(), CustomerDiscountConfigImportDto.class);
        ArrayList<CustomerDiscountConfigImportDto> passList = new ArrayList<CustomerDiscountConfigImportDto>();
        ArrayList<CustomerDiscountConfigImportDto> uniqueList = new ArrayList<CustomerDiscountConfigImportDto>();
        for (CustomerDiscountConfigImportDto importDto : list) {
            if (this.paramVerify(importDto)) {
                boolean repeat = false;
                if (CollectionUtil.isNotEmpty(uniqueList)) {
                    for (CustomerDiscountConfigImportDto configImportDto : uniqueList) {
                        if (!this.combinePorperty(importDto).equals(this.combinePorperty(configImportDto))) continue;
                        importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8be5\u5ba2\u6237\u6298\u6263\u5b58\u5728\u91cd\u590d\u8bb0\u5f55"));
                        respDto.getErrorDetails().add(importDto);
                        repeat = true;
                        break;
                    }
                }
                if (repeat) continue;
                uniqueList.add(importDto);
                passList.add(importDto);
                continue;
            }
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
            respDto.getErrorDetails().add(importDto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        try {
            for (CustomerDiscountConfigImportDto importDto : passList) {
                CustomerDiscountConfigDto configDto = new CustomerDiscountConfigDto();
                BeanUtil.copyProperties((Object)importDto, (Object)configDto, (String[])new String[0]);
                BigDecimal discount = NumberUtil.add((String[])new String[]{importDto.getDiscount()});
                configDto.setDiscount(discount);
                RestResponseHelper.extractData((RestResponse)this.iCustomerDiscountConfigApiProxy.insert(configDto));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        CustomerDiscountConfigPageReqDto pageReqDto = new CustomerDiscountConfigPageReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            pageReqDto = (CustomerDiscountConfigPageReqDto)JSON.parseObject((String)filter, CustomerDiscountConfigPageReqDto.class);
        }
        if (FileModeTypeEnum.CUSTOMER_DISCOUNT_CONFIG.getKey().equals(key)) {
            List customerDiscountConfigDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerDiscountConfigApiProxy.query(pageReqDto));
            if (CollectionUtil.isNotEmpty((Collection)customerDiscountConfigDtos)) {
                return Collections.EMPTY_LIST;
            }
            List list = customerDiscountConfigDtos.stream().map(i -> {
                CustomerDiscountConfigExportDto exportDto = new CustomerDiscountConfigExportDto();
                BeanUtil.copyProperties((Object)i, (Object)exportDto, (String[])new String[0]);
                exportDto.setCreateTime(DateUtil.formatDateTime((Date)i.getCreateTime()));
                exportDto.setUpdateTime(DateUtil.formatDateTime((Date)i.getUpdateTime()));
                return exportDto;
            }).collect(Collectors.toList());
            log.info("\u5206\u4ed3\u6570\u91cf\u914d\u7f6e\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean paramVerify(CustomerDiscountConfigImportDto importDto) {
        if (StrUtil.isBlank((CharSequence)importDto.getCustomerCode())) {
            importDto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        DgCustomerInfoExtRespDto dgCustomerInfoExtRespDto = (DgCustomerInfoExtRespDto)RestResponseHelper.extractData((RestResponse)this.iTransactionCustomerQueryApiProxy.queryByCode(importDto.getCustomerCode()));
        if (null == dgCustomerInfoExtRespDto) {
            importDto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (StrUtil.isBlank((CharSequence)importDto.getDiscount())) {
            importDto.setErrorMsg("\u6298\u6263\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        BigDecimal discount = NumberUtil.add((String[])new String[]{importDto.getDiscount()});
        if (discount.scale() > 2) {
            importDto.setErrorMsg("\u6298\u6263\u4e0d\u5141\u8bb8\u8d85\u8fc72\u4f4d\u5c0f\u6570");
            return false;
        }
        if (discount.compareTo(NumberUtil.add((Number[])new Number[]{0})) > 0 && discount.compareTo(NumberUtil.add((Number[])new Number[]{100})) <= 0) {
            importDto.setErrorMsg("\u8bf7\u8f93\u5165\u6298\u6263\u8303\u56f4\u5728>0\u4e14<=100\u7684\u6570\u5b57");
            return false;
        }
        if (importDto.getRemark().length() > 200) {
            importDto.setErrorMsg("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u6bb5");
            return false;
        }
        CustomerDiscountConfigPageReqDto pageReqDto = new CustomerDiscountConfigPageReqDto();
        ArrayList<String> list = new ArrayList<String>();
        list.add(importDto.getCustomerCode());
        pageReqDto.setCustomerCodes(list);
        List customerDiscountConfigDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerDiscountConfigApiProxy.query(pageReqDto));
        if (CollectionUtil.isNotEmpty((Collection)customerDiscountConfigDtos)) {
            for (CustomerDiscountConfigDto configDto : customerDiscountConfigDtos) {
                if (!importDto.getDiscount().equals(configDto.getDiscount())) continue;
                importDto.setErrorMsg("\u8be5\u5ba2\u6237\u6298\u6263\u5df2\u5b58\u5728");
                return false;
            }
        }
        return true;
    }

    private String combinePorperty(CustomerDiscountConfigImportDto importDto) {
        StringBuffer s = new StringBuffer();
        s.append(importDto.getCustomerCode());
        s.append(importDto.getDiscount());
        return s.toString();
    }

    private String setErrorMsg(ImportSplitWarehouseConfigurationModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

