/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IDirectoryDgApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IDirectoryDgQueryApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.BatchAddDirectoryDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.DirectoryDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.DirectoryItemDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.DirectoryItemLevelDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportFrontDirectoryModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_front_directory_import")
public class FrontDirectoryCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(FrontDirectoryCommonServiceImpl.class);
    @Resource
    private IDirectoryDgApi directoryDgApi;
    @Resource
    private IDirectoryDgQueryApi directoryDgQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        List respDtoByBackCode;
        List respDtoByCode;
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportFrontDirectoryModeDto.class);
        ArrayList<ImportFrontDirectoryModeDto> passList = new ArrayList<ImportFrontDirectoryModeDto>();
        ArrayList<String> parentNames = new ArrayList<String>();
        ArrayList<String> backCodes = new ArrayList<String>();
        ArrayList<String> codes = new ArrayList<String>();
        for (ImportFrontDirectoryModeDto importFrontDirectoryModeDto : list) {
            String[] splits;
            String backCode;
            codes.add(importFrontDirectoryModeDto.getCode());
            if (Objects.nonNull(importFrontDirectoryModeDto.getParentName())) {
                parentNames.add(importFrontDirectoryModeDto.getParentName());
            }
            if (Objects.isNull(backCode = importFrontDirectoryModeDto.getBackCode())) continue;
            for (String split : splits = backCode.split(",")) {
                backCodes.add(split);
            }
        }
        HashMap<String, DirectoryItemDgRespDto> mapByParentName = new HashMap<String, DirectoryItemDgRespDto>();
        HashMap<String, DirectoryItemDgRespDto> mapByBackName = new HashMap();
        HashMap<String, DirectoryItemDgRespDto> mapByCode = new HashMap();
        Map<Long, Object> parentLevelMap = new HashMap<Long, DirectoryItemLevelDgRespDto>();
        if (CollectionUtil.isNotEmpty(codes) && CollectionUtil.isNotEmpty((Collection)(respDtoByCode = (List)this.directoryDgQueryApi.queryDirByFilter(codes, Integer.valueOf(2), "front").getData()))) {
            mapByCode = respDtoByCode.stream().collect(Collectors.toMap(DirectoryItemDgRespDto::getCode, Function.identity(), (o1, o2) -> o1));
        }
        if (CollectionUtil.isNotEmpty(parentNames)) {
            ArrayList<Long> parentIds = new ArrayList<Long>();
            List respDtoByParentName = (List)this.directoryDgQueryApi.queryDirByFilter(parentNames, Integer.valueOf(1), "front").getData();
            if (CollectionUtil.isNotEmpty((Collection)respDtoByParentName)) {
                for (DirectoryItemDgRespDto directoryItemDgRespDto : respDtoByParentName) {
                    mapByParentName.put(directoryItemDgRespDto.getName(), directoryItemDgRespDto);
                    parentIds.add(directoryItemDgRespDto.getId());
                }
                mapByParentName = respDtoByParentName.stream().collect(Collectors.toMap(DirectoryItemDgRespDto::getName, Function.identity(), (o1, o2) -> o1));
                List parentLevels = (List)this.directoryDgQueryApi.queryLevels(parentIds).getData();
                if (CollectionUtil.isNotEmpty((Collection)parentLevels)) {
                    parentLevelMap = parentLevels.stream().collect(Collectors.toMap(DirectoryItemLevelDgRespDto::getId, Function.identity(), (k1, k2) -> k2));
                }
            }
        }
        if (CollectionUtil.isNotEmpty(backCodes) && CollectionUtil.isNotEmpty((Collection)(respDtoByBackCode = (List)this.directoryDgQueryApi.queryDirByFilter(backCodes, Integer.valueOf(2), "back").getData()))) {
            mapByBackName = respDtoByBackCode.stream().collect(Collectors.toMap(DirectoryItemDgRespDto::getCode, Function.identity(), (o1, o2) -> o1));
        }
        HashSet<String> codeList = new HashSet<String>();
        HashSet<String> nameList = new HashSet<String>();
        for (ImportFrontDirectoryModeDto dto : list) {
            if (Objects.equals(dto.getStatusName(), "\u7981\u7528")) {
                dto.setStatus(Integer.valueOf(0));
            } else {
                dto.setStatus(Integer.valueOf(1));
            }
            Boolean verify = this.unitVerify(dto, mapByParentName, mapByBackName, mapByCode, parentLevelMap, passList, codeList, nameList);
            if (verify.booleanValue()) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtos = Lists.newArrayList();
        try {
            for (ImportFrontDirectoryModeDto modeDto : passList) {
                DirectoryDgReqDto dto = new DirectoryDgReqDto();
                dto.setCode(modeDto.getCode());
                dto.setDescription(modeDto.getRemark());
                dto.setName(modeDto.getName());
                dto.setParentName(modeDto.getParentName());
                dto.setStatus(modeDto.getStatus());
                dto.setCreatePerson(commonReqDto.getCreatePerson());
                dto.setFrontRelationBack(modeDto.getBackCode());
                dto.setUpdatePerson(commonReqDto.getCreatePerson());
                reqDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u524d\u53f0\u7c7b\u76ee,:{}", (Object)JacksonUtil.toJson((Object)reqDtos));
        BatchAddDirectoryDgReqDto reqDto = new BatchAddDirectoryDgReqDto();
        reqDto.setDirectoryDgReqDtos((List)reqDtos);
        reqDto.setDirUsage("front");
        this.directoryDgApi.batchImportAddDirectory(reqDto);
    }

    private Boolean unitVerify(ImportFrontDirectoryModeDto dto, Map<String, DirectoryItemDgRespDto> mapByParentName, Map<String, DirectoryItemDgRespDto> mapByBackName, Map<String, DirectoryItemDgRespDto> mapByCode, Map<Long, DirectoryItemLevelDgRespDto> parentLevelMap, List<ImportFrontDirectoryModeDto> passList, Set<String> codeList, Set<String> nameList) {
        String backCode;
        if (passList.contains(dto)) {
            dto.setErrorMsg("\u7c7b\u76ee\u5df2\u6dfb\u52a0\u81f3\u5217\u8868");
            return false;
        }
        if (Objects.isNull(dto.getName())) {
            dto.setErrorMsg("\u7c7b\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (nameList.contains(dto.getName())) {
            dto.setErrorMsg("\u540d\u5b57\u5df2\u6dfb\u52a0\u81f3\u5217\u8868");
            return false;
        }
        if (dto.getName().length() > 20) {
            dto.setErrorMsg("\u7c7b\u76ee\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
            return false;
        }
        if (Objects.isNull(dto.getCode())) {
            dto.setErrorMsg("\u7c7b\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (codeList.contains(dto.getCode())) {
            dto.setErrorMsg("\u7f16\u7801\u5df2\u6dfb\u52a0\u81f3\u5217\u8868");
            return false;
        }
        if (dto.getCode().length() > 20) {
            dto.setErrorMsg("\u7c7b\u76ee\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
            return false;
        }
        if (Objects.nonNull(mapByCode.get(dto.getCode()))) {
            dto.setErrorMsg("\u7c7b\u76ee\u7f16\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (Objects.nonNull(dto.getParentName()) && dto.getParentName().length() > 20) {
            dto.setErrorMsg("\u7236\u7ea7\u7c7b\u76ee\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
            return false;
        }
        if (Objects.nonNull(dto.getRemark()) && dto.getRemark().length() > 200) {
            dto.setErrorMsg("\u5907\u6ce8\u4e0d\u53ef\u8d85\u8fc7200\u4e2a\u5b57");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentName())) {
            DirectoryItemDgRespDto respDto3 = mapByParentName.get(dto.getParentName());
            if (ObjectUtils.isEmpty((Object)respDto3)) {
                dto.setErrorMsg("\u7236\u7c7b\u76ee\u4e0d\u5b58\u5728");
                return false;
            }
            DirectoryItemLevelDgRespDto levelDgRespDto = parentLevelMap.get(respDto3.getId());
            if (Objects.nonNull(levelDgRespDto) && Objects.nonNull(levelDgRespDto.getLevel()) && levelDgRespDto.getLevel() >= 3) {
                dto.setErrorMsg("\u524d\u53f0\u7c7b\u76ee\u6700\u591a\u6dfb\u52a0\u4e09\u7ea7");
                return false;
            }
        }
        if (Objects.nonNull(backCode = dto.getBackCode())) {
            String[] splits;
            String backId = "";
            for (String split : splits = backCode.split(",")) {
                DirectoryItemDgRespDto backDirDto = mapByBackName.get(split);
                if (Objects.isNull(backDirDto)) {
                    dto.setErrorMsg("\u5173\u8054\u540e\u53f0\u7c7b\u76ee" + split + "\u4e0d\u5b58\u5728");
                    return false;
                }
                backId = backId.length() > 0 ? backId + "," + backDirDto.getId() : backId + backDirDto.getId();
            }
            dto.setBackCode(backId);
        }
        codeList.add(dto.getCode());
        nameList.add(dto.getName());
        return true;
    }
}

