/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDetailPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderDetailApiProxy;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpItemCostQueryDto;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpMaterialCarryLineRequestDto;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpMaterialCarryRequestDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalItemErpApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.mgmt.service.IOcsInOtherStorageOrderService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BusinessTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcsInOtherStorageOrderServiceImpl
implements IOcsInOtherStorageOrderService {
    private static final Logger log = LoggerFactory.getLogger(OcsInOtherStorageOrderServiceImpl.class);
    @Resource
    private IExternalInventoryErpApiProxy iExternalInventoryErpApiProxy;
    @Resource
    private IDgInOtherStorageOrderApiProxy iDgInOtherStorageOrderApiProxy;
    @Autowired
    private IInOtherStorageOrderApiProxy inOtherStorageOrderApiProxy;
    @Autowired
    private IExternalItemErpApiProxy iExternalItemErpApiProxy;
    @Autowired
    private IInOtherStorageOrderDetailApiProxy inOtherStorageOrderDetailApiProxy;

    @Override
    public RestResponse<Void> complete(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.complete(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancel(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.inOtherStorageOrderApiProxy.cancel(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> submit(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.inOtherStorageOrderApiProxy.submit(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchClose(List<InOtherStorageOrderUpdateDto> reqDto) {
        BatchOrderOperationMsgDto batchOrderOperationMsgDto = (BatchOrderOperationMsgDto)RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.batchClose(reqDto));
        List orderNoList = reqDto.stream().filter(o -> o.getOrderType().equals(BusinessTypeEnum.PARTS_REQUISITION_OUT.getType())).map(InOtherStorageOrderUpdateDto::getStorageOrderNo).collect(Collectors.toList());
        if (StringUtils.equals((String)reqDto.get(0).getAuditResult(), (String)YesNoEnum.YES.getValue().toString())) {
            try {
                RestResponseHelper.extractData((RestResponse)this.iExternalInventoryErpApiProxy.closeMaterialCarryOrder(orderNoList));
            }
            catch (Exception e) {
                log.info("ERP\u5173\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return new RestResponse((Object)batchOrderOperationMsgDto);
    }

    @Override
    public RestResponse<Void> audit(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.audit(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> submitById(Long id) {
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.submitById(id));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchCancel(List<InOtherStorageOrderUpdateDto> reqDto) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.batchCancel(reqDto)));
    }

    @Override
    public RestResponse<Long> addOtherStorageOrder(InOtherStorageOrderDto reqDto) {
        if (StringUtils.equals((String)reqDto.getBusinessType(), (String)BusinessTypeEnum.PARTS_REQUISITION_OUT.getType())) {
            try {
                this.supplementaryPrice(reqDto);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u65b0\u589e\u914d\u4ef6\u9886\u7528\u5355\uff0c\u8865\u5145\u5355\u4ef7\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
        log.info("\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.addOtherStorageOrder(reqDto));
        return new RestResponse((Object)id);
    }

    private void supplementaryPrice(InOtherStorageOrderDto reqDto) {
        List inOtherStorageOrderDetailDtos = reqDto.getInOtherStorageOrderDetailDtos();
        Map<String, String> skuCodePriceMap = this.getSkuCodePrice(reqDto, inOtherStorageOrderDetailDtos);
        inOtherStorageOrderDetailDtos.forEach(inOtherStorageOrderDetailDto -> inOtherStorageOrderDetailDto.setUnitPrice((String)skuCodePriceMap.get(inOtherStorageOrderDetailDto.getSkuCode())));
    }

    private Map<String, String> getSkuCodePrice(InOtherStorageOrderDto reqDto, List<InOtherStorageOrderDetailDto> inOtherStorageOrderDetailDtos) {
        List skuCodeList = inOtherStorageOrderDetailDtos.stream().map(InOtherStorageOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        ErpItemCostQueryDto erpItemCostQueryDto = new ErpItemCostQueryDto();
        erpItemCostQueryDto.setItemCodes(skuCodeList);
        erpItemCostQueryDto.setCompanyCode(reqDto.getSaleOrganizationCode());
        List erpItemCostDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iExternalItemErpApiProxy.queryItemCost(erpItemCostQueryDto))).orElse(Lists.newArrayList());
        HashMap skuCodePriceMap = Maps.newHashMap();
        erpItemCostDtoList.forEach(erpItemCostDto -> skuCodePriceMap.put(erpItemCostDto.getItemCode(), erpItemCostDto.getItemCost()));
        log.info("\u67e5\u8be2\u5230erp\u5546\u54c1\u5355\u4ef7\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)skuCodePriceMap));
        return skuCodePriceMap;
    }

    private ErpMaterialCarryRequestDto getErpMaterialCarryRequestDto(InOtherStorageOrderDto reqDto, DgInOtherStorageOrderDto inOtherStorageOrderDto) {
        ErpMaterialCarryRequestDto carryRequestDto = new ErpMaterialCarryRequestDto();
        carryRequestDto.setTransactionType(reqDto.getType());
        carryRequestDto.setDealDate(DateUtil.formatDateTime((Date)reqDto.getBizDate()));
        carryRequestDto.setCompanyCode(reqDto.getSaleOrganizationCode());
        carryRequestDto.setSourceNumber(inOtherStorageOrderDto.getStorageOrderNo());
        ArrayList dtoList = Lists.newArrayList();
        List orderDetailDtoList = reqDto.getInOtherStorageOrderDetailDtos();
        orderDetailDtoList.forEach(orderDetailDto -> {
            ErpMaterialCarryLineRequestDto lineRequestDto = new ErpMaterialCarryLineRequestDto();
            lineRequestDto.setItemCode(orderDetailDto.getSkuCode());
            lineRequestDto.setItemDescription(orderDetailDto.getSkuName());
            lineRequestDto.setTransactionQuantity(BigDecimalUtils.toStr((BigDecimal)orderDetailDto.getQuantity()));
            dtoList.add(lineRequestDto);
        });
        carryRequestDto.setLines((List)dtoList);
        return carryRequestDto;
    }

    @Override
    public RestResponse<Void> withdraw(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.withdraw(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> close(InOtherStorageOrderUpdateDto reqDto) {
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.close(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchWithdraw(List<InOtherStorageOrderUpdateDto> reqDto) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.batchWithdraw(reqDto)));
    }

    @Override
    public RestResponse<Void> updateUnitPriceTask() {
        DgInOtherStorageOrderDetailPageReqDto reqDto = new DgInOtherStorageOrderDetailPageReqDto();
        List dgInOtherStorageOrderDetailDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgInOtherStorageOrderApiProxy.queryPartsRequisitionList(reqDto));
        log.info("\u67e5\u8be2\u5230\u9700\u8981\u4fee\u6539\u7684\u914d\u4ef6\u9886\u7528\u5355\u6570\u91cf:{}", (Object)dgInOtherStorageOrderDetailDtos.size());
        if (CollectionUtil.isEmpty((Collection)dgInOtherStorageOrderDetailDtos)) {
            return null;
        }
        Map<String, List<DgInOtherStorageOrderDetailDto>> saleOrganizationMap = dgInOtherStorageOrderDetailDtos.stream().collect(Collectors.groupingBy(DgInOtherStorageOrderDto::getSaleOrganizationCode));
        HashMap skuCodePriceMap = Maps.newHashMap();
        saleOrganizationMap.forEach((key, otherStorageOrderList) -> {
            List skuCodeList = otherStorageOrderList.stream().map(DgInOtherStorageOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
            ErpItemCostQueryDto erpItemCostQueryDto = new ErpItemCostQueryDto();
            erpItemCostQueryDto.setItemCodes(skuCodeList);
            erpItemCostQueryDto.setCompanyCode(key);
            List erpItemCostDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iExternalItemErpApiProxy.queryItemCost(erpItemCostQueryDto))).orElse(Lists.newArrayList());
            erpItemCostDtoList.forEach(erpItemCostDto -> skuCodePriceMap.put(erpItemCostDto.getCompanyCode() + "_" + erpItemCostDto.getItemCode(), BigDecimalUtils.parse((String)erpItemCostDto.getItemCost())));
        });
        log.info("\u67e5\u8be2\u5230erp\u5546\u54c1\u4ef7\u683c\u4e3a:{}", (Object)JSON.toJSONString((Object)skuCodePriceMap));
        ArrayList reqDtoList = Lists.newArrayList();
        dgInOtherStorageOrderDetailDtos.forEach(dgInOtherStorageOrderDetailDto -> {
            String key = dgInOtherStorageOrderDetailDto.getSaleOrganizationCode() + "_" + dgInOtherStorageOrderDetailDto.getSkuCode();
            InOtherStorageOrderDetailPageReqDto dto = new InOtherStorageOrderDetailPageReqDto();
            dto.setId(dgInOtherStorageOrderDetailDto.getId());
            dto.setUnitPrice((BigDecimal)skuCodePriceMap.get(key));
        });
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderDetailApiProxy.updateUnitPrice((List)reqDtoList));
        return RestResponse.VOID;
    }
}

