/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IItemExtendAdapterQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.calculatebiz.ISaleCalculateApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.planbiz.IPlanConfigApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.report.ISaleCountReportQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.planbiz.SalesPlanDistributionReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.planbiz.SalesPlanDistributionRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.calculatebiz.AddSaleCalculateDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.calculatebiz.AddSaleCalculateDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrgAdvRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.report.SaleCountTotalQueryReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.report.SaleCountTotalRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ItemExtendAdapterReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SaleCalculateImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ItemExtendAdapterRespDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_sale_calculate")
public class SaleCalculateOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(SaleCalculateOperationCommonServiceImpl.class);
    @Resource
    private ISaleCalculateApiProxy saleCalculateApiProxy;
    @Resource
    private IItemExtendAdapterQueryApi itemExtendAdapterQueryApi;
    @Resource
    private ISaleCountReportQueryApiProxy saleCountReportQueryApiProxy;
    @Resource
    private IPlanConfigApiProxy planConfigApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        return null;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List importBaseModeDtos = result.getList();
        ArrayList saleCalculateImportDtos = Lists.newArrayList();
        importBaseModeDtos.forEach(e -> saleCalculateImportDtos.add((SaleCalculateImportDto)e));
        List<SaleCalculateImportDto> errorList = this.validate(saleCalculateImportDtos);
        if (CollectionUtil.isNotEmpty(errorList)) {
            respDto.setErrorDetails(errorList);
            return;
        }
        String deptName = this.dept(((SaleCalculateImportDto)saleCalculateImportDtos.get(0)).getDeptCode());
        errorList = this.validate((List<SaleCalculateImportDto>)saleCalculateImportDtos, deptName);
        if (CollectionUtil.isNotEmpty(errorList)) {
            respDto.setErrorDetails(errorList);
            return;
        }
        HashMap<String, ItemExtendAdapterRespDto> itemMap = new HashMap<String, ItemExtendAdapterRespDto>();
        errorList = this.validate((List<SaleCalculateImportDto>)saleCalculateImportDtos, itemMap);
        if (CollectionUtil.isNotEmpty(errorList)) {
            respDto.setErrorDetails(errorList);
            return;
        }
        this.insert(saleCalculateImportDtos, deptName, null, itemMap);
    }

    private void insert(List<SaleCalculateImportDto> saleCalculateImportDtos, String deptName, OrgAdvRespDto organization, Map<String, ItemExtendAdapterRespDto> itemMap) {
        AddSaleCalculateDto addSaleCalculateDto = new AddSaleCalculateDto();
        SalesPlanDistributionRespDto planConfig = this.planConfig();
        if (Objects.nonNull(planConfig)) {
            addSaleCalculateDto.setPlanPeriod(planConfig.getPlanPeriod() + "");
        }
        addSaleCalculateDto.setDeptCode(saleCalculateImportDtos.get(0).getDeptCode());
        addSaleCalculateDto.setDeptName(deptName);
        addSaleCalculateDto.setOrganizationCode(saleCalculateImportDtos.get(0).getOrgCode());
        addSaleCalculateDto.setOrganizationName(organization.getName());
        addSaleCalculateDto.setPeriod(saleCalculateImportDtos.get(0).getPeriod());
        addSaleCalculateDto.setItems(this.items(saleCalculateImportDtos, itemMap, planConfig));
        RestResponse response = this.saleCalculateApiProxy.add(addSaleCalculateDto);
        if (Objects.isNull(response.getData())) {
            throw new BizException("10009", response.getResultMsg());
        }
    }

    private List<AddSaleCalculateDetailDto> items(List<SaleCalculateImportDto> saleCalculateImportDtos, Map<String, ItemExtendAdapterRespDto> itemMap, SalesPlanDistributionRespDto planConfig) {
        ArrayList items = Lists.newArrayList();
        for (SaleCalculateImportDto saleCalculateImportDto : saleCalculateImportDtos) {
            ItemExtendAdapterRespDto extendAdapterRespDto = itemMap.get(saleCalculateImportDto.getItemCode());
            AddSaleCalculateDetailDto addSaleCalculateDetailDto = new AddSaleCalculateDetailDto();
            addSaleCalculateDetailDto.setItemCode(saleCalculateImportDto.getItemCode());
            addSaleCalculateDetailDto.setItemName(saleCalculateImportDto.getItemName());
            addSaleCalculateDetailDto.setSkuCode(saleCalculateImportDto.getItemCode());
            addSaleCalculateDetailDto.setSkuName(saleCalculateImportDto.getItemName());
            addSaleCalculateDetailDto.setExFactoryPrice(extendAdapterRespDto.getExFactoryPrice());
            addSaleCalculateDetailDto.setUnit(extendAdapterRespDto.getUnitId());
            addSaleCalculateDetailDto.setSaleCalculateNumber(saleCalculateImportDto.getSaleCalculateNumber());
            addSaleCalculateDetailDto.setFreeCalculateNumber(saleCalculateImportDto.getFreeCalculateNumber());
            if (Objects.nonNull(saleCalculateImportDto.getFreeCalculateNumber())) {
                addSaleCalculateDetailDto.setTotalCalculateNumber(saleCalculateImportDto.getFreeCalculateNumber().add(saleCalculateImportDto.getSaleCalculateNumber()));
            } else {
                addSaleCalculateDetailDto.setTotalCalculateNumber(saleCalculateImportDto.getSaleCalculateNumber());
            }
            if (Objects.nonNull(extendAdapterRespDto.getVolume())) {
                addSaleCalculateDetailDto.setVolume(extendAdapterRespDto.getVolume().multiply(addSaleCalculateDetailDto.getTotalCalculateNumber()));
            }
            if (Objects.nonNull(extendAdapterRespDto.getQuantity())) {
                addSaleCalculateDetailDto.setWeight(extendAdapterRespDto.getQuantity().multiply(addSaleCalculateDetailDto.getTotalCalculateNumber()));
            }
            if (Objects.nonNull(extendAdapterRespDto.getExFactoryPrice())) {
                addSaleCalculateDetailDto.setAmount(extendAdapterRespDto.getExFactoryPrice().multiply(addSaleCalculateDetailDto.getTotalCalculateNumber()));
            }
            this.planNum(addSaleCalculateDetailDto, planConfig, saleCalculateImportDto.getPeriod());
        }
        return items;
    }

    private List<SaleCalculateImportDto> validate(List<SaleCalculateImportDto> saleCalculateImportDtos, String deptName) {
        if (StringUtils.isEmpty((CharSequence)saleCalculateImportDtos.get(0).getDeptCode())) {
            return null;
        }
        if (Objects.isNull(deptName)) {
            saleCalculateImportDtos.stream().forEach(e -> e.setErrorMsg("\u90e8\u95e8\u7f16\u7801\u4e0d\u5b58\u5728"));
            return saleCalculateImportDtos;
        }
        return null;
    }

    private List<SaleCalculateImportDto> validate(List<SaleCalculateImportDto> saleCalculateImportDtos, OrgAdvRespDto organization) {
        if (Objects.isNull(organization)) {
            saleCalculateImportDtos.stream().forEach(e -> e.setErrorMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728"));
            return saleCalculateImportDtos;
        }
        return null;
    }

    private List<SaleCalculateImportDto> validate(List<SaleCalculateImportDto> saleCalculateImportDtos) {
        List<SaleCalculateImportDto> errorList = saleCalculateImportDtos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            return errorList;
        }
        long resultNum = saleCalculateImportDtos.stream().map(SaleCalculateImportDto::getOrgCode).distinct().count();
        if (resultNum > 1L) {
            saleCalculateImportDtos.stream().forEach(e -> e.setErrorMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u552f\u4e00"));
            errorList.addAll(saleCalculateImportDtos);
            return errorList;
        }
        resultNum = saleCalculateImportDtos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getDeptCode())).map(SaleCalculateImportDto::getDeptCode).distinct().count();
        if (resultNum > 0L && resultNum != (long)saleCalculateImportDtos.size()) {
            saleCalculateImportDtos.stream().forEach(e -> e.setErrorMsg("\u90e8\u95e8\u7f16\u7801\u4e0d\u552f\u4e00"));
            errorList.addAll(saleCalculateImportDtos);
            return errorList;
        }
        resultNum = saleCalculateImportDtos.stream().map(SaleCalculateImportDto::getPeriod).distinct().count();
        if (resultNum > 1L) {
            saleCalculateImportDtos.stream().forEach(e -> e.setErrorMsg("\u9700\u6c42\u5468\u671f\u4e0d\u552f\u4e00"));
            errorList.addAll(saleCalculateImportDtos);
            return errorList;
        }
        return errorList;
    }

    private OrgAdvRespDto organization(String orgCode) {
        return null;
    }

    private String dept(String deptCode) {
        return null;
    }

    private List<SaleCalculateImportDto> validate(List<SaleCalculateImportDto> dtos, Map<String, ItemExtendAdapterRespDto> adapterRespDtoMap) {
        List itemCodes = dtos.stream().map(SaleCalculateImportDto::getItemCode).collect(Collectors.toList());
        ItemExtendAdapterReqDto extendAdapterReqDto = new ItemExtendAdapterReqDto();
        extendAdapterReqDto.setItemCodeList(itemCodes);
        List respDtoList = (List)this.itemExtendAdapterQueryApi.queryParam(extendAdapterReqDto).getData();
        if (CollectionUtil.isEmpty((Collection)respDtoList)) {
            dtos.forEach(e -> e.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728"));
            return dtos;
        }
        ArrayList errorList = Lists.newArrayList();
        adapterRespDtoMap.putAll(respDtoList.stream().collect(Collectors.toMap(ItemExtendAdapterRespDto::getItemCode, Function.identity(), (key1, key2) -> key2)));
        dtos.forEach(e -> {
            if (Objects.isNull(adapterRespDtoMap.get(e.getItemCode()))) {
                e.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                errorList.add(e);
            }
        });
        return errorList;
    }

    private void planNum(AddSaleCalculateDetailDto addSaleCalculateDetailDto, SalesPlanDistributionRespDto planConfig, String period) {
        Map<String, SaleCountTotalRespDto> countTotalRespDtoMap = this.mapSaleCountTotalRespDto(addSaleCalculateDetailDto, planConfig, period);
        SaleCountTotalRespDto totalRespDto = countTotalRespDtoMap.get(addSaleCalculateDetailDto.getSkuCode());
        if (Objects.isNull(totalRespDto)) {
            return;
        }
        addSaleCalculateDetailDto.setPreOneNumber(totalRespDto.getN1plan());
        addSaleCalculateDetailDto.setPreTwoNumber(totalRespDto.getN2plan());
        addSaleCalculateDetailDto.setPreThreeNumber(totalRespDto.getN3plan());
    }

    private Map<String, SaleCountTotalRespDto> mapSaleCountTotalRespDto(AddSaleCalculateDetailDto addSaleCalculateDetailDto, SalesPlanDistributionRespDto planConfig, String period) {
        RestResponse response = this.saleCountReportQueryApiProxy.querySaleTotalNum(SaleCountTotalQueryReqDto.builder().skuCodeList((List)Lists.newArrayList((Object[])new String[]{addSaleCalculateDetailDto.getItemCode()})).cycleType(Integer.valueOf(planConfig.getPlanPeriod())).supplyCycle(period).organizationCodeList((List)Lists.newArrayList((Object[])new String[]{addSaleCalculateDetailDto.getOrganizationCode()})).build());
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.toMap(SaleCountTotalRespDto::getSkuCode, Function.identity()));
    }

    private SalesPlanDistributionRespDto planConfig() {
        SalesPlanDistributionReqDto salesPlanDistributionReqDto = new SalesPlanDistributionReqDto();
        return (SalesPlanDistributionRespDto)this.planConfigApiProxy.getSalePlanDetail(salesPlanDistributionReqDto).getData();
    }
}

