/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class StringFieldTrimmer {
    public static <T> void trimStringsInList(List<T> list, Class<T> clazz) {
        for (T obj : list) {
            if (obj == null) continue;
            if (!clazz.isInstance(obj)) {
                throw new IllegalArgumentException("List contains element not of type " + clazz.getName());
            }
            for (Class<?> currentClass = obj.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = currentClass.getDeclaredFields()) {
                    if (field.getType() != String.class || Modifier.isStatic(field.getModifiers())) continue;
                    try {
                        String trimmedValue;
                        field.setAccessible(true);
                        String value = (String)field.get(obj);
                        if (value == null || (trimmedValue = value.trim()).equals(value)) continue;
                        field.set(obj, trimmedValue);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

