/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IItemSkuDgApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.itembiz.ItemSkuGiftBatchDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportItemGiftModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_item_gift_import")
public class ItemGiftCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ItemGiftCommonServiceImpl.class);
    private static final String enable = "\u542f\u7528";
    private static final String disEnable = "\u7981\u7528";
    @Resource
    private IItemSkuDgApi itemSkuDgApi;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportItemGiftModeDto.class);
        Map<String, Object> itemSkuDgDtoMap = new HashMap<String, DgItemSkuDetailRespDto>();
        ArrayList<ImportItemGiftModeDto> passList = new ArrayList<ImportItemGiftModeDto>();
        List skuCodeList = list.stream().map(ImportItemGiftModeDto::getSkuCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeList)) {
            ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
            skuReqDto.setSkuCodes(skuCodeList);
            List skuDetailRespDtos = (List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData();
            itemSkuDgDtoMap = skuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k2));
        }
        HashSet<String> skuCodes = new HashSet<String>();
        for (ImportItemGiftModeDto dto : list) {
            Boolean billVerify = this.unitVerify(dto, itemSkuDgDtoMap, skuCodes);
            if (!billVerify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList<ItemSkuGiftBatchDgReqDto> reqDtos = new ArrayList<ItemSkuGiftBatchDgReqDto>();
        for (ImportItemGiftModeDto importItemGiftModeDto : passList) {
            ItemSkuGiftBatchDgReqDto reqDto = new ItemSkuGiftBatchDgReqDto();
            reqDto.setSkuCode(importItemGiftModeDto.getSkuCode());
            Integer status = Objects.equals(disEnable, importItemGiftModeDto.getGiftStatus()) ? 0 : 1;
            reqDto.setStatus(status);
            reqDtos.add(reqDto);
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u8d60\u54c1,\u6570\u91cf\u4e3a:{}", (Object)reqDtos.size());
        this.itemSkuDgApi.addGiftImport(reqDtos);
    }

    private Boolean unitVerify(ImportItemGiftModeDto dto, Map<String, DgItemSkuDetailRespDto> itemSkuDgDtoMap, Set<String> skuCodes) {
        if (skuCodes.contains(dto.getSkuCode())) {
            dto.setErrorMsg("\u5546\u54c1\u7f16\u7801\u5df2\u6dfb\u52a0\u81f3\u5217\u8868");
            return false;
        }
        DgItemSkuDetailRespDto skuDgDto = itemSkuDgDtoMap.get(dto.getSkuCode());
        if (Objects.isNull(skuDgDto)) {
            dto.setErrorMsg("\u5546\u54c1\u4e0d\u5728\u5b58\u5728");
            return false;
        }
        if (skuDgDto.getSubStatus() != 1) {
            dto.setErrorMsg("\u8be5\u5546\u54c1\u76ee\u524d\u5df2\u7981\u7528");
            return false;
        }
        skuCodes.add(dto.getSkuCode());
        return true;
    }
}

