/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import com.wh.center.data.api.dto.request.MatchByNameOrAliasReqDto;
import com.wh.center.data.api.dto.response.AreaMatchRespDto;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.dto.response.AreaTreeRespExtDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.customer.dto.entity.LogisticsArchivesDto;
import com.yunxi.dg.base.center.customer.dto.entity.LogisticsArchivesPageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.entity.ILogisticsArchivesApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.openapi.dto.txt.TxtAdderssRespDto;
import com.yunxi.dg.base.center.openapi.dto.txt.TxtAdderssResqDto;
import com.yunxi.dg.base.center.openapi.proxy.txt.ITxtResolutionApiProxy;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyQueryReqDto;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.proxy.statemachine.IDgB2CSaleStatemachineApiProxy;
import com.yunxi.dg.base.commons.rpc.data.limit.customer.api.tob.query.IDgEmployeeManageShopQueryAuthApi;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.utils.StringFieldTrimmer;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportPerformOrderInfoDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportPerformOrderReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_perform_order")
public class PerformOrderOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(PerformOrderOperationCommonServiceImpl.class);
    @Autowired
    private IDictQueryApiProxy dictQueryApiProxy;
    @Autowired
    private IDgCsShipmentEnterpriseQueryApiProxy shipmentEnterpriseQueryApiProxy;
    @Autowired
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Autowired
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Autowired
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Autowired
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Autowired
    private IDgB2CSaleStatemachineApiProxy b2CSaleStatemachineApiProxy;
    @Resource
    private IDgInventorySupplyStrategyQueryApiProxy inventorySupplyStrategyQueryApiProxy;
    @Resource
    private IDgEmployeeManageShopQueryAuthApi iDgEmployeeManageShopQueryAuthApi;
    @Resource
    private ITxtResolutionApiProxy txtResolutionApiProxy;
    @Resource
    private ILogisticsArchivesApiProxy logisticsArchivesApiProxy;
    public static Map<String, String> areaNameDataMap = new ConcurrentHashMap<String, String>();
    public static Map<String, String> areaNameAliasMap = new ConcurrentHashMap<String, String>();
    public static final String BIZ_MODEL = "INVOICE_ORDER";

    @Scheduled(cron="0 0/5 * * * ?")
    public void removeCache() {
        log.info("\u6e05\u7406\u5bfc\u5165\u53d1\u8d27\u5355\u529f\u80fd\u7684\u884c\u653f\u533a\u57df\u7f13\u5b58");
        areaNameDataMap.clear();
        areaNameAliasMap.clear();
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5bfc\u5165\u53d1\u8d27\u5355\uff0c\u6821\u9a8c\u53d1\u8d27\u5355\u6570\u636e");
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), ImportPerformOrderInfoDto.class);
        StringFieldTrimmer.trimStringsInList(importDtoList, ImportPerformOrderInfoDto.class);
        HashSet skuCodes = Sets.newHashSetWithExpectedSize((int)result.getList().size());
        HashSet warehouseCodes = Sets.newHashSetWithExpectedSize((int)result.getList().size());
        HashSet warehouseNames = Sets.newHashSetWithExpectedSize((int)result.getList().size());
        HashSet logisticTypeNames = Sets.newHashSetWithExpectedSize((int)result.getList().size());
        ArrayList<AreaNameReqDto> provinces = new ArrayList<AreaNameReqDto>();
        importDtoList.forEach(item -> {
            skuCodes.add(item.getSkuCode());
            if (StringUtils.isNotBlank((CharSequence)item.getWarehouseCode())) {
                warehouseCodes.add(item.getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getWarehouseName())) {
                warehouseNames.add(item.getWarehouseName());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getLogisticsType())) {
                logisticTypeNames.add(item.getLogisticsType());
            }
            if (StringUtils.isBlank((CharSequence)item.getIsGift())) {
                item.setIsGift("\u5426");
            }
            if (StringUtils.isBlank((CharSequence)item.getOrderType())) {
                item.setOrderType("\u666e\u901a");
            }
            if (StringUtils.isBlank((CharSequence)item.getBizType())) {
                item.setBizType("\u666e\u901a\u8ba2\u5355");
            }
            AreaNameReqDto province = this.addAreaNameReq(provinces, 0, item.getProvince());
            AreaNameReqDto city = this.addAreaNameReq(province.getChildren(), 1, item.getCity());
            this.addAreaNameReq(city.getChildren(), 2, item.getCounty());
        });
        Map<String, String> bizMap = this.getDict("sales_outbound");
        Map<String, String> orderMap = this.getDict("toC_order_type");
        Map<String, List<LogicWarehouseRespDto>> warehouseByNameMap = this.getWarehouseByName(warehouseNames);
        Map<String, List<LogicWarehouseRespDto>> warehouseByCodeMap = this.getWarehouseByCode(warehouseCodes);
        Set<String> shopCodeSet = importDtoList.stream().map(ImportPerformOrderInfoDto::getShopCode).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        Map<String, List<String>> shopWarehouseMap = this.getShopWarehouse(shopCodeSet);
        Map<String, DgCsShipmentEnterpriseRespDto> shipmentEnterpriseMap = this.getShipmentEnterprise();
        Map<String, DgShopRespDto> shopMap = this.getShop();
        Map<String, DgItemSkuPageRespDto> itemSkuMap = this.getItemSku(ListUtil.toList((Collection)skuCodes));
        Map<String, LogisticsArchivesDto> logisticsArchivesMap = this.getLogicArchives(ListUtil.toList((Collection)logisticTypeNames));
        AreaMatchRespDto areaMatch = this.processAreaNameCodeMap(provinces);
        HashMap rowDepulication = new HashMap(importDtoList.size());
        List shopCodesByEmployee = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgEmployeeManageShopQueryAuthApi.queryListShopCodesByEmployeeOrUserByUserId())).orElse(Lists.newArrayList());
        HashMap<String, TxtAdderssRespDto> adderssMap = new HashMap<String, TxtAdderssRespDto>(importDtoList.size());
        for (ImportPerformOrderInfoDto dto2 : importDtoList) {
            String province = dto2.getProvince();
            String receivePhone = dto2.getReceivePhone();
            if (!StrUtil.hasBlank((CharSequence[])new CharSequence[]{province, receivePhone})) continue;
            String receiveAddress = dto2.getReceiveAddress();
            String platformOrderNo = dto2.getPlatformOrderNo();
            this.addressResolution(adderssMap, platformOrderNo, receiveAddress);
            dto2.setProvince(StrUtil.blankToDefault((CharSequence)dto2.getProvince(), (String)"_"));
            dto2.setCity(StrUtil.blankToDefault((CharSequence)dto2.getCity(), (String)"_"));
            dto2.setCounty(StrUtil.blankToDefault((CharSequence)dto2.getCounty(), (String)"_"));
            TxtAdderssRespDto txtAdderssRespDto = (TxtAdderssRespDto)adderssMap.get(platformOrderNo);
            if (Objects.isNull(txtAdderssRespDto)) {
                this.setErrorMsg(dto2, "\u6536\u8d27\u5730\u5740\u65e0\u6cd5\u89e3\u6790");
                continue;
            }
            dto2.setProvince(txtAdderssRespDto.getProvince());
            dto2.setCity(txtAdderssRespDto.getCity());
            dto2.setCounty(txtAdderssRespDto.getCounty());
            dto2.setDistrict(txtAdderssRespDto.getTown());
            dto2.setReceiveName(StrUtil.blankToDefault((CharSequence)txtAdderssRespDto.getPerson(), (String)dto2.getReceiveName()));
            dto2.setReceivePhone(StrUtil.blankToDefault((CharSequence)txtAdderssRespDto.getPhone(), (String)dto2.getReceivePhone()));
            dto2.setReceiveAddress(StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{txtAdderssRespDto.getTown(), txtAdderssRespDto.getDetail()}));
        }
        ArrayList passList = new ArrayList(result.getList().size());
        importDtoList.forEach(dto -> {
            List logicWarehouseRespDtoList;
            String bizType;
            String orderType;
            boolean amountIsNullOrLtZero;
            DgItemSkuPageRespDto dgItemSkuPageRespDto;
            DgShopRespDto dgShopRespDto = (DgShopRespDto)shopMap.get(dto.getShopCode());
            if (Objects.isNull(dgShopRespDto)) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u5e97\u94fa\u4e0d\u5b58\u5728");
            }
            if (Objects.nonNull(dgShopRespDto) && this.shopEmployee(shopCodesByEmployee) && !shopCodesByEmployee.contains(dgShopRespDto.getStoreCode())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, String.format("\u7ba1\u8f96\u5e97\u94fa\u672a\u5339\u914d\u5230 %s %s ", dgShopRespDto.getStoreCode(), dgShopRespDto.getStoreName()));
            }
            AreaNodeDto province = areaMatch.matchAndSet(null, 0, () -> ((ImportPerformOrderInfoDto)dto).getProvince(), arg_0 -> ((ImportPerformOrderInfoDto)dto).setProvince(arg_0));
            if (province == null || StringUtils.isBlank((CharSequence)province.getCode())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u7701\u4e0d\u5b58\u5728");
            }
            AreaNodeDto city = areaMatch.matchAndSet(province, 1, () -> ((ImportPerformOrderInfoDto)dto).getCity(), arg_0 -> ((ImportPerformOrderInfoDto)dto).setCity(arg_0));
            if (city == null || StringUtils.isBlank((CharSequence)city.getCode())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u5e02\u4e0d\u5b58\u5728");
            }
            AreaNodeDto county = areaMatch.matchAndSet(city, 2, () -> ((ImportPerformOrderInfoDto)dto).getCounty(), arg_0 -> ((ImportPerformOrderInfoDto)dto).setCounty(arg_0));
            if (county == null || StringUtils.isBlank((CharSequence)county.getCode())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u533a\u4e0d\u5b58\u5728");
            }
            if (StrUtil.isBlank((CharSequence)dto.getReceivePhone())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6536\u8d27\u7535\u8bdd\u4e0d\u5b58\u5728");
            }
            if (StrUtil.isBlank((CharSequence)dto.getReceiveName())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6536\u8d27\u4eba\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(dgItemSkuPageRespDto = (DgItemSkuPageRespDto)itemSkuMap.get(dto.getSkuCode()))) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u5546\u54c1\u4e0d\u5b58\u5728");
            } else if ("\u662f".equals(dto.getIsGift()) && !Objects.equals(1, dgItemSkuPageRespDto.getIsGift())) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u5546\u54c1\u4e0d\u662f\u8d60\u54c1");
            }
            boolean isNoGift = "\u5426".equals(dto.getIsGift()) || StrUtil.isBlank((CharSequence)dto.getIsGift());
            boolean bl = amountIsNullOrLtZero = StrUtil.isBlank((CharSequence)dto.getAmount()) || new BigDecimal(dto.getAmount()).compareTo(BigDecimal.ZERO) <= 0;
            if (isNoGift && amountIsNullOrLtZero) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u975e\u8d60\u54c1\u5546\u54c1\u6210\u4ea4\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (Objects.isNull(orderType = (String)orderMap.get(dto.getOrderType()))) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u8ba2\u5355\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(bizType = (String)bizMap.get(dto.getBizType()))) {
                this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            LogicWarehouseRespDto logicWarehouseRespDto = null;
            if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)dto.getWarehouseName())) {
                logicWarehouseRespDtoList = (List)warehouseByCodeMap.get(dto.getWarehouseCode());
                if (CollectionUtil.isEmpty((Collection)logicWarehouseRespDtoList)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                } else if (logicWarehouseRespDtoList.size() > 1) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6307\u5b9a\u4ed3\u5e93\u7f16\u7801\u4e0d\u552f\u4e00");
                } else if (!((LogicWarehouseRespDto)logicWarehouseRespDtoList.get(0)).getWarehouseName().equals(dto.getWarehouseName())) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6307\u5b9a\u4ed3\u5e93\u7f16\u7801\u4e0e\u6307\u5b9a\u4ed3\u5e93\u540d\u79f0\u4e0d\u4e00\u81f4");
                } else {
                    logicWarehouseRespDto = (LogicWarehouseRespDto)logicWarehouseRespDtoList.get(0);
                }
            } else if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode())) {
                logicWarehouseRespDtoList = (List)warehouseByCodeMap.get(dto.getWarehouseCode());
                if (CollectionUtil.isEmpty((Collection)logicWarehouseRespDtoList)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                } else if (logicWarehouseRespDtoList.size() > 1) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6307\u5b9a\u4ed3\u5e93\u7f16\u7801\u4e0d\u552f\u4e00");
                } else {
                    logicWarehouseRespDto = (LogicWarehouseRespDto)logicWarehouseRespDtoList.get(0);
                }
            } else if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseName())) {
                logicWarehouseRespDtoList = (List)warehouseByNameMap.get(dto.getWarehouseName());
                if (CollectionUtil.isEmpty((Collection)logicWarehouseRespDtoList)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                } else if (logicWarehouseRespDtoList.size() > 1) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u6307\u5b9a\u4ed3\u5e93\u540d\u79f0\u4e0d\u552f\u4e00");
                } else {
                    logicWarehouseRespDto = (LogicWarehouseRespDto)logicWarehouseRespDtoList.get(0);
                }
            }
            if (Objects.nonNull(logicWarehouseRespDto)) {
                String warehouseProperty;
                List shopWarehouseList = Optional.ofNullable(shopWarehouseMap.get(dto.getShopCode())).orElse(Lists.newArrayList());
                if (CollUtil.isEmpty((Collection)shopWarehouseList)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u5e97\u94fa\u672a\u914d\u7f6e\u4f9b\u8d27\u4ed3");
                }
                if (!shopWarehouseList.contains(logicWarehouseRespDto.getWarehouseCode())) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, String.format("\u5e97\u94fa\u672a\u914d\u7f6e\u4f9b\u8d27\u4ed3:%s", logicWarehouseRespDto.getWarehouseName()));
                }
                if (StrUtil.equals((CharSequence)(warehouseProperty = logicWarehouseRespDto.getWarehouseProperty()), (CharSequence)"consignment")) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, String.format("\u4f9b\u8d27\u4ed3:%s \u4e3a\u5bc4\u552e\u4ed3\uff0c\u9700\u66f4\u6362\u4e3a\u975e\u5bc4\u552e\u4ed3", logicWarehouseRespDto.getWarehouseName()));
                }
            }
            DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = null;
            LogisticsArchivesDto logisticsArchivesDto = null;
            if (StringUtils.isNotBlank((CharSequence)dto.getLogisticsCompany())) {
                dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)shipmentEnterpriseMap.get(dto.getLogisticsCompany());
                if (Objects.isNull(dgCsShipmentEnterpriseRespDto)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728");
                } else if (CollUtil.isEmpty((Collection)dgCsShipmentEnterpriseRespDto.getLogisticsTypeList())) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u7269\u6d41\u516c\u53f8\u7684\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((CharSequence)dto.getLogisticsType())) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u627f\u8fd0\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    boolean isValidLogisticsType;
                    logisticsArchivesDto = (LogisticsArchivesDto)logisticsArchivesMap.get(dto.getLogisticsType());
                    if (Objects.isNull(logisticsArchivesDto)) {
                        this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728");
                    } else if (Objects.nonNull(dgCsShipmentEnterpriseRespDto) && CollUtil.isNotEmpty((Collection)dgCsShipmentEnterpriseRespDto.getLogisticsTypeList()) && !(isValidLogisticsType = dgCsShipmentEnterpriseRespDto.getLogisticsTypeList().contains(logisticsArchivesDto.getLogisticsCode()))) {
                        this.setErrorMsg((ImportPerformOrderInfoDto)dto, "\u7269\u6d41\u516c\u53f8\u7684\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728");
                    }
                }
            } else {
                dto.setLogisticsType(null);
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getPlatformOrderNo()) && StringUtils.isNotBlank((CharSequence)dto.getSkuCode())) {
                String key = dto.getPlatformOrderNo() + ":" + dto.getSkuCode();
                Integer row = (Integer)rowDepulication.get(key);
                if (Objects.nonNull(row)) {
                    this.setErrorMsg((ImportPerformOrderInfoDto)dto, String.format("\uff08\u5355\u53f7+sku\uff09\u4e0e\u7b2c%s\u884c\u91cd\u590d", row));
                } else {
                    rowDepulication.put(key, dto.getRowNum());
                }
            }
            if (StringUtils.isBlank((CharSequence)dto.getErrorMsg())) {
                dto.setDgOrderType(orderType);
                dto.setDgBizType(bizType);
                if (Objects.nonNull(logicWarehouseRespDto)) {
                    dto.setDeliveryLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
                    dto.setLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
                    dto.setLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
                    dto.setLogicalWarehouseId(logicWarehouseRespDto.getId());
                }
                if (Objects.nonNull(dgCsShipmentEnterpriseRespDto)) {
                    dto.setShipmentEnterpriseCode(dgCsShipmentEnterpriseRespDto.getCode());
                    dto.setShipmentEnterpriseName(dgCsShipmentEnterpriseRespDto.getName());
                    dto.setShipmentEnterpriseId(dgCsShipmentEnterpriseRespDto.getId());
                    dto.setTransportStyle(dgCsShipmentEnterpriseRespDto.getType());
                }
                if (Objects.nonNull(logisticsArchivesDto)) {
                    dto.setPlanTransportTypeCode(logisticsArchivesDto.getLogisticsCode());
                    dto.setPlanTransportTypeName(logisticsArchivesDto.getLogisticsName());
                }
                if (Objects.nonNull(dgShopRespDto)) {
                    dto.setChannelId(dgShopRespDto.getChannelId());
                    dto.setChannelCode(dgShopRespDto.getChannelCode());
                    dto.setChannelName(dgShopRespDto.getChannelName());
                    dto.setHsCustomerCode(dgShopRespDto.getCustomerCode());
                    dto.setHsCustomerName(dgShopRespDto.getCustomerName());
                    dto.setHsCustomerId(dgShopRespDto.getCustomerId());
                    dto.setDgShopCode(dgShopRespDto.getStoreCode());
                    dto.setDgShopName(dgShopRespDto.getStoreName());
                    dto.setShopId(dgShopRespDto.getId());
                    dto.setSiteId(dgShopRespDto.getChannelId());
                    dto.setSiteCode(dgShopRespDto.getChannelCode());
                    dto.setSiteName(dgShopRespDto.getChannelName());
                }
                dto.setProvinceCode(province == null ? null : province.getCode());
                dto.setCityCode(city == null ? null : city.getCode());
                dto.setCountyCode(county == null ? null : county.getCode());
                ImportPerformOrderReqDto.DgPerformOrderItemReqDto itemDto = PerformOrderOperationCommonServiceImpl.getDgPerformOrderItemReqDto(dto, dgItemSkuPageRespDto);
                dto.setItemDto(itemDto);
                passList.add(dto);
            } else {
                respDto.getErrorDetails().add(dto);
            }
        });
        log.info("\u5bfc\u5165\u53d1\u8d27\u5355\uff0c\u6821\u9a8c\u53d1\u8d27\u5355\u6570\u636e\uff0cpassList :{}", (Object)passList.size());
        return passList;
    }

    private AreaNameReqDto addAreaNameReq(List<AreaNameReqDto> list, int levelId, String name) {
        String finalName = Optional.ofNullable(name).orElse("");
        AreaNameReqDto req = list.stream().filter(s -> s.getLevelId().equals(levelId) && finalName.equals(s.getName())).findFirst().orElse(null);
        if (req != null) {
            return req;
        }
        req = new AreaNameReqDto();
        req.setLevelId(Integer.valueOf(levelId));
        req.setName(finalName);
        req.setChildren(new ArrayList());
        list.add(req);
        return req;
    }

    private AreaMatchRespDto processAreaNameCodeMap(List<AreaNameReqDto> provinces) {
        MatchByNameOrAliasReqDto req = new MatchByNameOrAliasReqDto();
        req.setProvinces(provinces);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u53c2\u6570\uff1a{}", JSON.toJSON((Object)req));
        RestResponse resp = this.areaExtQueryApiProxy.matchByNameOrAlias(req);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)resp));
        AreaMatchRespDto areaMatch = (AreaMatchRespDto)RestResponseHelper.extractData((RestResponse)resp);
        areaMatch.process();
        return areaMatch;
    }

    private Map<String, LogisticsArchivesDto> getLogicArchives(List<String> names) {
        LogisticsArchivesPageReqDto reqDto = new LogisticsArchivesPageReqDto();
        reqDto.setLogisticsNameList(names);
        List logisticsArchivesDtos = (List)RestResponseHelper.extractData((RestResponse)this.logisticsArchivesApiProxy.queryList(reqDto));
        if (CollectionUtil.isEmpty((Collection)logisticsArchivesDtos)) {
            return MapUtil.empty();
        }
        return logisticsArchivesDtos.stream().collect(Collectors.toMap(LogisticsArchivesDto::getLogisticsName, Function.identity(), (v1, v2) -> v2));
    }

    @NotNull
    private static ImportPerformOrderReqDto.DgPerformOrderItemReqDto getDgPerformOrderItemReqDto(ImportPerformOrderInfoDto dto, DgItemSkuPageRespDto dgItemSkuPageRespDto) {
        ImportPerformOrderReqDto.DgPerformOrderItemReqDto itemDto = new ImportPerformOrderReqDto.DgPerformOrderItemReqDto();
        itemDto.setDiscountAmount(BigDecimal.ZERO);
        itemDto.setImgUrl(CollectionUtil.isEmpty((Collection)dgItemSkuPageRespDto.getImgUrlList()) ? "" : ((ItemMediasDgRespDto)dgItemSkuPageRespDto.getImgUrlList().get(0)).getPath1());
        itemDto.setItemBackCategoryOneCode(dgItemSkuPageRespDto.getDirCode());
        itemDto.setItemBackCategoryOneName(dgItemSkuPageRespDto.getDirName());
        itemDto.setItemCode(dgItemSkuPageRespDto.getItemCode());
        itemDto.setItemName(dgItemSkuPageRespDto.getItemName());
        itemDto.setItemId(dgItemSkuPageRespDto.getItemId());
        itemDto.setItemNum(new BigDecimal(dto.getSkuNum()));
        itemDto.setPayAmount(new BigDecimal(dto.getAmount()));
        itemDto.setRealPayAmount(itemDto.getPayAmount());
        itemDto.setSalePrice(dgItemSkuPageRespDto.getSalePrice());
        itemDto.setPrice(itemDto.getSalePrice());
        itemDto.setSkuId(dgItemSkuPageRespDto.getId());
        itemDto.setSkuCode(dgItemSkuPageRespDto.getSkuCode());
        itemDto.setSkuName(dgItemSkuPageRespDto.getSkuName());
        itemDto.setType("1");
        if ("\u662f".equals(dto.getIsGift())) {
            itemDto.setGiftType(Integer.valueOf(3));
            itemDto.setGift(Integer.valueOf(1));
            itemDto.setDiscountAmount(BigDecimalUtils.multiply((BigDecimal)itemDto.getItemNum(), (BigDecimal)dgItemSkuPageRespDto.getRetailPrice()));
        } else {
            BigDecimal discountAmount = BigDecimalUtils.multiply((BigDecimal)itemDto.getItemNum(), (BigDecimal)dgItemSkuPageRespDto.getRetailPrice()).subtract(itemDto.getPayAmount());
            discountAmount = discountAmount.setScale(2, RoundingMode.HALF_UP);
            itemDto.setDiscountAmount(discountAmount);
        }
        return itemDto;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5bfc\u5165\u53d1\u8d27\u5355\uff0ccallBackImportFileOperationCommonSync");
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u5bfc\u5165\u53d1\u8d27\u5355:{}", (Object)JSON.toJSONString((Object)passList));
        Map<String, List<ImportPerformOrderInfoDto>> giftMap = passList.stream().filter(a -> Objects.equals(1, a.getItemDto().getGift())).collect(Collectors.groupingBy(ImportPerformOrderInfoDto::getPlatformOrderNo));
        Map<String, List<ImportPerformOrderInfoDto>> itemMap = passList.stream().filter(a -> !Objects.equals(1, a.getItemDto().getGift())).collect(Collectors.groupingBy(ImportPerformOrderInfoDto::getPlatformOrderNo));
        itemMap.forEach((k, v) -> {
            if (giftMap.containsKey(k)) {
                v.addAll((Collection)giftMap.get(k));
                giftMap.remove(k);
            }
        });
        itemMap.forEach((k, v) -> {
            ImportPerformOrderInfoDto dto = (ImportPerformOrderInfoDto)v.get(0);
            DgBizPerformOrderReqDto reqDto = this.assembleOrder((String)k, dto);
            List<DgPerformOrderItemReqDto> itemList = PerformOrderOperationCommonServiceImpl.getItemList(v);
            reqDto.setItemList(itemList);
            if (giftMap.containsKey(k)) {
                List<DgPerformOrderItemReqDto> giftList = PerformOrderOperationCommonServiceImpl.getItemList(v);
                reqDto.setGiftList(giftList);
                giftMap.remove(k);
            }
            this.saveOrder(respDto, reqDto, dto);
        });
        giftMap.forEach((k, v) -> {
            ImportPerformOrderInfoDto dto = (ImportPerformOrderInfoDto)v.get(0);
            DgBizPerformOrderReqDto reqDto = this.assembleOrder((String)k, dto);
            List<DgPerformOrderItemReqDto> giftList = PerformOrderOperationCommonServiceImpl.getItemList(v);
            reqDto.setGiftList(giftList);
            this.saveOrder(respDto, reqDto, dto);
        });
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (!respDto.getErrorDetails().isEmpty()) {
            Object o = ServiceContext.getContext().get(BIZ_MODEL);
            respDto.setStatus(Objects.isNull(o) ? FileOperationStatusEnum.IMPORT_ERROR.getCode() : FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
    }

    private static List<DgPerformOrderItemReqDto> getItemList(List<ImportPerformOrderInfoDto> importdtos) {
        ArrayList<DgPerformOrderItemReqDto> itemList = new ArrayList<DgPerformOrderItemReqDto>(importdtos.size());
        importdtos.forEach(dto -> {
            ImportPerformOrderReqDto.DgPerformOrderItemReqDto item = dto.getItemDto();
            DgPerformOrderItemReqDto itemReqDto = new DgPerformOrderItemReqDto();
            itemReqDto.setDiscountAmount(item.getDiscountAmount());
            itemReqDto.setImgUrl(item.getImgUrl());
            itemReqDto.setItemBackCategoryOneCode(item.getItemBackCategoryOneCode());
            itemReqDto.setItemBackCategoryOneName(item.getItemBackCategoryOneName());
            itemReqDto.setItemCode(item.getItemCode());
            itemReqDto.setItemId(item.getItemId());
            itemReqDto.setItemName(item.getItemName());
            itemReqDto.setItemNum(item.getItemNum());
            itemReqDto.setPayAmount(item.getPayAmount());
            itemReqDto.setPrice(item.getPrice());
            itemReqDto.setRealPayAmount(item.getRealPayAmount());
            itemReqDto.setSalePrice(item.getSalePrice());
            itemReqDto.setSkuCode(item.getSkuCode());
            itemReqDto.setSkuName(item.getSkuName());
            itemReqDto.setSkuId(item.getSkuId());
            itemReqDto.setType(item.getType());
            itemReqDto.setGift(item.getGift());
            itemReqDto.setGiftType(item.getGiftType());
            DgPerformOrderItemExtensionDto performOrderItemExtensionDto = new DgPerformOrderItemExtensionDto();
            if (StringUtils.isNotBlank((CharSequence)dto.getHsCustomerCode())) {
                performOrderItemExtensionDto.setHsCustomerCode(dto.getHsCustomerCode());
                performOrderItemExtensionDto.setHsCustomerName(dto.getHsCustomerName());
            }
            itemReqDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
            itemList.add(itemReqDto);
        });
        return itemList;
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizPerformOrderReqDto reqDto, ImportPerformOrderInfoDto dto) {
        try {
            reqDto.setOrderSource(Integer.valueOf(5));
            RestResponseHelper.extractData((RestResponse)this.b2CSaleStatemachineApiProxy.createSaleOrder(BIZ_MODEL, reqDto));
            ServiceContext.getContext().set(BIZ_MODEL, (Object)"1");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u53d1\u8d27\u5355\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    private DgBizPerformOrderReqDto assembleOrder(String plateformOrderNo, ImportPerformOrderInfoDto dto) {
        DgBizPerformOrderReqDto reqDto = new DgBizPerformOrderReqDto();
        reqDto.setPlatformOrderNo(plateformOrderNo);
        reqDto.setOrderType(dto.getDgOrderType());
        reqDto.setBizType(dto.getDgBizType());
        reqDto.setDeliveryLogicalWarehouseCode(dto.getDeliveryLogicalWarehouseCode());
        reqDto.setLogicalWarehouseCode(dto.getLogicalWarehouseCode());
        reqDto.setLogicalWarehouseName(dto.getLogicalWarehouseName());
        reqDto.setLogicalWarehouseId(dto.getLogicalWarehouseId());
        reqDto.setShipmentEnterpriseCode(dto.getShipmentEnterpriseCode());
        reqDto.setShipmentEnterpriseName(dto.getShipmentEnterpriseName());
        reqDto.setShipmentEnterpriseId(dto.getShipmentEnterpriseId());
        reqDto.setFreightCost(StringUtils.isBlank((CharSequence)dto.getFreightFee()) ? BigDecimal.ZERO : new BigDecimal(dto.getFreightFee()));
        reqDto.setRemark(dto.getRemark());
        reqDto.setBuyerRemark(dto.getBuyerMsg());
        reqDto.setSellerRemark(dto.getSellerRemark());
        reqDto.setPlatformCreateTime(StringUtils.isBlank((CharSequence)dto.getPlatformOrderTime()) ? new Date() : DateUtil.parse((CharSequence)dto.getPlatformOrderTime(), (DateTimeFormatter)DatePattern.NORM_DATETIME_FORMATTER));
        reqDto.setBizModel(BIZ_MODEL);
        reqDto.setIsManualCreate(Boolean.valueOf(true));
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setOrderSourceModel("INNER");
        reqDto.setPlanTransportTypeCode(dto.getPlanTransportTypeCode());
        reqDto.setPlanTransportTypeName(dto.getPlanTransportTypeName());
        reqDto.setTransportStyle(dto.getTransportStyle());
        DgPerformOrderAddrReqDto orderAddrReqDto = new DgPerformOrderAddrReqDto();
        orderAddrReqDto.setCity(dto.getCity());
        orderAddrReqDto.setCityCode(dto.getCityCode());
        orderAddrReqDto.setProvince(dto.getProvince());
        orderAddrReqDto.setProvinceCode(dto.getProvinceCode());
        orderAddrReqDto.setCounty(dto.getCounty());
        orderAddrReqDto.setCountyCode(dto.getCountyCode());
        orderAddrReqDto.setReceiveName(dto.getReceiveName());
        orderAddrReqDto.setReceivePhone(dto.getReceivePhone());
        orderAddrReqDto.setReceiveAddress(StringUtils.isNotBlank((CharSequence)dto.getDistrict()) ? dto.getDistrict() + dto.getReceiveAddress() : dto.getReceiveAddress());
        reqDto.setOrderAddrReqDto(orderAddrReqDto);
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        if (StringUtils.isNotBlank((CharSequence)dto.getPayTime())) {
            performOrderPaymentDto.setPayTime((Date)DateUtil.parse((CharSequence)dto.getPayTime(), (DateTimeFormatter)DatePattern.NORM_DATETIME_FORMATTER));
        } else {
            performOrderPaymentDto.setPayTime(new Date());
        }
        reqDto.setPerformOrderPaymentDto(performOrderPaymentDto);
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        BeanUtil.copyProperties((Object)dto, (Object)performOrderSnapshotDto, (String[])new String[0]);
        performOrderSnapshotDto.setShopId(dto.getShopId());
        performOrderSnapshotDto.setShopCode(dto.getDgShopCode());
        performOrderSnapshotDto.setShopName(dto.getDgShopName());
        performOrderSnapshotDto.setSiteId(dto.getSiteId());
        performOrderSnapshotDto.setSiteCode(dto.getSiteCode());
        performOrderSnapshotDto.setSiteName(dto.getSiteName());
        reqDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        return reqDto;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private void addressResolution(Map<String, TxtAdderssRespDto> adderssMap, String platformOrderNo, String address) {
        if (adderssMap.containsKey(platformOrderNo)) {
            return;
        }
        try {
            TxtAdderssResqDto resqDto = new TxtAdderssResqDto();
            resqDto.setAddress(address);
            TxtAdderssRespDto txtAdderssRespDto = (TxtAdderssRespDto)RestResponseHelper.extractData((RestResponse)this.txtResolutionApiProxy.addressResolution(resqDto));
            if (Objects.isNull(txtAdderssRespDto) || StrUtil.isBlank((CharSequence)txtAdderssRespDto.getProvince())) {
                return;
            }
            adderssMap.put(platformOrderNo, txtAdderssRespDto);
        }
        catch (Exception e) {
            log.error("\u5730\u5740\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    private Map<String, List<LogicWarehouseRespDto>> getWarehouseByName(Set<String> warehouseNames) {
        if (CollectionUtil.isEmpty(warehouseNames)) {
            return new HashMap<String, List<LogicWarehouseRespDto>>();
        }
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseNames(new ArrayList<String>(warehouseNames));
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setWarehouseStatus("enable");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryData(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseName())).collect(Collectors.groupingBy(LogicWarehouseRespDto::getWarehouseName));
    }

    private Map<String, List<LogicWarehouseRespDto>> getWarehouseByCode(Set<String> warehouseCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return new HashMap<String, List<LogicWarehouseRespDto>>();
        }
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(new ArrayList<String>(warehouseCodes));
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setWarehouseStatus("enable");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryData(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseCode())).collect(Collectors.groupingBy(LogicWarehouseRespDto::getWarehouseCode));
    }

    private Map<String, List<String>> getShopWarehouse(Set<String> shopCodeSet) {
        HashMap shopWarehouseMap = Maps.newHashMap();
        DgInventorySupplyStrategyQueryReqDto reqDto = new DgInventorySupplyStrategyQueryReqDto();
        for (String shopCode : shopCodeSet) {
            reqDto.setShopCode(shopCode);
            List shopWarehouseCode = (List)RestResponseHelper.extractData((RestResponse)this.inventorySupplyStrategyQueryApiProxy.queryDgLogicWarehouseByShopCode(reqDto));
            shopWarehouseMap.put(shopCode, shopWarehouseCode);
        }
        return shopWarehouseMap;
    }

    private void setErrorMsg(ImportPerformOrderInfoDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }

    private Map<String, DgItemSkuPageRespDto> getItemSku(List<String> skuCodes) {
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSubStatus(Integer.valueOf(1));
        reqDto.setSkuCodes(skuCodes);
        reqDto.setPageSize(Integer.valueOf(skuCodes.size()));
        reqDto.setItemAttributeList((List)Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, String> getDict(String code) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(code, code));
        if (Objects.isNull(dictDto) || CollectionUtil.isEmpty((Collection)dictDto.getDictValueList())) {
            return MapUtil.empty();
        }
        return dictDto.getDictValueList().stream().collect(Collectors.toMap(DictValueDto::getLabel, DictValueDto::getValue, (v1, v2) -> v2));
    }

    private Map<String, DgShopRespDto> getShop() {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setLineType(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setSourceType(Integer.valueOf(2));
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{1}));
        List dgShopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.queryListShop(reqDto));
        if (Objects.isNull(dgShopRespDtos) || CollectionUtil.isEmpty((Collection)dgShopRespDtos)) {
            return MapUtil.empty();
        }
        return dgShopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, DgCsShipmentEnterpriseRespDto> getShipmentEnterprise() {
        DgCsShipmentEnterprisePageReqDto reqDto = new DgCsShipmentEnterprisePageReqDto();
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{0}));
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shipmentEnterpriseQueryApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgCsShipmentEnterpriseRespDto::getName, Function.identity(), (v1, v2) -> v2));
    }

    private boolean shopEmployee(List<String> shopCodesByEmployee) {
        return !shopCodesByEmployee.contains("1!=1");
    }

    private String getAreaCodeByName(Map<Integer, Map<String, String>> areaNameCodeMap, int type, Supplier<String> getter, Consumer<String> setter) {
        Map<String, String> map = areaNameCodeMap.get(type);
        if (map == null || getter == null) {
            return "";
        }
        String code = map.get(getter.get());
        if (setter != null) {
            setter.accept(code);
        }
        return code;
    }

    private String getAreaCodeByName(Supplier<String> getter, Consumer<String> setter) {
        String name = Optional.ofNullable(getter.get()).orElse("");
        if (areaNameDataMap.isEmpty()) {
            AreaQueryExtReqDto reqDto = new AreaQueryExtReqDto();
            reqDto.setLevelId(Integer.valueOf(3));
            List areaTreeRespExtDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByTree(reqDto));
            if (CollectionUtil.isEmpty((Collection)areaTreeRespExtDtos)) {
                return null;
            }
            this.getAreaNameMap(areaTreeRespExtDtos);
        }
        String areaCode = "";
        if (areaNameDataMap.containsKey(name)) {
            areaCode = areaNameDataMap.get(name);
        } else {
            String areaName = areaNameAliasMap.get(name);
            if (StringUtils.isNotEmpty((CharSequence)areaName)) {
                areaCode = areaNameDataMap.getOrDefault(areaName, "");
            }
            if (StringUtils.isNotBlank((CharSequence)areaCode)) {
                setter.accept(areaName);
            }
        }
        return areaCode;
    }

    private void getAreaNameMap(List<AreaTreeRespExtDto> areaTreeRespExtDtos) {
        if (CollectionUtil.isEmpty(areaTreeRespExtDtos)) {
            return;
        }
        areaTreeRespExtDtos.forEach(dto -> {
            areaNameDataMap.put(dto.getName(), dto.getCode());
            if (StringUtils.isNotBlank((CharSequence)dto.getAlias())) {
                AssertUtils.isFalse((boolean)areaNameAliasMap.containsKey(dto.getAlias()), (String)("\u884c\u653f\u533a\u57df\u6863\u6848\u522b\u540d\u8bbe\u7f6e\u9519\u8bef-\u522b\u540d\u6709\u91cd\u590d\u6570\u636e" + dto.getAlias()));
                areaNameAliasMap.put(dto.getAlias(), dto.getName());
            }
            this.getAreaNameMap(dto.getChildren());
        });
    }
}

