/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.domain.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.response.AfterSaleOrderRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AfterSaleOrderDomainImpl
extends BaseDomainImpl<AfterSaleOrderEo>
implements IAfterSaleOrderDomain {
    @Resource
    private IAfterSaleOrderDas das;

    public ICommonDas<AfterSaleOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public AfterSaleOrderRespDto queryAfterSaleOrder(String afterSaleOrderNo, List<String> asList) {
        AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().in((Object)"status", asList)).one();
        AfterSaleOrderRespDto respDto = new AfterSaleOrderRespDto();
        BeanUtils.copyProperties((Object)afterSaleOrderEo, (Object)respDto, AfterSaleOrderRespDto.class);
        return respDto;
    }

    @Override
    public List<AfterSaleOrderEo> queryEffectiveListByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u67e5\u8be2\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> status = Arrays.asList(AfterSaleOrderStatusEnum.FINISH.getCode());
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).in((Object)"status", status)).list();
    }

    @Override
    public List<AfterSaleOrderEo> queryEffectiveListBySaleOrderNos(List<String> saleOrderNos) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(saleOrderNos), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNos\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> status = Arrays.asList(AfterSaleOrderStatusEnum.FINISH.getCode());
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"sale_order_no", saleOrderNos)).in((Object)"status", status)).list();
    }

    @Override
    public AfterSaleOrderEo queryEoByAfterSaleOrderNo(String afterSaleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)afterSaleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570afterSaleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return (AfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
    }
}

